/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import rice.p2p.util.MathUtils;
import rice.p2p.util.XMLObjectInputStream;
import rice.p2p.util.XMLObjectOutputStream;

public class SecurityUtils {
    public static final String ASYMMETRIC_ALGORITHM = "RSA/ECB/OAEPPadding";
    public static final String DEPRECATED_ASYMMETRIC_ALGORITHM = "RSA";
    public static final String SYMMETRIC_ALGORITHM = "DES";
    public static final String ASYMMETRIC_GENERATOR = "RSA";
    public static final String SYMMETRIC_GENERATOR = "DES";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    public static final int SYMMETRIC_KEY_LENGTH = 56;
    public static final int SYMMETRIC_IV_LENGTH = 64;
    public static final String HASH_ALGORITHM = "SHA1";
    public static final String HMAC_ALGORITHM = "MD5";
    public static final String APOP_ALGORITHM = "MD5";
    public static final int HMAC_KEY_LENGTH = 64;
    public static final byte HMAC_IPAD_BYTE = 54;
    public static final byte HMAC_OPAD_BYTE = 92;
    public static final byte[] HMAC_IPAD = new byte[64];
    public static final byte[] HMAC_OPAD = new byte[64];
    private static MessageDigest hash;
    private static MessageDigest apop;
    private static MessageDigest hmac1;
    private static MessageDigest hmac2;
    private static Cipher cipherSymmetric;
    private static Cipher cipherAsymmetric;
    private static Cipher deprecatedCipherAsymmetric;
    private static KeyGenerator generatorSymmetric;
    private static KeyPairGenerator generatorAsymmetric;
    private static KeyFactory factoryAsymmetric;
    private static Signature signature;
    private static Random random;

    private SecurityUtils() {
    }

    public static byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLObjectOutputStream oos = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(baos)));
        oos.writeObject(o);
        ((ObjectOutputStream)oos).flush();
        ((ObjectOutputStream)oos).close();
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        XMLObjectInputStream ois = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(bais)));
        return ois.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(byte[] input) throws SecurityException {
        MessageDigest messageDigest = hash;
        synchronized (messageDigest) {
            return hash.digest(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] apop(byte[] challenge, byte[] password) throws SecurityException {
        MessageDigest messageDigest = apop;
        synchronized (messageDigest) {
            apop.update(challenge);
            apop.update(password);
            return apop.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hmac(byte[] key, byte[] text) throws SecurityException {
        MessageDigest messageDigest = hmac1;
        synchronized (messageDigest) {
            byte[] realKey = new byte[64];
            System.arraycopy(key, 0, realKey, 0, key.length < realKey.length ? key.length : realKey.length);
            hmac1.update(MathUtils.xor(realKey, HMAC_IPAD));
            hmac1.update(text);
            hmac2.update(MathUtils.xor(realKey, HMAC_OPAD));
            hmac2.update(hmac1.digest());
            return hmac2.digest();
        }
    }

    public static byte[] encryptSymmetric(byte[] data, byte[] key) throws SecurityException {
        return SecurityUtils.encryptSymmetric(data, key, new byte[64]);
    }

    public static byte[] encryptSymmetric(byte[] data, byte[] key, byte[] iv) throws SecurityException {
        return SecurityUtils.encryptSymmetric(data, key, 0, data.length, iv);
    }

    public static byte[] encryptSymmetric(byte[] data, byte[] key, int offset, int length) throws SecurityException {
        return SecurityUtils.encryptSymmetric(data, key, offset, length, new byte[64]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptSymmetric(byte[] data, byte[] key, int offset, int length, byte[] iv) throws SecurityException {
        try {
            iv = SecurityUtils.correctLength(iv, 8);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec secretKey = new SecretKeySpec(key, "DES");
            Cipher cipher = cipherSymmetric;
            synchronized (cipher) {
                cipherSymmetric.init(1, (Key)secretKey, ivSpec);
                return cipherSymmetric.doFinal(data, offset, length);
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityException("InvalidKeyException (" + iv.length + "," + key.length + ") encrypting object: " + e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityException("IllegalBlockSizeException encrypting object: " + e);
        }
        catch (BadPaddingException e) {
            throw new SecurityException("BadPaddingException encrypting object: " + e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SecurityException("InvalidAlgorithmParameterException encrypting object: " + e);
        }
    }

    public static byte[] decryptSymmetric(byte[] data, byte[] key) throws SecurityException {
        return SecurityUtils.decryptSymmetric(data, key, new byte[64]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decryptSymmetric(byte[] data, byte[] key, byte[] iv) throws SecurityException {
        try {
            iv = SecurityUtils.correctLength(iv, 8);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec secretKey = new SecretKeySpec(key, "DES");
            Cipher cipher = cipherSymmetric;
            synchronized (cipher) {
                cipherSymmetric.init(2, (Key)secretKey, ivSpec);
                return cipherSymmetric.doFinal(data);
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityException("InvalidKeyException decrypting object: " + e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityException("IllegalBlockSizeException decrypting object: " + e);
        }
        catch (BadPaddingException e) {
            throw new SecurityException("BadPaddingException decrypting object: " + e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SecurityException("InvalidAlgorithmParameterException decrypting object: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sign(byte[] data, PrivateKey key) throws SecurityException {
        try {
            Signature signature = SecurityUtils.signature;
            synchronized (signature) {
                SecurityUtils.signature.initSign(key);
                SecurityUtils.signature.update(SecurityUtils.hash(data));
                return SecurityUtils.signature.sign();
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityException("InvalidKeyException signing object: " + e);
        }
        catch (SignatureException e) {
            throw new SecurityException("SignatureException signing object: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verify(byte[] data, byte[] sig, PublicKey key) throws SecurityException {
        try {
            Signature signature = SecurityUtils.signature;
            synchronized (signature) {
                SecurityUtils.signature.initVerify(key);
                SecurityUtils.signature.update(SecurityUtils.hash(data));
                return SecurityUtils.signature.verify(sig);
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityException("InvalidKeyException verifying object: " + e);
        }
        catch (SignatureException e) {
            throw new SecurityException("SignatureException verifying object: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptAsymmetric(byte[] data, PublicKey key) throws SecurityException {
        try {
            Cipher cipher = cipherAsymmetric;
            synchronized (cipher) {
                cipherAsymmetric.init(1, key);
                return cipherAsymmetric.doFinal(data);
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityException("InvalidKeyException encrypting object: " + e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityException("IllegalBlockSizeException encrypting object: " + e);
        }
        catch (BadPaddingException e) {
            throw new SecurityException("BadPaddingException encrypting object: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decryptAsymmetric(byte[] data, PrivateKey key) throws SecurityException {
        try {
            try {
                Cipher cipher = cipherAsymmetric;
                synchronized (cipher) {
                    cipherAsymmetric.init(2, key);
                    return cipherAsymmetric.doFinal(data);
                }
            }
            catch (BadPaddingException e) {
                Cipher cipher = deprecatedCipherAsymmetric;
                synchronized (cipher) {
                    deprecatedCipherAsymmetric.init(2, key);
                    return deprecatedCipherAsymmetric.doFinal(data);
                }
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityException("InvalidKeyException decrypting object: " + e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityException("IllegalBlockSizeException decrypting object: " + e);
        }
        catch (BadPaddingException e) {
            throw new SecurityException("BadPaddingException decrypting object: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateKeySymmetric() {
        KeyGenerator keyGenerator = generatorSymmetric;
        synchronized (keyGenerator) {
            return generatorSymmetric.generateKey().getEncoded();
        }
    }

    public static byte[] encodePublicKey(PublicKey key) {
        RSAPublicKey rkey = (RSAPublicKey)key;
        byte[] modulus = rkey.getModulus().toByteArray();
        byte[] exponent = rkey.getPublicExponent().toByteArray();
        byte[] length = MathUtils.intToByteArray(modulus.length);
        byte[] result = new byte[length.length + modulus.length + exponent.length];
        System.arraycopy(length, 0, result, 0, length.length);
        System.arraycopy(modulus, 0, result, length.length, modulus.length);
        System.arraycopy(exponent, 0, result, length.length + modulus.length, exponent.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey decodePublicKey(byte[] data) throws SecurityException {
        byte[] len = new byte[4];
        System.arraycopy(data, 0, len, 0, len.length);
        int length = MathUtils.byteArrayToInt(len);
        byte[] modulus = new byte[length];
        System.arraycopy(data, len.length, modulus, 0, length);
        byte[] exponent = new byte[data.length - length - 4];
        System.arraycopy(data, len.length + length, exponent, 0, exponent.length);
        RSAPublicKeySpec rpks = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(exponent));
        try {
            KeyFactory keyFactory = factoryAsymmetric;
            synchronized (keyFactory) {
                return factoryAsymmetric.generatePublic(rpks);
            }
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException("InvalidKeySpecException while decoding key: " + e);
        }
    }

    public static byte[] encodePrivateKey(PrivateKey key) {
        RSAPrivateKey rkey = (RSAPrivateKey)key;
        byte[] modulus = rkey.getModulus().toByteArray();
        byte[] exponent = rkey.getPrivateExponent().toByteArray();
        byte[] length = MathUtils.intToByteArray(modulus.length);
        byte[] result = new byte[length.length + modulus.length + exponent.length];
        System.arraycopy(length, 0, result, 0, length.length);
        System.arraycopy(modulus, 0, result, length.length, modulus.length);
        System.arraycopy(exponent, 0, result, length.length + modulus.length, exponent.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey decodePrivateKey(byte[] data) throws SecurityException {
        byte[] len = new byte[4];
        System.arraycopy(data, 0, len, 0, len.length);
        int length = MathUtils.byteArrayToInt(len);
        byte[] modulus = new byte[length];
        System.arraycopy(data, len.length, modulus, 0, length);
        byte[] exponent = new byte[data.length - length - 4];
        System.arraycopy(data, len.length + length, exponent, 0, exponent.length);
        RSAPrivateKeySpec rpks = new RSAPrivateKeySpec(new BigInteger(modulus), new BigInteger(exponent));
        try {
            KeyFactory keyFactory = factoryAsymmetric;
            synchronized (keyFactory) {
                return factoryAsymmetric.generatePrivate(rpks);
            }
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException("InvalidKeySpecException while decoding key: " + e);
        }
    }

    public static byte[] generateIVSymmetric() {
        byte[] result = new byte[64];
        random.nextBytes(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateKeyAsymmetric() {
        KeyPairGenerator keyPairGenerator = generatorAsymmetric;
        synchronized (keyPairGenerator) {
            return generatorAsymmetric.generateKeyPair();
        }
    }

    private static byte[] correctLength(byte[] data, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < data.length && i < result.length; ++i) {
            result[i] = data[i];
        }
        return result;
    }

    static {
        Arrays.fill(HMAC_IPAD, (byte)54);
        Arrays.fill(HMAC_OPAD, (byte)92);
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        try {
            random = new Random();
            cipherSymmetric = Cipher.getInstance("DES");
            cipherAsymmetric = Cipher.getInstance(ASYMMETRIC_ALGORITHM, "BC");
            deprecatedCipherAsymmetric = Cipher.getInstance("RSA");
            generatorSymmetric = KeyGenerator.getInstance("DES");
            generatorAsymmetric = KeyPairGenerator.getInstance("RSA");
            factoryAsymmetric = KeyFactory.getInstance("RSA");
            signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            hash = MessageDigest.getInstance(HASH_ALGORITHM);
            apop = MessageDigest.getInstance("MD5");
            hmac1 = MessageDigest.getInstance("MD5");
            hmac2 = MessageDigest.getInstance("MD5");
            generatorSymmetric.init(56);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("NoSuchAlgorithmException on construction: " + e);
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityException("NoSuchPaddingException on construction: " + e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("NoSuchProviderException on construction: " + e);
        }
    }
}

