/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import rice.p2p.util.SecurityUtils;

public class EncryptedInputStream
extends InputStream {
    protected PrivateKey privateKey;
    protected byte[] key;
    protected DataInputStream stream;
    protected byte[] buffer;
    protected int bufferLength;

    public EncryptedInputStream(PrivateKey privateKey, InputStream stream) throws IOException {
        this.privateKey = privateKey;
        this.stream = new DataInputStream(stream);
        this.readHeader();
    }

    private void readHeader() throws IOException {
        byte[] enckey = new byte[this.stream.readInt()];
        this.stream.readFully(enckey);
        this.key = SecurityUtils.decryptAsymmetric(enckey, this.privateKey);
    }

    public int read() throws IOException {
        if (this.buffer != null && this.bufferLength < this.buffer.length) {
            ++this.bufferLength;
            return this.buffer[this.bufferLength - 1] & 0xFF;
        }
        this.readBuffer();
        return this.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer != null && this.bufferLength < this.buffer.length) {
            int l = len > this.available() ? this.available() : len;
            System.arraycopy(this.buffer, this.bufferLength, b, off, l);
            this.bufferLength += l;
            return l;
        }
        this.readBuffer();
        return this.read(b, off, len);
    }

    protected void readBuffer() throws IOException {
        byte[] encdata = new byte[this.stream.readInt()];
        this.stream.readFully(encdata);
        this.buffer = SecurityUtils.decryptSymmetric(encdata, this.key);
        this.bufferLength = 0;
    }

    public int available() throws IOException {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length - this.bufferLength;
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

