/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.splitstream.testing;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.Random;
import rice.environment.Environment;
import rice.p2p.splitstream.ChannelId;
import rice.p2p.splitstream.testing.MySplitStreamClient;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public class SplitStreamDistTest {
    public static final int DEFAULT_PORT = 53245;
    public static final int WAIT_TO_JOIN_DELAY = 3000;
    public static final int WAIT_TO_SUBSCRIBE_DELAY = 3000;
    public static final int IM_ALIVE_PERIOD = 5000;
    public static String INSTANCE = "DistSplitStreamTest";
    public static final String BOOTNODE = "swsao9509";
    public static final boolean nameSelf = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InetSocketAddress bootaddress;
        RandomNodeIdFactory nidFactory;
        SocketPastryNodeFactory factory;
        NodeHandle bootHandle;
        String suffix = "";
        suffix = suffix + "." + InetAddress.getLocalHost().getHostName();
        String outfileString = "ss.txt" + suffix;
        PrintStream ps = new PrintStream(new FileOutputStream(outfileString, true));
        System.setErr(ps);
        System.setOut(ps);
        final Environment env = new Environment();
        System.out.println("BOOTUP:" + env.getTimeSource().currentTimeMillis());
        boolean artificialChurn = false;
        if (args.length > 0) {
            // empty if block
        }
        String bootNode = BOOTNODE;
        if (args.length > 1) {
            bootNode = args[1];
        }
        int port = 53245;
        if (args.length > 2) {
            port = Integer.parseInt(args[2]);
        }
        boolean isBootNode = false;
        InetAddress localAddress = InetAddress.getLocalHost();
        if (localAddress.getHostName().startsWith(bootNode)) {
            isBootNode = true;
        }
        System.out.println("isBootNode:" + isBootNode);
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    System.out.println("ImALIVE:" + env.getTimeSource().currentTimeMillis());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }, "ImALIVE").start();
        if (!isBootNode) {
            int waitTime = env.getRandomSource().nextInt(3000);
            System.out.println("Waiting for " + waitTime + " millis before continuing..." + env.getTimeSource().currentTimeMillis());
            Thread.sleep(waitTime);
            System.out.println("Starting connection process " + env.getTimeSource().currentTimeMillis());
        }
        boolean success = false;
        while (!success) {
            try {
                InetSocketAddress bindAddress = new InetSocketAddress(InetAddress.getLocalHost(), port);
                DatagramChannel channel = DatagramChannel.open();
                channel.configureBlocking(false);
                channel.socket().bind(bindAddress);
                channel.close();
                ServerSocketChannel channel1 = ServerSocketChannel.open();
                channel1.configureBlocking(false);
                channel1.socket().bind(bindAddress);
                channel1.close();
                success = true;
            }
            catch (Exception e) {
                System.out.println("Couldn't bind on port " + port + " trying " + (port + 1));
                ++port;
            }
        }
        InetAddress bootaddr = InetAddress.getByName(bootNode);
        int bootport = port;
        if (args.length > 3) {
            bootport = Integer.parseInt(args[3]);
        }
        if ((bootHandle = (factory = new SocketPastryNodeFactory(nidFactory = new RandomNodeIdFactory(env), port, env)).getNodeHandle(bootaddress = new InetSocketAddress(bootaddr, bootport))) == null && !isBootNode) {
            System.out.println("Couldn't find bootstrap... exiting.");
            System.exit(23);
        }
        final PastryNode node = ((PastryNodeFactory)factory).newNode(bootHandle);
        System.out.println("Node " + node + " created.");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("SHUTDOWN " + env.getTimeSource().currentTimeMillis() + " " + node);
            }
        });
        PastryNode pastryNode = node;
        synchronized (pastryNode) {
            while (!node.isReady()) {
                System.out.println("Waiting for node to go ready.  " + env.getTimeSource().currentTimeMillis());
                node.wait(5000L);
            }
        }
        MySplitStreamClient app = new MySplitStreamClient(node, INSTANCE);
        ChannelId CHANNEL_ID = new ChannelId(SplitStreamDistTest.generateId());
        app.attachChannel(CHANNEL_ID);
        if (!isBootNode) {
            System.out.println("Sleeping(2) for 3000 at " + env.getTimeSource().currentTimeMillis());
            Thread.sleep(3000L);
            System.out.println("Done(2) sleeping at " + env.getTimeSource().currentTimeMillis());
        }
        app.subscribeToAllChannels();
        app.startPublishTask();
        if (artificialChurn) {
            while (true) {
                Thread.sleep(60000L);
                if (isBootNode || env.getRandomSource().nextInt(60) != 0) continue;
                System.out.println("Killing self to cause churn. " + env.getTimeSource().currentTimeMillis() + ":" + node);
                System.exit(25);
            }
        }
    }

    private static Id generateId() {
        byte[] data = new byte[20];
        new Random(100L).nextBytes(data);
        return Id.build(data);
    }
}

