/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.scribe.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsubscribeMessage
implements RawMessage {
    public static final short TYPE = 10;
    NodeHandle source;
    List<Topic> topics;

    public UnsubscribeMessage(NodeHandle source, List<Topic> topics) {
        this.source = source;
        this.topics = topics;
    }

    @Override
    public int getPriority() {
        return -5;
    }

    public NodeHandle getSource() {
        return this.source;
    }

    public List<Topic> getTopics() {
        return this.topics;
    }

    @Override
    public short getType() {
        return 10;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)1);
        boolean hasSource = this.source != null;
        buf.writeBoolean(hasSource);
        if (hasSource) {
            this.source.serialize(buf);
        }
        buf.writeInt(this.topics.size());
        for (Topic topic : this.topics) {
            topic.serialize(buf);
        }
    }

    public static UnsubscribeMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return null;
            }
            case 1: {
                return new UnsubscribeMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private UnsubscribeMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        if (buf.readBoolean()) {
            this.source = endpoint.readNodeHandle(buf);
        }
        int numTopics = buf.readInt();
        this.topics = new ArrayList<Topic>(numTopics);
        for (int i = 0; i < numTopics; ++i) {
            this.topics.add(new Topic(buf, endpoint));
        }
    }
}

