/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AnycastMessage;
import rice.p2p.scribe.rawserialization.RawScribeContent;
import rice.p2p.scribe.rawserialization.ScribeContentDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeMessage
extends AnycastMessage {
    public static final short TYPE = 2;
    protected NodeHandle subscriber;
    protected int id;
    List<Topic> topics;

    public SubscribeMessage(NodeHandle source, List<Topic> topics, int id, RawScribeContent content) {
        super(source, topics.iterator().next(), content);
        this.id = id;
        this.subscriber = source;
        this.topics = new ArrayList<Topic>(topics);
    }

    public SubscribeMessage(NodeHandle source, Topic topic, int id, RawScribeContent content) {
        this(source, Collections.singletonList(topic), id, content);
    }

    public NodeHandle getSubscriber() {
        return this.subscriber;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return "[SubscribeMessage{" + System.identityHashCode(this) + "} " + this.topic + " subscriber " + this.subscriber + " ID " + this.id + "]";
    }

    @Override
    public short getType() {
        return 2;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)1);
        super.serializeHelper(buf);
        buf.writeInt(this.id);
        this.subscriber.serialize(buf);
        int numTopics = this.topics.size();
        buf.writeInt(numTopics);
        if (numTopics > 1) {
            Iterator<Topic> i = this.topics.iterator();
            i.next();
            while (i.hasNext()) {
                i.next().serialize(buf);
            }
        }
    }

    public static SubscribeMessage buildSM(InputBuffer buf, Endpoint endpoint, ScribeContentDeserializer scd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return null;
            }
            case 1: {
                return new SubscribeMessage(buf, endpoint, scd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private SubscribeMessage(InputBuffer buf, Endpoint endpoint, ScribeContentDeserializer contentDeserializer) throws IOException {
        super(buf, endpoint, contentDeserializer);
        this.id = buf.readInt();
        this.subscriber = endpoint.readNodeHandle(buf);
        int numTopics = buf.readInt();
        this.topics = new ArrayList<Topic>(numTopics);
        this.topics.add(this.getTopic());
        for (int i = 1; i < numTopics; ++i) {
            this.topics.add(new Topic(buf, endpoint));
        }
    }

    public void removeTopics(Collection<Topic> accepted) {
        this.topics.removeAll(accepted);
        this.topic = this.topics.isEmpty() ? null : this.topics.get(0);
    }

    public List<Topic> getTopics() {
        return this.topics;
    }

    public boolean isEmpty() {
        return this.topics.isEmpty();
    }

    public SubscribeMessage copy(List<Topic> newTopics, RawScribeContent content) {
        SubscribeMessage ret = new SubscribeMessage(this.getSource(), newTopics, this.getId(), content);
        ret.visited = this.visited;
        ret.toVisit = this.toVisit;
        ret.subscriber = this.subscriber;
        return ret;
    }
}

