/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AbstractSubscribeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeFailedMessage
extends AbstractSubscribeMessage {
    public static final short TYPE = 4;

    public SubscribeFailedMessage(NodeHandle source, List<Topic> topics, int id) {
        super(source, topics, id);
    }

    @Override
    public short getType() {
        return 4;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)1);
        super.serialize(buf);
        int numTopics = this.topics.size();
        buf.writeInt(numTopics);
        Iterator i = this.topics.iterator();
        while (i.hasNext()) {
            ((Topic)i.next()).serialize(buf);
        }
    }

    public static SubscribeFailedMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return null;
            }
            case 1: {
                return new SubscribeFailedMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private SubscribeFailedMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int numTopics = buf.readInt();
        this.topics = new ArrayList(numTopics);
        for (int i = 0; i < numTopics; ++i) {
            this.topics.add(new Topic(buf, endpoint));
        }
    }
}

