/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import java.util.List;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.scribe.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubscribeMessage
implements RawMessage {
    protected int id;
    protected NodeHandle source;
    protected List<Topic> topics;

    public AbstractSubscribeMessage(NodeHandle source, List<Topic> topics, int id) {
        this.source = source;
        this.id = id;
        this.topics = topics;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int getPriority() {
        return -5;
    }

    public NodeHandle getSource() {
        return this.source;
    }

    public List<Topic> getTopics() {
        return this.topics;
    }

    public String toString() {
        String s = this.source + "," + this.id;
        if (this.topics.size() <= 3) {
            for (Topic topic : this.topics) {
                s = s + " " + topic;
            }
        } else {
            s = s + " numTopics:" + this.topics.size();
        }
        return s;
    }

    protected AbstractSubscribeMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.source = endpoint.readNodeHandle(buf);
        this.id = buf.readInt();
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        this.source.serialize(buf);
        buf.writeInt(this.id);
    }
}

