/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.replication.messaging.ReplicationMessage;

public class ResponseMessage
extends ReplicationMessage {
    public static final short TYPE = 3;
    protected IdRange[] ranges;
    protected Id[][] ids;

    public ResponseMessage(NodeHandle source, IdRange[] ranges, IdSet[] setA) {
        super(source);
        this.ranges = ranges;
        this.ids = new Id[setA.length][];
        for (int i = 0; i < setA.length; ++i) {
            this.ids[i] = setA[i].asArray();
        }
    }

    public IdRange[] getRanges() {
        return this.ranges;
    }

    public Id[][] getIdSets() {
        return this.ids;
    }

    public String toString() {
        int numResponses = 0;
        for (int a = 0; a < this.ids.length; ++a) {
            numResponses += this.ids[a].length;
        }
        return "ResponseMessage(" + this.getSource() + "):" + numResponses;
    }

    public short getType() {
        return 3;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        int i;
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.ids.length);
        for (i = 0; i < this.ids.length; ++i) {
            Id[] thisRow = this.ids[i];
            buf.writeInt(thisRow.length);
            for (int j = 0; j < thisRow.length; ++j) {
                buf.writeShort(thisRow[j].getType());
                thisRow[j].serialize(buf);
            }
        }
        buf.writeInt(this.ranges.length);
        for (i = 0; i < this.ranges.length; ++i) {
            this.ranges[i].serialize(buf);
        }
    }

    public static ResponseMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new ResponseMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private ResponseMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int i;
        this.ids = new Id[buf.readInt()][];
        for (i = 0; i < this.ids.length; ++i) {
            this.ids[i] = new Id[buf.readInt()];
            for (int j = 0; j < this.ids[i].length; ++j) {
                this.ids[i][j] = endpoint.readId(buf, buf.readShort());
            }
        }
        this.ranges = new IdRange[buf.readInt()];
        for (i = 0; i < this.ranges.length; ++i) {
            this.ranges[i] = endpoint.readIdRange(buf);
        }
    }
}

