/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.IOException;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;

public abstract class PastMessage
implements RawMessage {
    private static final long serialVersionUID = -7195054010358285316L;
    protected int id;
    protected NodeHandle source;
    protected Id dest;
    protected boolean isResponse;

    protected PastMessage(int id, NodeHandle source, Id dest) {
        this.id = id;
        this.source = source;
        this.dest = dest;
        this.isResponse = false;
    }

    public int getPriority() {
        return -5;
    }

    public int getUID() {
        return this.id;
    }

    public NodeHandle getSource() {
        return this.source;
    }

    public Id getDestination() {
        return this.dest;
    }

    protected void setResponse() {
        this.isResponse = true;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public abstract void returnResponse(Continuation var1, Environment var2, String var3);

    public void addHop(NodeHandle handle) {
    }

    public PastMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.id = buf.readInt();
        this.dest = endpoint.readId(buf, buf.readShort());
        this.source = endpoint.readNodeHandle(buf);
        this.isResponse = buf.readBoolean();
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeInt(this.id);
        buf.writeShort(this.dest.getType());
        this.dest.serialize(buf);
        this.source.serialize(buf);
        buf.writeBoolean(this.isResponse);
    }
}

