/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.IOException;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.PastContent;
import rice.p2p.past.messaging.PastMessage;
import rice.p2p.past.rawserialization.JavaSerializedPastContent;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;

public class CacheMessage
extends PastMessage {
    public static final short TYPE = 1;
    protected RawPastContent content;

    public CacheMessage(int uid, PastContent content, NodeHandle source, Id dest) {
        this(uid, content instanceof RawPastContent ? (RawPastContent)content : new JavaSerializedPastContent(content), source, dest);
    }

    public CacheMessage(int uid, RawPastContent content, NodeHandle source, Id dest) {
        super(uid, source, dest);
        this.content = content;
    }

    public PastContent getContent() {
        if (this.content.getType() == 0) {
            return ((JavaSerializedPastContent)this.content).getContent();
        }
        return this.content;
    }

    public void returnResponse(Continuation c, Environment env, String instance) {
        throw new RuntimeException("ERROR: returnResponse should not be called on cacheMessage!");
    }

    public String toString() {
        return "[CacheMessage for " + this.content + "]";
    }

    public short getType() {
        return 1;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeShort(this.content.getType());
        this.content.serialize(buf);
    }

    public static CacheMessage build(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new CacheMessage(buf, endpoint, pcd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private CacheMessage(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
        super(buf, endpoint);
        short contentType = buf.readShort();
        this.content = contentType == 0 ? new JavaSerializedPastContent(pcd.deserializePastContent(buf, endpoint, contentType)) : (RawPastContent)pcd.deserializePastContent(buf, endpoint, contentType);
    }
}

