/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.gc;

import java.util.Iterator;
import java.util.SortedMap;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.past.gc.GCId;
import rice.p2p.past.gc.GCIdRange;
import rice.p2p.past.gc.GCPastMetadata;
import rice.p2p.util.RedBlackMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCIdSet
implements IdSet {
    protected IdSet ids;
    protected SortedMap timeouts;

    protected GCIdSet(IdFactory factory) {
        this.ids = factory.buildIdSet();
        this.timeouts = new RedBlackMap();
    }

    protected GCIdSet(IdSet set, SortedMap timeouts) {
        this.ids = set;
        this.timeouts = timeouts;
    }

    @Override
    public int numElements() {
        return this.ids.numElements();
    }

    @Override
    public void addId(Id id) {
        GCId gcid = (GCId)id;
        this.ids.addId(gcid.getId());
        this.timeouts.put(gcid.getId(), new GCPastMetadata(gcid.getExpiration()));
    }

    @Override
    public void removeId(Id id) {
        GCId gcid = (GCId)id;
        this.ids.removeId(gcid.getId());
        this.timeouts.remove(gcid.getId());
    }

    @Override
    public boolean isMemberId(Id id) {
        GCId gcid = (GCId)id;
        return this.ids.isMemberId(gcid.getId());
    }

    @Override
    public IdSet subSet(IdRange range) {
        return new GCIdSet(this.ids.subSet(((GCIdRange)range).getRange()), this.timeouts);
    }

    @Override
    public Iterator<Id> getIterator() {
        return new Iterator<Id>(){
            Iterator<Id> i;
            {
                this.i = GCIdSet.this.ids.getIterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Id next() {
                return GCIdSet.this.getGCId(this.i.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove on GCIdSet()!");
            }
        };
    }

    protected GCId getGCId(Id id) {
        GCPastMetadata metadata = (GCPastMetadata)this.timeouts.get(id);
        if (metadata != null) {
            return new GCId(id, metadata.getExpiration());
        }
        return new GCId(id, Long.MAX_VALUE);
    }

    @Override
    public Id[] asArray() {
        Id[] array = this.ids.asArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getGCId(array[i]);
        }
        return array;
    }

    @Override
    public byte[] hash() {
        throw new UnsupportedOperationException("hash on GCIdSet()!");
    }

    public boolean equals(Object o) {
        GCIdSet other = (GCIdSet)o;
        if (this.numElements() != other.numElements()) {
            return false;
        }
        Iterator<Id> i = this.ids.getIterator();
        while (i.hasNext()) {
            if (other.isMemberId(i.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.ids.hashCode();
    }

    public String toString() {
        return "{GCIdSet of size " + this.numElements() + "}";
    }

    @Override
    public Object clone() {
        return new GCIdSet(this.ids, this.timeouts);
    }

    @Override
    public IdSet build() {
        return new GCIdSet(this.ids.build(), new RedBlackMap());
    }
}

