/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.io.IOException;
import java.util.NoSuchElementException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.multiring.MultiringNodeHandle;
import rice.p2p.multiring.RingId;

public class MultiringNodeHandleSet
implements NodeHandleSet {
    public static final short TYPE = 10;
    protected NodeHandleSet set;
    protected Id ringId;

    protected MultiringNodeHandleSet(Id ringId, NodeHandleSet set) {
        this.ringId = ringId;
        this.set = set;
        if (ringId instanceof RingId || set instanceof MultiringNodeHandleSet) {
            throw new IllegalArgumentException("Illegal creation of MRNodeHandleSet: " + ringId.getClass() + ", " + set.getClass());
        }
    }

    protected NodeHandleSet getSet() {
        return this.set;
    }

    public boolean putHandle(NodeHandle handle) {
        return this.set.putHandle(((MultiringNodeHandle)handle).getHandle());
    }

    public NodeHandle getHandle(Id id) {
        NodeHandle handle = this.set.getHandle(((RingId)id).getId());
        if (handle != null) {
            return new MultiringNodeHandle(this.ringId, handle);
        }
        return null;
    }

    public NodeHandle getHandle(int i) {
        NodeHandle handle = this.set.getHandle(i);
        if (handle != null) {
            return new MultiringNodeHandle(this.ringId, handle);
        }
        return null;
    }

    public boolean memberHandle(Id id) {
        return this.set.memberHandle(((RingId)id).getId());
    }

    public NodeHandle removeHandle(Id id) {
        NodeHandle handle = this.set.removeHandle(((RingId)id).getId());
        if (handle != null) {
            return new MultiringNodeHandle(this.ringId, handle);
        }
        return null;
    }

    public int size() {
        return this.set.size();
    }

    public int getIndexHandle(Id id) throws NoSuchElementException {
        return this.set.getIndexHandle(((RingId)id).getId());
    }

    public boolean equals(Object o) {
        MultiringNodeHandleSet other = (MultiringNodeHandleSet)o;
        return other.getSet().equals(this.set) && other.ringId.equals(this.ringId);
    }

    public int hashCode() {
        return this.set.hashCode() + this.ringId.hashCode();
    }

    public String toString() {
        return "{RingId " + this.ringId + " " + this.set.toString() + "}";
    }

    public MultiringNodeHandleSet(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.ringId = endpoint.readId(buf, buf.readShort());
        short type = buf.readShort();
        this.set = endpoint.readNodeHandleSet(buf, type);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort(this.ringId.getType());
        this.ringId.serialize(buf);
        buf.writeShort(this.set.getType());
        this.set.serialize(buf);
    }

    public short getType() {
        return 10;
    }
}

