/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.util.Iterator;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.multiring.MultiringIdRange;
import rice.p2p.multiring.RingId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiringIdSet
implements IdSet {
    static final long serialVersionUID = -7675959536005571206L;
    protected IdSet set;
    protected Id ringId;

    protected MultiringIdSet(Id ringId, IdSet set) {
        this.ringId = ringId;
        this.set = set;
        if (ringId instanceof RingId || set instanceof MultiringIdSet) {
            throw new IllegalArgumentException("Illegal creation of MRIdSet: " + ringId.getClass() + ", " + set.getClass());
        }
    }

    protected IdSet getSet() {
        return this.set;
    }

    @Override
    public int numElements() {
        return this.set.numElements();
    }

    @Override
    public void addId(Id id) {
        this.set.addId(((RingId)id).getId());
    }

    @Override
    public void removeId(Id id) {
        this.set.removeId(((RingId)id).getId());
    }

    @Override
    public boolean isMemberId(Id id) {
        return this.set.isMemberId(((RingId)id).getId());
    }

    @Override
    public IdSet subSet(IdRange range) {
        if (range == null) {
            return (IdSet)this.clone();
        }
        return new MultiringIdSet(this.ringId, this.set.subSet(((MultiringIdRange)range).getRange()));
    }

    @Override
    public Iterator<Id> getIterator() {
        return new Iterator<Id>(){
            protected Iterator<Id> i;
            {
                this.i = MultiringIdSet.this.set.getIterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Id next() {
                return RingId.build(MultiringIdSet.this.ringId, this.i.next());
            }

            @Override
            public void remove() {
                this.i.remove();
            }
        };
    }

    @Override
    public Id[] asArray() {
        Id[] result = this.set.asArray();
        for (int i = 0; i < result.length; ++i) {
            result[i] = RingId.build(this.ringId, result[i]);
        }
        return result;
    }

    @Override
    public byte[] hash() {
        return this.set.hash();
    }

    public boolean equals(Object o) {
        MultiringIdSet other = (MultiringIdSet)o;
        return other.getSet().equals(this.set) && other.ringId.equals(this.ringId);
    }

    public int hashCode() {
        return this.set.hashCode() + this.ringId.hashCode();
    }

    public String toString() {
        return "{RingId " + this.ringId + " " + this.set.toString() + "}";
    }

    @Override
    public Object clone() {
        return new MultiringIdSet(this.ringId, (IdSet)this.set.clone());
    }

    @Override
    public IdSet build() {
        return new MultiringIdSet(this.ringId, this.set.build());
    }
}

