/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierRefreshCompleteMessage
extends GlacierMessage {
    public static final short TYPE = 9;
    protected VersionKey[] keys;
    protected int[] updates;

    public GlacierRefreshCompleteMessage(int uid, VersionKey[] keys, int[] updates, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, true, tag);
        this.keys = keys;
        this.updates = updates;
    }

    public int numKeys() {
        return this.keys.length;
    }

    public VersionKey getKey(int index) {
        return this.keys[index];
    }

    public long getUpdates(int index) {
        return this.updates[index];
    }

    public String toString() {
        return "[GlacierRefreshComplete for " + this.keys[0] + " (" + (this.numKeys() - 1) + " more keys)]";
    }

    public short getType() {
        return 9;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        int i;
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.updates.length);
        for (i = 0; i < this.updates.length; ++i) {
            buf.writeInt(this.updates[i]);
        }
        buf.writeInt(this.keys.length);
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i].serialize(buf);
        }
    }

    public static GlacierRefreshCompleteMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierRefreshCompleteMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private GlacierRefreshCompleteMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int i;
        this.updates = new int[buf.readInt()];
        for (i = 0; i < this.updates.length; ++i) {
            this.updates[i] = buf.readInt();
        }
        this.keys = new VersionKey[buf.readInt()];
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new VersionKey(buf, endpoint);
        }
    }
}

