/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.io.Serializable;
import rice.p2p.commonapi.Id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDescriptor
implements Serializable,
Comparable<ObjectDescriptor> {
    private static final long serialVersionUID = -3035115249019556223L;
    public Id key;
    public long version;
    public long currentLifetime;
    public long refreshedLifetime;
    public int size;

    public ObjectDescriptor(Id key, long version, long currentLifetime, long refreshedLifetime, int size) {
        this.key = key;
        this.currentLifetime = currentLifetime;
        this.refreshedLifetime = refreshedLifetime;
        this.size = size;
        this.version = version;
    }

    public String toString() {
        return "objDesc[" + this.key.toStringFull() + "v" + this.version + ", lt=" + this.currentLifetime + ", rt=" + this.refreshedLifetime + ", size=" + this.size + "]";
    }

    public boolean isAliveAt(long pointInTime) {
        return this.currentLifetime > pointInTime || this.refreshedLifetime > pointInTime;
    }

    @Override
    public int compareTo(ObjectDescriptor other) {
        ObjectDescriptor metadata = other;
        int result = this.key.compareTo(metadata.key);
        if (result != 0) {
            return result;
        }
        if (metadata.version > this.version) {
            return -1;
        }
        if (metadata.version < this.version) {
            return 1;
        }
        if (metadata.currentLifetime > this.currentLifetime) {
            return -1;
        }
        if (metadata.currentLifetime < this.currentLifetime) {
            return 1;
        }
        if (metadata.refreshedLifetime > this.refreshedLifetime) {
            return -1;
        }
        if (metadata.refreshedLifetime < this.refreshedLifetime) {
            return 1;
        }
        if (metadata.size > this.size) {
            return -1;
        }
        if (metadata.size < this.size) {
            return 1;
        }
        return 0;
    }
}

