/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.logging;

import java.io.IOException;
import java.io.OutputStream;
import rice.environment.Environment;
import rice.environment.logging.Logger;

public class LogOutputStream
extends OutputStream {
    protected Logger logger;
    protected byte[] buffer;
    protected int offset;
    protected int level;
    public static final int BUFFER_SIZE = 1024;

    public LogOutputStream(Environment env, int level) {
        this(env, level, "");
    }

    public LogOutputStream(Environment env, int level, String instance) {
        this.logger = env.getLogManager().getLogger(LogOutputStream.class, instance);
        this.buffer = new byte[1024];
        this.offset = 0;
        this.level = level;
    }

    public void write(int b) throws IOException {
        if (b == 10) {
            if (this.offset > 0 && this.buffer[this.offset - 1] == 13) {
                --this.offset;
            }
            this.flush();
            return;
        }
        if (this.offset > 0 && this.buffer[this.offset - 1] == 13) {
            --this.offset;
            this.flush();
        }
        if (this.offset == this.buffer.length - 1) {
            this.flush();
        }
        this.buffer[this.offset++] = (byte)(b & 0xFF);
    }

    public void flush() {
        if (this.offset == 0) {
            return;
        }
        if (this.logger.level <= this.level) {
            this.logger.log(new String(this.buffer, 0, this.offset));
        }
        this.offset = 0;
    }

    public void close() {
        this.flush();
    }
}

