/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.util.InsufficientBytesException;
import rice.p2p.commonapi.rawserialization.InputBuffer;

public class SocketInputBuffer
implements InputBuffer {
    P2PSocket socket;
    ByteBuffer readPtr;
    ByteBuffer writePtr;
    byte[] cache;
    ByteBuffer one;
    ByteBuffer two;
    ByteBuffer four;
    ByteBuffer eight;
    int initialSize;
    DataInputStream dis;

    public SocketInputBuffer(P2PSocket socket) {
        this(socket, 1024);
    }

    public SocketInputBuffer(P2PSocket socket, int size) {
        this.socket = socket;
        this.initialSize = size;
        this.cache = new byte[size];
        this.readPtr = ByteBuffer.wrap(this.cache);
        this.writePtr = ByteBuffer.wrap(this.cache);
        this.resetDis();
    }

    private void resetDis() {
        if (this.dis != null && this.dis.markSupported()) {
            try {
                this.dis.reset();
            }
            catch (IOException ioe) {
                this.dis = null;
                this.resetDis();
            }
            return;
        }
        this.dis = new DataInputStream(new InputStream(){

            public int read(byte[] b) throws IOException {
                return SocketInputBuffer.this.readInternal(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return SocketInputBuffer.this.readInternal(b, off, len);
            }

            public int read() throws IOException {
                return SocketInputBuffer.this.readInternal();
            }
        });
    }

    public int bytesRemaining() {
        return -2;
    }

    public void reset() {
        this.readPtr.clear();
    }

    public int size() {
        return this.writePtr.position();
    }

    public int readInternal(byte[] b, int off, int len) throws IOException {
        int bytesToRead = this.needBytes(len, false);
        this.readPtr.get(b, off, bytesToRead);
        return bytesToRead;
    }

    public int readInternal(byte[] b) throws IOException {
        int bytesToRead = this.needBytes(b.length, false);
        this.readPtr.get(b, 0, bytesToRead);
        return bytesToRead;
    }

    public int readInternal() throws IOException {
        this.needBytes(1, true);
        return this.readPtr.get() & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.dis.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.dis.read(b);
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    private int needBytes(int num, boolean fail) throws IOException {
        int ret;
        int bytesToReadIntoCache = num - (this.writePtr.position() - this.readPtr.position());
        if (bytesToReadIntoCache > 0) {
            this.readBytesIntoCache(bytesToReadIntoCache);
        }
        if ((ret = this.writePtr.position() - this.readPtr.position()) > num) {
            ret = num;
        }
        if (fail && ret < num) {
            this.reset();
            throw new InsufficientBytesException(num, ret);
        }
        return ret;
    }

    private int readBytesIntoCache(int num) throws IOException {
        ByteBuffer in;
        switch (num) {
            case 0: {
                return 0;
            }
            case 1: {
                if (this.one == null) {
                    this.one = ByteBuffer.allocate(num);
                }
                this.one.clear();
                in = this.one;
                break;
            }
            case 2: {
                if (this.two == null) {
                    this.two = ByteBuffer.allocate(num);
                }
                this.two.clear();
                in = this.two;
                break;
            }
            case 4: {
                if (this.four == null) {
                    this.four = ByteBuffer.allocate(num);
                }
                this.four.clear();
                in = this.four;
                break;
            }
            case 8: {
                if (this.eight == null) {
                    this.eight = ByteBuffer.allocate(num);
                }
                this.eight.clear();
                in = this.eight;
                break;
            }
            default: {
                in = ByteBuffer.allocate(num);
            }
        }
        int ret = (int)this.socket.read(in);
        if (ret == -1) {
            throw new ClosedChannelException("Socket " + this.socket + " is already closed. (during read)");
        }
        in.flip();
        while (this.writePtr.remaining() < ret) {
            this.grow();
        }
        this.writePtr.put(in);
        return ret;
    }

    public void clear() throws IOException {
        if (this.cache.length > this.initialSize) {
            this.cache = new byte[this.initialSize];
        }
        this.readPtr = ByteBuffer.wrap(this.cache);
        this.writePtr = ByteBuffer.wrap(this.cache);
        this.resetDis();
    }

    private void grow() {
        byte[] newCache = new byte[this.cache.length];
        System.arraycopy(this.cache, 0, newCache, 0, this.cache.length);
        ByteBuffer newReadPtr = ByteBuffer.wrap(newCache);
        ByteBuffer newWritePtr = ByteBuffer.wrap(newCache);
        newReadPtr.position(this.readPtr.position());
        newWritePtr.position(this.writePtr.position());
        this.cache = newCache;
        this.readPtr = newReadPtr;
        this.writePtr = newWritePtr;
    }
}

