/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.sourceroute.manager.simple;

import java.util.ArrayList;
import java.util.Collection;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteStrategy;
import org.mpisws.p2p.transport.sourceroute.manager.simple.NextHopStrategy;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.util.TimerWeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSourceRouteStrategy<Identifier>
implements SourceRouteStrategy<Identifier> {
    TimerWeakHashMap<Identifier, SourceRoute> routes;
    NextHopStrategy<Identifier> strategy;
    Environment environment;
    Logger logger;
    LivenessProvider<SourceRoute> livenessManager;
    SourceRouteFactory<Identifier> srFactory;
    Identifier localAddress;

    public SimpleSourceRouteStrategy(Identifier localAddress, SourceRouteFactory<Identifier> srFactory, NextHopStrategy<Identifier> strategy, Environment env) {
        this.localAddress = localAddress;
        this.srFactory = srFactory;
        this.strategy = strategy;
        this.environment = env;
        this.logger = this.environment.getLogManager().getLogger(SimpleSourceRouteStrategy.class, null);
        this.routes = new TimerWeakHashMap(this.environment.getSelectorManager(), 300000);
    }

    @Override
    public Collection<SourceRoute<Identifier>> getSourceRoutes(Identifier destination) {
        Collection<Identifier> nextHops = this.strategy.getNextHops(destination);
        ArrayList<SourceRoute<Identifier>> ret = new ArrayList<SourceRoute<Identifier>>(nextHops.size());
        for (Identifier intermediate : nextHops) {
            if (intermediate.equals(destination)) continue;
            ArrayList<Identifier> hopList = new ArrayList<Identifier>(3);
            hopList.add(this.localAddress);
            hopList.add(intermediate);
            hopList.add(destination);
            SourceRoute route = this.srFactory.getSourceRoute(hopList);
            ret.add(route);
        }
        return ret;
    }

    private SourceRoute<Identifier> getRoute(Identifier intermediate, Identifier dest) {
        SourceRoute<Identifier> route = (SourceRoute<Identifier>)this.routes.get(dest);
        if (route == null) {
            route = this.srFactory.getSourceRoute(this.localAddress, dest);
            this.routes.put(dest, route);
        }
        return route;
    }
}

