/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.rendezvous;

import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.rendezvous.EphemeralDB;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.time.TimeSource;
import rice.p2p.util.tuples.MutableTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EphemeralDBImpl<Identifier, HighIdentifier>
implements EphemeralDB<Identifier, HighIdentifier> {
    protected long STALE_PORT_TIME = 0x6DDD00L;
    TimeSource time;
    Logger logger;
    protected long nextTag = -9223372036854775807L;
    protected Map<HighIdentifier, Long> highToTag = new HashMap<HighIdentifier, Long>();
    protected Map<Identifier, Long> ephemeralToTag = new HashMap<Identifier, Long>();
    protected Map<Long, MutableTuple<Identifier, Long>> tagToEphemeral = new HashMap<Long, MutableTuple<Identifier, Long>>();

    public EphemeralDBImpl(Environment env, long stalePortTime) {
        this.time = env.getTimeSource();
        this.logger = env.getLogManager().getLogger(EphemeralDBImpl.class, null);
        this.STALE_PORT_TIME = stalePortTime;
    }

    @Override
    public void mapHighToTag(HighIdentifier high, long tag) {
        if (this.logger.level <= 500) {
            this.logger.log("mapHighToTag(" + high + "," + tag + ")");
        }
        this.highToTag.put(high, tag);
    }

    @Override
    public Identifier getEphemeral(HighIdentifier high) {
        Long tag = this.highToTag.get(high);
        if (tag == null) {
            if (this.logger.level <= 500) {
                this.logger.log("getEphemeral(" + high + "):null");
            }
            return null;
        }
        Identifier ret = this.getEphemeral(tag, null);
        if (ret == null) {
            this.highToTag.remove(high);
        }
        if (this.logger.level <= 500) {
            this.logger.log("getEphemeral(" + high + "):" + ret);
        }
        return ret;
    }

    @Override
    public Identifier getEphemeral(long tag, Identifier i) {
        MutableTuple<Identifier, Long> ret = this.tagToEphemeral.get(tag);
        if (ret == null) {
            if (this.logger.level <= 500) {
                this.logger.log("getEphemeral(" + tag + "," + i + "):" + i);
            }
            return i;
        }
        if ((Long)ret.b() < this.time.currentTimeMillis() - this.STALE_PORT_TIME) {
            this.clear(tag);
            if (this.logger.level <= 500) {
                this.logger.log("getEphemeral(" + tag + "," + i + "):" + i);
            }
            return i;
        }
        if (this.logger.level <= 500) {
            this.logger.log("getEphemeral(" + tag + "," + i + "):" + ret.a());
        }
        return (Identifier)ret.a();
    }

    @Override
    public long getTagForEphemeral(Identifier addr) {
        MutableTuple<Identifier, Long> ret;
        long now = this.time.currentTimeMillis();
        Long tag = this.ephemeralToTag.get(addr);
        if (tag != null) {
            ret = this.tagToEphemeral.get(tag);
            if ((Long)ret.b() < now - this.STALE_PORT_TIME) {
                this.clear(tag);
            } else {
                ret.setB(now);
                if (this.logger.level <= 500) {
                    this.logger.log("getTagForEphemeral(" + addr + "):" + tag);
                }
                return tag;
            }
        }
        tag = this.nextTag++;
        ret = new MutableTuple<Identifier, Long>(addr, now);
        this.ephemeralToTag.put(addr, tag);
        this.tagToEphemeral.put(tag, ret);
        if (this.logger.level <= 500) {
            this.logger.log("getTagForEphemeral(" + addr + "):" + tag);
        }
        return tag;
    }

    protected void clear(long tag) {
        if (this.logger.level <= 500) {
            this.logger.log("clear(" + tag + ")");
        }
        MutableTuple<Identifier, Long> ret = this.tagToEphemeral.remove(tag);
        this.ephemeralToTag.remove(ret.a());
    }
}

