/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.rc4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.AuthenticationException;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.rc4.EncryptedSocket;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RC4TransportLayer<Identifier, MsgType>
implements TransportLayer<Identifier, MsgType>,
TransportLayerCallback<Identifier, MsgType> {
    protected TransportLayer<Identifier, MsgType> tl;
    protected TransportLayerCallback<Identifier, MsgType> callback;
    protected Environment env;
    protected Logger logger;
    protected ErrorHandler<Identifier> errorHandler;
    protected MessageDigest md;
    public static final int KEY_LENGTH = 16;
    byte[] password;
    int PW_SEED_LENGTH;
    int WRITE_BUFFER_SIZE = 1024;
    RandomSource random;
    private static final String ALGORITHM = "RC4";

    public RC4TransportLayer(TransportLayer<Identifier, MsgType> tl, Environment env, String password, ErrorHandler<Identifier> errorHandler) throws NoSuchAlgorithmException {
        this(tl, env, password, 16, env.getRandomSource(), errorHandler);
    }

    public RC4TransportLayer(TransportLayer<Identifier, MsgType> tl, Environment env, String password, int pwSeedLength, RandomSource random, ErrorHandler<Identifier> errorHandler) throws NoSuchAlgorithmException {
        this.tl = tl;
        this.tl.setCallback(this);
        this.env = env;
        this.password = password.getBytes();
        this.PW_SEED_LENGTH = pwSeedLength;
        this.logger = env.getLogManager().getLogger(RC4TransportLayer.class, null);
        this.random = random;
        this.errorHandler = errorHandler;
        this.md = MessageDigest.getInstance("SHA");
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(final Identifier i, final SocketCallback<Identifier> deliverSocketToMe, final Map<String, Object> options) {
        final SocketRequestHandleImpl<Identifier> ret = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        ret.setSubCancellable(this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                deliverSocketToMe.receiveException(s, ex);
            }

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                final byte[] decryptSeed = new byte[RC4TransportLayer.this.PW_SEED_LENGTH];
                RC4TransportLayer.this.random.nextBytes(decryptSeed);
                P2PSocketReceiver writeDecryptSeedReceiver = new P2PSocketReceiver<Identifier>(){
                    ByteBuffer dsBB;
                    {
                        this.dsBB = ByteBuffer.wrap(decryptSeed);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                        long bytesWritten = socket.write(this.dsBB);
                        if (bytesWritten < 0L) {
                            socket.close();
                            deliverSocketToMe.receiveException(ret, new ClosedChannelException("Socket to " + i + " closed by remote host. " + ret));
                            return;
                        }
                        if (this.dsBB.hasRemaining()) {
                            socket.register(false, true, this);
                            return;
                        }
                        byte[] decryptKeyBytes = new byte[16];
                        MessageDigest messageDigest = RC4TransportLayer.this.md;
                        synchronized (messageDigest) {
                            RC4TransportLayer.this.md.update(RC4TransportLayer.this.password);
                            RC4TransportLayer.this.md.update(decryptSeed);
                            System.arraycopy(RC4TransportLayer.this.md.digest(), 0, decryptKeyBytes, 0, 16);
                        }
                        SecretKeySpec decryptKey = new SecretKeySpec(decryptKeyBytes, RC4TransportLayer.ALGORITHM);
                        try {
                            final Cipher decryptCipher = Cipher.getInstance(RC4TransportLayer.ALGORITHM);
                            decryptCipher.init(2, decryptKey);
                            P2PSocketReceiver readEncryptSeedReceiver = new P2PSocketReceiver<Identifier>(){
                                ByteBuffer encryptedSeeds;
                                {
                                    this.encryptedSeeds = ByteBuffer.allocate(RC4TransportLayer.this.PW_SEED_LENGTH * 2);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                                    long bytesRead = socket.read(this.encryptedSeeds);
                                    if (bytesRead < 0L) {
                                        socket.close();
                                        deliverSocketToMe.receiveException(ret, new ClosedChannelException("Socket to " + i + " closed by remote host. " + ret));
                                        return;
                                    }
                                    if (this.encryptedSeeds.hasRemaining()) {
                                        socket.register(true, false, this);
                                        return;
                                    }
                                    byte[] decryptedSeeds = decryptCipher.update(this.encryptedSeeds.array());
                                    boolean same = true;
                                    for (int ctr = 0; ctr < RC4TransportLayer.this.PW_SEED_LENGTH; ++ctr) {
                                        if (decryptedSeeds[ctr + RC4TransportLayer.this.PW_SEED_LENGTH] == decryptSeed[ctr]) continue;
                                        same = false;
                                        break;
                                    }
                                    if (!same) {
                                        socket.close();
                                        deliverSocketToMe.receiveException(ret, new AuthenticationException("Counterpart failed to properly encrypt his encryptSeed in the message."));
                                        return;
                                    }
                                    byte[] encryptSeed = new byte[RC4TransportLayer.this.PW_SEED_LENGTH];
                                    System.arraycopy(decryptedSeeds, 0, encryptSeed, 0, RC4TransportLayer.this.PW_SEED_LENGTH);
                                    byte[] encryptKeyBytes = new byte[16];
                                    MessageDigest messageDigest = RC4TransportLayer.this.md;
                                    synchronized (messageDigest) {
                                        RC4TransportLayer.this.md.update(RC4TransportLayer.this.password);
                                        RC4TransportLayer.this.md.update(encryptSeed);
                                        System.arraycopy(RC4TransportLayer.this.md.digest(), 0, encryptKeyBytes, 0, 16);
                                    }
                                    SecretKeySpec encryptKey = new SecretKeySpec(encryptKeyBytes, RC4TransportLayer.ALGORITHM);
                                    try {
                                        Cipher encryptCipher = Cipher.getInstance(RC4TransportLayer.ALGORITHM);
                                        encryptCipher.init(1, encryptKey);
                                        deliverSocketToMe.receiveResult(ret, new EncryptedSocket<Object>(i, socket, RC4TransportLayer.this.logger, RC4TransportLayer.this.errorHandler, options, encryptCipher, decryptCipher, RC4TransportLayer.this.WRITE_BUFFER_SIZE));
                                    }
                                    catch (GeneralSecurityException gse) {
                                        socket.close();
                                        deliverSocketToMe.receiveException(ret, gse);
                                    }
                                }

                                @Override
                                public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                                    deliverSocketToMe.receiveException(ret, ioe);
                                }
                            };
                            readEncryptSeedReceiver.receiveSelectResult(socket, true, false);
                        }
                        catch (GeneralSecurityException gse) {
                            socket.close();
                            deliverSocketToMe.receiveException(ret, gse);
                        }
                    }

                    @Override
                    public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                        deliverSocketToMe.receiveException(ret, ioe);
                    }
                };
                try {
                    writeDecryptSeedReceiver.receiveSelectResult(sock, false, true);
                }
                catch (IOException ioe) {
                    deliverSocketToMe.receiveException(ret, ioe);
                }
            }
        }, options));
        return ret;
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        new P2PSocketReceiver<Identifier>(){
            byte[] encryptSeed;
            ByteBuffer encryptSeedBuffer;
            {
                this.encryptSeed = new byte[RC4TransportLayer.this.PW_SEED_LENGTH];
                this.encryptSeedBuffer = ByteBuffer.wrap(this.encryptSeed);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                long ret = socket.read(this.encryptSeedBuffer);
                if (ret < 0L) {
                    socket.close();
                }
                if (this.encryptSeedBuffer.hasRemaining()) {
                    socket.register(true, false, this);
                    return;
                }
                byte[] encryptKeyBytes = new byte[16];
                MessageDigest messageDigest = RC4TransportLayer.this.md;
                synchronized (messageDigest) {
                    RC4TransportLayer.this.md.update(RC4TransportLayer.this.password);
                    RC4TransportLayer.this.md.update(this.encryptSeed);
                    System.arraycopy(RC4TransportLayer.this.md.digest(), 0, encryptKeyBytes, 0, 16);
                }
                SecretKeySpec encryptKey = new SecretKeySpec(encryptKeyBytes, RC4TransportLayer.ALGORITHM);
                try {
                    final Cipher encryptCipher = Cipher.getInstance(RC4TransportLayer.ALGORITHM);
                    encryptCipher.init(1, encryptKey);
                    byte[] decryptSeed = new byte[RC4TransportLayer.this.PW_SEED_LENGTH];
                    RC4TransportLayer.this.random.nextBytes(decryptSeed);
                    byte[] decryptKeyBytes = new byte[16];
                    MessageDigest messageDigest2 = RC4TransportLayer.this.md;
                    synchronized (messageDigest2) {
                        RC4TransportLayer.this.md.update(RC4TransportLayer.this.password);
                        RC4TransportLayer.this.md.update(decryptSeed);
                        System.arraycopy(RC4TransportLayer.this.md.digest(), 0, decryptKeyBytes, 0, 16);
                    }
                    SecretKeySpec decryptKey = new SecretKeySpec(decryptKeyBytes, RC4TransportLayer.ALGORITHM);
                    final Cipher decryptCipher = Cipher.getInstance(RC4TransportLayer.ALGORITHM);
                    decryptCipher.init(2, decryptKey);
                    byte[] encryptedSeeds = new byte[RC4TransportLayer.this.PW_SEED_LENGTH * 2];
                    encryptCipher.update(decryptSeed, 0, RC4TransportLayer.this.PW_SEED_LENGTH, encryptedSeeds, 0);
                    encryptCipher.update(this.encryptSeed, 0, RC4TransportLayer.this.PW_SEED_LENGTH, encryptedSeeds, RC4TransportLayer.this.PW_SEED_LENGTH);
                    final ByteBuffer encryptedSeedsBuffer = ByteBuffer.wrap(encryptedSeeds);
                    new P2PSocketReceiver<Identifier>(){

                        @Override
                        public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                            long ret = socket.write(encryptedSeedsBuffer);
                            if (ret < 0L) {
                                this.receiveException(socket, new ClosedChannelException("Channel closed while establishing crypto. " + socket));
                                return;
                            }
                            if (encryptedSeedsBuffer.hasRemaining()) {
                                socket.register(false, true, this);
                                return;
                            }
                            RC4TransportLayer.this.callback.incomingSocket(new EncryptedSocket(socket.getIdentifier(), socket, RC4TransportLayer.this.logger, RC4TransportLayer.this.errorHandler, socket.getOptions(), encryptCipher, decryptCipher, RC4TransportLayer.this.WRITE_BUFFER_SIZE));
                        }

                        @Override
                        public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                            RC4TransportLayer.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
                            socket.close();
                        }
                    }.receiveSelectResult(socket, false, true);
                }
                catch (GeneralSecurityException gse) {
                    socket.close();
                }
            }

            @Override
            public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                RC4TransportLayer.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
                socket.close();
            }
        }.receiveSelectResult(s, true, false);
    }

    @Override
    public MessageRequestHandle<Identifier, MsgType> sendMessage(Identifier i, MsgType m, MessageCallback<Identifier, MsgType> deliverAckToMe, Map<String, Object> options) {
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, MsgType> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void messageReceived(Identifier i, MsgType m, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(i, m, options);
    }
}

