/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.replay.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactoryImpl;
import org.mpisws.p2p.transport.peerreview.history.stub.NullHashProvider;
import org.mpisws.p2p.transport.peerreview.replay.record.RecordSM;
import org.mpisws.p2p.transport.peerreview.replay.record.RecordSocket;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.Serializer;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.simple.SimpleParameters;
import rice.environment.processing.Processor;
import rice.environment.processing.sim.SimProcessor;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.TimeSource;
import rice.environment.time.simple.SimpleTimeSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.p2p.util.MathUtils;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.selector.SelectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordLayer<Identifier>
implements PeerReviewConstants,
TransportLayer<Identifier, ByteBuffer>,
TransportLayerCallback<Identifier, ByteBuffer> {
    public static final String PR_RELEVANT_LEN = "pr_relevant_len";
    public static final String PR_RELEVANT_MSG = "pr_relevant_msg";
    Environment environment;
    TransportLayer<Identifier, ByteBuffer> tl;
    TransportLayerCallback<Identifier, ByteBuffer> callback;
    Serializer<Identifier> identifierSerializer;
    ErrorHandler<Identifier> handler;
    SecureHistory history;
    Logger logger;
    long lastLogEntry;
    boolean initialized = false;
    int socketCtr = Integer.MIN_VALUE;
    public static ByteBuffer ONE;
    public static ByteBuffer ZERO;

    public RecordLayer(TransportLayer<Identifier, ByteBuffer> tl, String name, Serializer<Identifier> serializer, Environment env) throws IOException {
        this.logger = env.getLogManager().getLogger(RecordLayer.class, null);
        this.identifierSerializer = serializer;
        NullHashProvider nhp = new NullHashProvider();
        SecureHistoryFactoryImpl shf = new SecureHistoryFactoryImpl(nhp, env);
        byte[] one = new byte[]{1};
        ONE = ByteBuffer.wrap(one);
        byte[] zero = new byte[]{0};
        ZERO = ByteBuffer.wrap(zero);
        this.tl = tl;
        this.tl.setCallback(this);
        this.history = shf.create(name, 0L, NullHashProvider.EMPTY_HASH);
        this.environment = env;
        this.lastLogEntry = -1L;
        this.handler = new DefaultErrorHandler(this.logger);
        this.initialized = true;
    }

    public void updateLogTime() {
        long now = this.environment.getTimeSource().currentTimeMillis();
        if (now > this.lastLogEntry) {
            if (!this.history.setNextSeq(now * 1000000L)) {
                throw new RuntimeException("PeerReview: Cannot roll back history sequence number from " + this.history.getLastSeq() + " to " + now * 1000000L + "; did you change the local time?");
            }
            this.lastLogEntry = now;
        }
    }

    public void logEvent(short type, ByteBuffer ... entry) throws IOException {
        if (this.history == null) {
            return;
        }
        if (this.logger.level <= 300) {
            this.logger.logException("logging #" + this.history.getNumEntries() + " t:" + type, new Exception("Stack Trace"));
        } else if (this.logger.level <= 400) {
            this.logger.log("logging #" + this.history.getNumEntries() + " t:" + type);
        }
        this.updateLogTime();
        this.history.appendEntry(type, true, entry);
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(final Identifier i, final SocketCallback<Identifier> deliverSocketToMe, final Map<String, Object> options) {
        ByteBuffer socketIdBuffer;
        int socketId;
        block2: {
            socketId = this.socketCtr++;
            socketIdBuffer = ByteBuffer.wrap(MathUtils.intToByteArray(socketId));
            try {
                SimpleOutputBuffer sob = new SimpleOutputBuffer();
                this.identifierSerializer.serialize(i, sob);
                this.logEvent((short)31, socketIdBuffer, sob.getByteBuffer());
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block2;
                this.logger.logException("openSocket(" + i + ")", ioe);
            }
        }
        final SocketRequestHandleImpl<Identifier> ret = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        ret.setSubCancellable(this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                block2: {
                    socketIdBuffer.clear();
                    try {
                        RecordLayer.this.logEvent((short)32, socketIdBuffer);
                    }
                    catch (IOException ioe) {
                        if (RecordLayer.this.logger.level > 900) break block2;
                        RecordLayer.this.logger.logException("error logging in openSocket(" + i + ")", ioe);
                    }
                }
                socketIdBuffer.clear();
                deliverSocketToMe.receiveResult(ret, new RecordSocket<Object>(i, sock, RecordLayer.this.logger, options, socketId, socketIdBuffer, RecordLayer.this));
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                block2: {
                    socketIdBuffer.clear();
                    try {
                        RecordLayer.this.logSocketException(socketIdBuffer, ex);
                    }
                    catch (IOException ioe) {
                        if (RecordLayer.this.logger.level > 900) break block2;
                        RecordLayer.this.logger.logException("openSocket(" + i + ")@" + socketId, ioe);
                    }
                }
                deliverSocketToMe.receiveException(ret, ex);
            }
        }, options));
        return ret;
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        ByteBuffer socketIdBuffer;
        int socketId;
        block2: {
            socketId = this.socketCtr++;
            socketIdBuffer = ByteBuffer.wrap(MathUtils.intToByteArray(socketId));
            try {
                socketIdBuffer.clear();
                SimpleOutputBuffer sob = new SimpleOutputBuffer();
                this.identifierSerializer.serialize(s.getIdentifier(), sob);
                this.logEvent((short)30, socketIdBuffer, sob.getByteBuffer());
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block2;
                this.logger.logException("incomingSocket(" + s.getIdentifier() + ")", ioe);
            }
        }
        this.callback.incomingSocket(new RecordSocket<Identifier>(s.getIdentifier(), s, this.logger, s.getOptions(), socketId, socketIdBuffer, this));
    }

    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(Identifier i, ByteBuffer m, MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        if (this.logger.level <= 300) {
            this.logger.logException("sendMessage(" + i + "," + m + "):" + MathUtils.toHex(m.array()), new Exception("Stack Trace"));
        } else if (this.logger.level <= 400) {
            this.logger.log("sendMessage(" + i + "," + m + "):" + MathUtils.toHex(m.array()));
        } else if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + i + "," + m + ")");
        }
        if (options == null || !options.containsKey(PR_RELEVANT_MSG) || (Integer)options.get(PR_RELEVANT_MSG) != 0) {
            int position;
            block9: {
                position = m.position();
                int relevantLen = m.remaining();
                if (options != null && options.containsKey(PR_RELEVANT_LEN) && (Integer)options.get(PR_RELEVANT_LEN) >= 0) {
                    relevantLen = (Integer)options.get(PR_RELEVANT_LEN);
                }
                try {
                    SimpleOutputBuffer sob = new SimpleOutputBuffer();
                    this.identifierSerializer.serialize(i, sob);
                    this.logEvent((short)0, sob.getByteBuffer(), m);
                }
                catch (IOException ioe) {
                    if (this.logger.level > 900) break block9;
                    this.logger.logException("sendMessage(" + i + "," + m + ")", ioe);
                }
            }
            m.position(position);
        }
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }

    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        block4: {
            try {
                if (this.identifierSerializer == null) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Dropping messageReceived(" + i + "," + m + ") while booting");
                    }
                    return;
                }
                SimpleOutputBuffer sob = new SimpleOutputBuffer();
                this.identifierSerializer.serialize(i, sob);
                this.logEvent((short)1, sob.getByteBuffer(), m);
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block4;
                this.logger.logException("messageReceived(" + i + "," + m + ")", ioe);
            }
        }
        this.callback.messageReceived(i, m, options);
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.handler = handler;
    }

    @Override
    public void destroy() {
        block3: {
            try {
                if (this.history != null) {
                    this.history.close();
                }
                this.history = null;
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block3;
                this.logger.logException("Error destroying.", ioe);
            }
        }
        this.tl.destroy();
    }

    public static Environment generateEnvironment() {
        return RecordLayer.generateEnvironment(null);
    }

    public static Environment generateEnvironment(int randomSeed) {
        SimpleRandomSource srs = new SimpleRandomSource(randomSeed, null);
        Environment env = RecordLayer.generateEnvironment(srs);
        srs.setLogManager(env.getLogManager());
        return env;
    }

    public static Environment generateEnvironment(RandomSource rs) {
        SimpleParameters params = new SimpleParameters(Environment.defaultParamFileArray, null);
        DirectTimeSource dts = new DirectTimeSource(System.currentTimeMillis());
        LogManager lm = Environment.generateDefaultLogManager(dts, params);
        dts.setLogManager(lm);
        RecordSM selector = new RecordSM("Default", new SimpleTimeSource(), dts, lm, rs);
        dts.setSelectorManager(selector);
        SimProcessor proc = new SimProcessor(selector);
        Environment ret = new Environment(selector, proc, rs, dts, lm, params, Environment.generateDefaultExceptionStrategy(lm)){

            public Environment cloneEnvironment(String prefix, boolean cloneSelector, boolean cloneProcessor) {
                DirectTimeSource dts = new DirectTimeSource(this.getTimeSource().currentTimeMillis());
                LogManager lman = this.getLogManager();
                if (lman instanceof CloneableLogManager) {
                    lman = ((CloneableLogManager)this.getLogManager()).clone(prefix, dts);
                }
                dts.setLogManager(lman);
                RandomSource rand = this.cloneRandomSource(lman);
                SelectorManager sman = this.cloneSelectorManager(prefix, dts, rand, lman, cloneSelector);
                Processor proc = this.cloneProcessor(prefix, lman, cloneProcessor);
                Environment ret = new Environment(sman, proc, rand, dts, lman, this.getParameters(), this.getExceptionStrategy());
                this.addDestructable(ret);
                return ret;
            }

            public Environment cloneEnvironment(String prefix) {
                return this.cloneEnvironment(prefix, true, true);
            }

            protected SelectorManager cloneSelectorManager(String prefix, TimeSource ts, RandomSource rs, LogManager lman, boolean cloneSelector) {
                SelectorManager sman = this.getSelectorManager();
                if (cloneSelector) {
                    sman = new RecordSM(prefix + " Selector", new SimpleTimeSource(), (DirectTimeSource)ts, lman, rs);
                }
                return sman;
            }

            protected TimeSource cloneTimeSource(LogManager manager) {
                throw new RuntimeException("Operation not allowed.  Use the overridden clone method.");
            }
        };
        return ret;
    }

    public void logSocketException(ByteBuffer socketId, Exception ioe) throws IOException {
        if (this.logger.level <= 700) {
            this.logger.logException("logSocketException(" + ioe + ")", ioe);
        }
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        String className = ioe.getClass().getName();
        if (className.endsWith("ClosedChannelException")) {
            sob.writeShort((short)2);
            sob.writeUTF(ioe.getMessage());
        } else if (className.equals("java.io.IOException")) {
            sob.writeShort((short)1);
            sob.writeUTF(ioe.getMessage());
        } else {
            sob.writeShort((short)0);
            sob.writeUTF(className);
            sob.writeUTF(ioe.getMessage());
        }
        ByteBuffer ioeBuffer = ByteBuffer.wrap(sob.getBytes());
        ioeBuffer.limit(sob.getWritten());
        this.logEvent((short)33, socketId, ioeBuffer);
    }
}

