/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.history.logentry;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.logentry.HistoryEvent;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvtRecv<Handle extends RawSerializable>
extends HistoryEvent {
    Handle senderHandle;
    long senderSeq;
    byte[] payload;
    byte[] hash;

    public EvtRecv(Handle senderHandle, long topSeq, ByteBuffer payload) {
        this.senderHandle = senderHandle;
        this.senderSeq = topSeq;
        this.payload = new byte[payload.remaining()];
        System.arraycopy(payload.array(), payload.position(), this.payload, 0, payload.remaining());
    }

    public EvtRecv(Handle senderHandle, long topSeq, ByteBuffer payload, int relevantLen, HashProvider hasher) {
        this.senderHandle = senderHandle;
        this.senderSeq = topSeq;
        this.payload = new byte[payload.remaining()];
        System.arraycopy(payload.array(), payload.position(), this.payload, 0, relevantLen);
        this.hash = hasher.hash(ByteBuffer.wrap(this.payload));
    }

    @Override
    public short getType() {
        return 1;
    }

    public EvtRecv(InputBuffer buf, Serializer<Handle> serializer, int hashSize) throws IOException {
        this.senderHandle = (RawSerializable)serializer.deserialize(buf);
        this.senderSeq = buf.readLong();
        boolean hashed = buf.readBoolean();
        int payloadLength = buf.bytesRemaining();
        if (hashed) {
            payloadLength -= hashSize;
        }
        this.payload = new byte[payloadLength];
        buf.read(this.payload);
        if (hashed) {
            this.hash = new byte[hashSize];
            buf.read(this.hash);
        }
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        this.senderHandle.serialize(buf);
        buf.writeLong(this.senderSeq);
        buf.writeBoolean(this.hash != null);
        buf.write(this.payload, 0, this.payload.length);
        if (this.hash != null) {
            buf.write(this.hash, 0, this.hash.length);
        }
    }

    public Handle getSenderHandle() {
        return this.senderHandle;
    }

    public long getSenderSeq() {
        return this.senderSeq;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] getHash() {
        return this.hash;
    }
}

