/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.evidence;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.audit.LogSnippet;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializer;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class ProofInconsistent
implements PeerReviewConstants,
Evidence {
    public static final byte NO_SNIPPET = 0;
    public static final byte LOG_SNIPPET = 1;
    public Authenticator auth1;
    public Authenticator auth2;
    public LogSnippet snippet;

    public ProofInconsistent(Authenticator auth1, Authenticator auth2) {
        this.auth1 = auth1;
        this.auth2 = auth2;
    }

    public ProofInconsistent(Authenticator auth1, Authenticator auth2, LogSnippet snippet) {
        this.auth1 = auth1;
        this.auth2 = auth2;
        this.snippet = snippet;
    }

    public short getEvidenceType() {
        return 3;
    }

    public ProofInconsistent(InputBuffer buf, AuthenticatorSerializer serializer, int hashSize) throws IOException {
        this.auth1 = serializer.deserialize(buf);
        byte type = buf.readByte();
        this.auth2 = serializer.deserialize(buf);
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                this.snippet = new LogSnippet(buf, hashSize);
                break;
            }
            default: {
                throw new IOException("unknown type:" + type);
            }
        }
    }

    public void serialize(OutputBuffer buf) throws IOException {
        this.auth1.serialize(buf);
        if (this.snippet == null) {
            buf.writeByte((byte)0);
        } else {
            buf.writeByte((byte)1);
        }
        this.auth2.serialize(buf);
        if (this.snippet != null) {
            this.snippet.serialize(buf);
        }
    }
}

