/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.commitment;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializer;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorStore;
import org.mpisws.p2p.transport.util.Serializer;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.RandomAccessFileIOBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticatorStoreImpl<Identifier extends RawSerializable>
implements AuthenticatorStore<Identifier> {
    protected boolean allowDuplicateSeqs;
    PeerReview<?, Identifier> peerreview;
    int numSubjects;
    RandomAccessFileIOBuffer authFile;
    Map<Identifier, SortedSet<Authenticator>> authenticators;
    Logger logger;
    Serializer<Identifier> idSerializer;
    AuthenticatorSerializer authenticatorSerializer;
    boolean memoryBufferDisabled = false;

    public AuthenticatorStoreImpl(PeerReview<?, Identifier> peerreview) {
        this(peerreview, false);
    }

    public AuthenticatorStoreImpl(PeerReview<?, Identifier> peerreview, boolean allowDuplicateSeqs) {
        this.allowDuplicateSeqs = allowDuplicateSeqs;
        this.authenticators = new HashMap<Identifier, SortedSet<Authenticator>>();
        this.authFile = null;
        this.numSubjects = 0;
        this.peerreview = peerreview;
        this.authenticatorSerializer = peerreview.getAuthenticatorSerializer();
        this.idSerializer = peerreview.getIdSerializer();
        this.logger = peerreview.getEnvironment().getLogManager().getLogger(AuthenticatorStoreImpl.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.authenticators.clear();
        if (this.authFile != null) {
            try {
                this.authFile.close();
            }
            catch (IOException ioe) {
                this.logger.logException("Couldn't close authFile " + this.authFile, ioe);
            }
            finally {
                this.authFile = null;
            }
        }
    }

    @Override
    public void setFilename(File file) throws IOException {
        if (this.authFile != null) {
            this.authFile.close();
            this.authFile = null;
        }
        this.authFile = new RandomAccessFileIOBuffer(file, "rw");
        int authenticatorsRead = 0;
        boolean bytesRead = false;
        long pos = 0L;
        this.authFile.seek(pos);
        while (this.authFile.bytesRemaining() > 0) {
            try {
                RawSerializable id = (RawSerializable)this.idSerializer.deserialize(this.authFile);
                Authenticator authenticator = this.authenticatorSerializer.deserialize(this.authFile);
                this.addAuthenticatorToMemory(id, authenticator);
                ++authenticatorsRead;
                pos = this.authFile.getFilePointer();
            }
            catch (IOException ioe) {
                // empty catch block
                break;
            }
        }
        this.authFile.setLength(pos);
        this.authFile.seek(this.authFile.length());
    }

    protected void addAuthenticatorToMemory(Identifier id, Authenticator authenticator) {
        SortedSet<Authenticator> sub;
        SortedSet<Authenticator> list = this.authenticators.get(id);
        if (list == null) {
            list = new TreeSet<Authenticator>();
            this.authenticators.put(id, list);
        }
        if (!(this.allowDuplicateSeqs || (sub = list.subSet(new Authenticator(authenticator.getSeq() + 1L, null, null), new Authenticator(authenticator.getSeq(), null, null))).isEmpty() || sub.contains(authenticator))) {
            throw new RuntimeException("Adding duplicate auths for the same sequence number is not allowed for this store old:" + sub.first() + " new:" + authenticator);
        }
        list.add(authenticator);
    }

    protected void flushAuthenticatorsFromMemory(Identifier id, long minseq, long maxseq) {
        SortedSet<Authenticator> list = this.authenticators.get(id);
        if (list != null) {
            list.removeAll(this.getAuthenticators(id, minseq, maxseq));
        }
    }

    protected SortedSet<Authenticator> findSubject(Identifier id) {
        return this.authenticators.get(id);
    }

    @Override
    public void addAuthenticator(Identifier id, Authenticator authenticator) {
        try {
            if (this.authFile != null) {
                this.idSerializer.serialize(id, this.authFile);
                authenticator.serialize(this.authFile);
            }
            if (!this.memoryBufferDisabled) {
                this.addAuthenticatorToMemory(id, authenticator);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in addAuthenticator(" + id + "," + authenticator + "," + this.authFile + ")", ioe);
        }
    }

    @Override
    public void flushAuthenticatorsFor(Identifier id, long minseq, long maxseq) {
        this.flushAuthenticatorsFromMemory(id, minseq, maxseq);
    }

    @Override
    public void flushAuthenticatorsFor(Identifier id) {
        this.flushAuthenticatorsFor(id, Long.MIN_VALUE, 0x7FFFFFFFFFFFFFFEL);
    }

    @Override
    public void garbageCollect() throws IOException {
        if (this.authFile == null) {
            return;
        }
        this.authFile.setLength(0L);
        this.authFile.seek(0L);
        for (RawSerializable i : this.authenticators.keySet()) {
            SortedSet<Authenticator> list = this.authenticators.get(i);
            for (Authenticator a : list) {
                this.idSerializer.serialize(i, this.authFile);
                a.serialize(this.authFile);
            }
        }
    }

    @Override
    public int getAuthenticatorSizeBytes() {
        return this.authenticatorSerializer.getSerializedSize();
    }

    @Override
    public List<Authenticator> getAuthenticators(Identifier id, long minseq, long maxseq) {
        SortedSet<Authenticator> list = this.authenticators.get(id);
        if (list != null) {
            SortedSet<Authenticator> subList = list.subSet(new Authenticator(maxseq + 1L, null, null), new Authenticator(minseq, null, null));
            return new ArrayList<Authenticator>(subList);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Authenticator> getAuthenticators(Identifier id) {
        return this.getAuthenticators(id, Long.MIN_VALUE, 0x7FFFFFFFFFFFFFFEL);
    }

    @Override
    public Authenticator getLastAuthenticatorBefore(Identifier id, long seq) {
        List<Authenticator> list = this.getAuthenticators(id, Long.MIN_VALUE, seq);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Authenticator getMostRecentAuthenticator(Identifier id) {
        SortedSet<Authenticator> list = this.authenticators.get(id);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.first();
    }

    @Override
    public int getNumSubjects() {
        return this.authenticators.size();
    }

    @Override
    public Authenticator getOldestAuthenticator(Identifier id) {
        SortedSet<Authenticator> list = this.authenticators.get(id);
        if (list == null) {
            return null;
        }
        return list.last();
    }

    @Override
    public List<Identifier> getSubjects() {
        return new ArrayList<Identifier>(this.authenticators.keySet());
    }

    @Override
    public int numAuthenticatorsFor(Identifier id) {
        SortedSet<Authenticator> list = this.authenticators.get(id);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public int numAuthenticatorsFor(Identifier id, long minseq, long maxseq) {
        return this.getAuthenticators(id, minseq, maxseq).size();
    }

    @Override
    public Authenticator statAuthenticator(Identifier id, long seq) {
        List<Authenticator> ret = this.getAuthenticators(id, seq, seq);
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return ret.get(0);
    }

    @Override
    public void flush(Identifier id) {
        this.authenticators.remove(id);
    }

    @Override
    public void flushAll() {
        this.authenticators.clear();
    }

    @Override
    public void disableMemoryBuffer() {
        this.memoryBufferDisabled = true;
    }
}

