/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.peerreview.IdentifierExtractor;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewCallback;
import org.mpisws.p2p.transport.peerreview.audit.AuditProtocol;
import org.mpisws.p2p.transport.peerreview.audit.AuditProtocolImpl;
import org.mpisws.p2p.transport.peerreview.audit.EvidenceTool;
import org.mpisws.p2p.transport.peerreview.audit.EvidenceToolImpl;
import org.mpisws.p2p.transport.peerreview.authpush.AuthenticatorPushProtocol;
import org.mpisws.p2p.transport.peerreview.authpush.AuthenticatorPushProtocolImpl;
import org.mpisws.p2p.transport.peerreview.challenge.ChallengeResponseProtocol;
import org.mpisws.p2p.transport.peerreview.challenge.ChallengeResponseProtocolImpl;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializer;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializerImpl;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorStore;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorStoreImpl;
import org.mpisws.p2p.transport.peerreview.commitment.CommitmentProtocol;
import org.mpisws.p2p.transport.peerreview.commitment.CommitmentProtocolImpl;
import org.mpisws.p2p.transport.peerreview.evidence.EvidenceSerializerImpl;
import org.mpisws.p2p.transport.peerreview.evidence.EvidenceTransferProtocol;
import org.mpisws.p2p.transport.peerreview.evidence.EvidenceTransferProtocolImpl;
import org.mpisws.p2p.transport.peerreview.evidence.ProofInconsistent;
import org.mpisws.p2p.transport.peerreview.history.HashSeq;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactoryImpl;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.infostore.EvidenceSerializer;
import org.mpisws.p2p.transport.peerreview.infostore.IdStrTranslator;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStoreImpl;
import org.mpisws.p2p.transport.peerreview.infostore.StatusChangeListener;
import org.mpisws.p2p.transport.peerreview.message.AccusationMessage;
import org.mpisws.p2p.transport.peerreview.message.AckMessage;
import org.mpisws.p2p.transport.peerreview.message.AuthPushMessage;
import org.mpisws.p2p.transport.peerreview.message.AuthRequest;
import org.mpisws.p2p.transport.peerreview.message.AuthResponse;
import org.mpisws.p2p.transport.peerreview.message.ChallengeMessage;
import org.mpisws.p2p.transport.peerreview.message.PeerReviewMessage;
import org.mpisws.p2p.transport.peerreview.message.ResponseMessage;
import org.mpisws.p2p.transport.peerreview.message.UserDataMessage;
import org.mpisws.p2p.transport.peerreview.replay.VerifierFactory;
import org.mpisws.p2p.transport.peerreview.replay.VerifierFactoryImpl;
import org.mpisws.p2p.transport.peerreview.replay.record.RecordSM;
import org.mpisws.p2p.transport.peerreview.statement.StatementProtocolImpl;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.Serializer;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerReviewImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements TransportLayerCallback<Handle, ByteBuffer>,
PeerReview<Handle, Identifier>,
StatusChangeListener<Identifier> {
    protected PeerReviewCallback<Handle, Identifier> callback;
    protected IdentityTransport<Handle, Identifier> transport;
    protected Serializer<Handle> handleSerializer;
    protected Serializer<Identifier> idSerializer;
    protected IdentifierExtractor<Handle, Identifier> identifierExtractor;
    protected IdStrTranslator<Identifier> stringTranslator;
    protected EvidenceSerializer evidenceSerializer;
    protected AuthenticatorSerializer authenticatorSerialilzer;
    protected EvidenceTool<Handle, Identifier> evidenceTool;
    protected Environment env;
    protected Logger logger;
    protected AuthenticatorStore<Identifier> authInStore;
    protected AuthenticatorStore<Identifier> authOutStore;
    protected AuthenticatorStore<Identifier> authCacheStore;
    protected AuthenticatorStore<Identifier> authPendingStore;
    protected PeerInfoStore<Handle, Identifier> infoStore;
    protected SecureHistoryFactory historyFactory;
    protected SecureHistory history;
    protected VerifierFactory<Handle, Identifier> verifierFactory;
    protected CommitmentProtocol<Handle, Identifier> commitmentProtocol;
    protected EvidenceTransferProtocol<Handle, Identifier> evidenceTransferProtocol;
    protected AuthenticatorPushProtocol<Handle, Identifier> authPushProtocol;
    protected AuditProtocol<Handle, Identifier> auditProtocol;
    protected ChallengeResponseProtocol<Handle, Identifier> challengeProtocol;
    protected StatementProtocolImpl<Handle, Identifier> statementProtocol;
    long nextEvidenceSeq = 0L;
    private TimerTask maintenanceTask;
    private TimerTask authPushTask;
    private TimerTask checkpointTask;
    protected RandomSource random;
    long lastLogEntry = -1L;
    boolean initialized = false;
    protected long timeToleranceMillis = 60000L;

    @Override
    public RandomSource getRandomSource() {
        return this.random;
    }

    public PeerReviewImpl(IdentityTransport<Handle, Identifier> transport, Environment env, Serializer<Handle> handleSerializer, Serializer<Identifier> idSerializer, IdentifierExtractor<Handle, Identifier> identifierExtractor, IdStrTranslator<Identifier> stringTranslator) {
        if (!(env.getSelectorManager() instanceof RecordSM)) {
            throw new IllegalArgumentException("Environment.getSelectorManager() must return a RecordSM");
        }
        this.transport = transport;
        this.transport.setCallback(this);
        this.stringTranslator = stringTranslator;
        this.env = env;
        this.logger = env.getLogManager().getLogger(PeerReviewImpl.class, null);
        this.idSerializer = idSerializer;
        this.handleSerializer = handleSerializer;
        this.identifierExtractor = identifierExtractor;
        this.authenticatorSerialilzer = new AuthenticatorSerializerImpl(transport.getHashSizeBytes(), transport.getSignatureSizeBytes());
        this.evidenceSerializer = new EvidenceSerializerImpl<Handle, Identifier>(handleSerializer, idSerializer, transport.getHashSizeBytes(), transport.getSignatureSizeBytes());
        this.historyFactory = this.getSecureHistoryFactory(transport, env);
        this.random = new SimpleRandomSource(env.getLogManager(), "peerreview");
    }

    protected SecureHistoryFactory getSecureHistoryFactory(IdentityTransport<Handle, Identifier> transport, Environment env) {
        return new SecureHistoryFactoryImpl(transport, env);
    }

    public void setTimeToleranceMillis(long timeToleranceMicros) {
        this.timeToleranceMillis = timeToleranceMicros;
        if (this.commitmentProtocol != null) {
            this.commitmentProtocol.setTimeToleranceMillis(timeToleranceMicros);
        }
    }

    @Override
    public long getEvidenceSeq() {
        if (this.nextEvidenceSeq < this.getTime()) {
            this.nextEvidenceSeq = this.getTime();
        }
        return this.nextEvidenceSeq++;
    }

    protected void updateLogTime() {
        long now;
        if (this.logger.level <= 300) {
            this.logger.log("updateLogTime()");
        }
        if ((now = this.env.getTimeSource().currentTimeMillis()) > this.lastLogEntry) {
            if (!this.history.setNextSeq(now * 1000000L)) {
                throw new RuntimeException("PeerReview: Cannot roll back history sequence number from " + this.history.getLastSeq() + " to " + now * 1000000L + "; did you change the local time?");
            }
            this.lastLogEntry = now;
        }
    }

    @Override
    public MessageRequestHandle<Handle, ByteBuffer> sendMessage(Handle target, ByteBuffer message, final MessageCallback<Handle, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        if (options != null && options.containsKey("PeerReview_ignore_commit")) {
            final MessageRequestHandleImpl<Handle, ByteBuffer> ret = new MessageRequestHandleImpl<Handle, ByteBuffer>(target, message, options);
            ByteBuffer msg = ByteBuffer.allocate(message.remaining() + 1);
            msg.put((byte)0);
            msg.put(message);
            msg.flip();
            ret.setSubCancellable(this.transport.sendMessage(target, msg, new MessageCallback<Handle, ByteBuffer>(){

                @Override
                public void ack(MessageRequestHandle<Handle, ByteBuffer> msg) {
                    if (deliverAckToMe != null) {
                        deliverAckToMe.ack(ret);
                    }
                }

                @Override
                public void sendFailed(MessageRequestHandle<Handle, ByteBuffer> msg, Exception reason) {
                    if (deliverAckToMe != null) {
                        deliverAckToMe.sendFailed(ret, reason);
                    }
                }
            }, options));
            return ret;
        }
        assert (this.initialized);
        this.updateLogTime();
        return this.commitmentProtocol.handleOutgoingMessage(target, message, deliverAckToMe, options);
    }

    @Override
    public void setApp(PeerReviewCallback<Handle, Identifier> callback) {
        if (this.logger.level <= 800) {
            this.logger.log("setApp(" + callback + ")");
        }
        this.callback = callback;
    }

    @Override
    public void setCallback(TransportLayerCallback<Handle, ByteBuffer> callback) {
        this.setApp((PeerReviewCallback)callback);
    }

    @Override
    public void messageReceived(Handle handle, ByteBuffer message, Map<String, Object> options) throws IOException {
        assert (this.initialized);
        if (this.infoStore.getStatus(this.identifierExtractor.extractIdentifier(handle)) == 2) {
            if (this.logger.level <= 900) {
                this.logger.log("Received a message from an exposed node " + handle + " -- ignoring");
            }
            return;
        }
        byte passthrough = message.get();
        block0 : switch (passthrough) {
            case 0: {
                this.callback.messageReceived(handle, message, options);
                break;
            }
            case 1: {
                Object m = null;
                this.updateLogTime();
                byte type = message.get();
                SimpleInputBuffer sib = new SimpleInputBuffer(message);
                switch (type) {
                    case 21: {
                        this.authPushProtocol.handleIncomingAuthenticators(handle, AuthPushMessage.build(new SimpleInputBuffer(message), this.idSerializer, this.authenticatorSerialilzer));
                        break block0;
                    }
                    case 22: {
                        this.auditProtocol.handleIncomingDatagram(handle, new AuthRequest<Identifier>(new SimpleInputBuffer(message), this.idSerializer));
                        break block0;
                    }
                    case 23: {
                        this.auditProtocol.handleIncomingDatagram(handle, new AuthResponse<Identifier>(new SimpleInputBuffer(message), this.idSerializer, this.transport.getHashSizeBytes(), this.transport.getSignatureSizeBytes()));
                        break block0;
                    }
                    case 17: {
                        this.commitmentProtocol.handleIncomingAck(handle, AckMessage.build(sib, this.idSerializer, this.transport.getHashSizeBytes(), this.transport.getSignatureSizeBytes()), options);
                        break block0;
                    }
                    case 19: {
                        ChallengeMessage<Identifier> challenge = new ChallengeMessage<Identifier>(sib, this.idSerializer, this.evidenceSerializer);
                        this.challengeProtocol.handleChallenge(handle, challenge, options);
                        break block0;
                    }
                    case 18: {
                        this.statementProtocol.handleIncomingStatement(handle, new AccusationMessage<Identifier>(sib, this.idSerializer, this.evidenceSerializer), options);
                        break block0;
                    }
                    case 20: {
                        this.statementProtocol.handleIncomingStatement(handle, new ResponseMessage<Identifier>(sib, this.idSerializer, this.evidenceSerializer), options);
                        break block0;
                    }
                    case 16: {
                        UserDataMessage<Handle> udm = UserDataMessage.build(sib, this.handleSerializer, this.transport.getHashSizeBytes(), this.transport.getSignatureSizeBytes());
                        this.challengeProtocol.handleIncomingMessage(handle, udm, options);
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown message type in PeerReview: #" + type);
            }
        }
    }

    public static String getStatusString(int status) {
        switch (status) {
            case 2: {
                return "exposed";
            }
            case 0: {
                return "trusted";
            }
            case 1: {
                return "suspected";
            }
        }
        return "unknown status:" + status;
    }

    @Override
    public boolean addAuthenticatorIfValid(AuthenticatorStore<Identifier> store, Identifier subject, Authenticator auth) {
        Authenticator existingAuth = null;
        if (store != null) {
            existingAuth = store.statAuthenticator(subject, auth.getSeq());
        }
        if (existingAuth != null && auth.equals(existingAuth)) {
            return true;
        }
        assert (this.transport.hasCertificate(subject));
        try {
            byte[] signedHash = this.transport.hash(auth.getPartToHashThenSign());
            int sigResult = this.transport.verify(subject, signedHash, auth.getSignature());
            assert (sigResult == 1 || sigResult == 0);
            if (sigResult != 1) {
                return false;
            }
            if (!this.verify(subject, auth)) {
                return false;
            }
            if (existingAuth != null) {
                if (this.logger.level < 900) {
                    this.logger.log("Authenticator conflict for " + subject + " seq #" + auth.getSeq());
                }
                if (this.logger.level < 500) {
                    this.logger.log("Existing: [" + existingAuth + "]");
                }
                if (this.logger.level < 500) {
                    this.logger.log("New:      [" + auth + "]");
                }
                ProofInconsistent proof = new ProofInconsistent(auth, existingAuth);
                long evidenceSeq = this.getEvidenceSeq();
                this.infoStore.addEvidence(this.identifierExtractor.extractIdentifier(this.transport.getLocalIdentifier()), subject, evidenceSeq, proof, null);
                this.sendEvidenceToWitnesses(subject, evidenceSeq, proof);
                return false;
            }
            if (store != null) {
                store.addAuthenticator(subject, auth);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Cancellable requestCertificate(Handle source, Identifier certHolder, Continuation<X509Certificate, Exception> c, Map<String, Object> options) {
        return this.transport.requestCertificate(source, certHolder, c, options);
    }

    @Override
    public Cancellable requestCertificate(final Handle source, final Identifier certHolder) {
        return this.transport.requestCertificate(source, certHolder, new Continuation<X509Certificate, Exception>(){

            @Override
            public void receiveException(Exception exception) {
                if (PeerReviewImpl.this.logger.level <= 900) {
                    PeerReviewImpl.this.logger.logException("error receiving cert for " + certHolder + " from " + source, exception);
                }
            }

            @Override
            public void receiveResult(X509Certificate result) {
                PeerReviewImpl.this.notifyCertificateAvailable(certHolder);
            }
        }, null);
    }

    @Override
    public void notifyCertificateAvailable(Identifier id) {
        this.commitmentProtocol.notifyCertificateAvailable(id);
        this.authPushProtocol.notifyCertificateAvailable(id);
        this.statementProtocol.notifyCertificateAvailable(id);
    }

    public void writeCheckpoint() throws IOException {
        boolean size = false;
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        this.callback.storeCheckpoint(sob);
        this.updateLogTime();
        if (this.logger.level <= 800) {
            this.logger.log("Writing checkpoint (" + sob.getWritten() + " bytes)");
        }
        this.history.appendEntry((short)4, true, sob.getByteBuffer());
    }

    protected void doAuthPush() {
        if (this.logger.level <= 800) {
            this.logger.log("Doing authenticator push");
        }
        this.authPushProtocol.push();
    }

    protected void doMaintenance() {
        if (this.logger.level <= 800) {
            this.logger.log("Doing maintenance");
        }
        try {
            this.authInStore.garbageCollect();
            this.authOutStore.garbageCollect();
            this.authPendingStore.garbageCollect();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void doCheckpoint() {
        HashSeq foo = this.history.getTopLevelEntry();
        long topSeq = foo.getSeq();
        try {
            long topIdx = this.history.findSeq(topSeq);
            if (this.history.statEntry(topIdx).getType() != 4) {
                this.writeCheckpoint();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error during checkpoint", ioe);
        }
    }

    @Override
    public void notifyStatusChange(Identifier id, int newStatus) {
        if (this.logger.level <= 800) {
            this.logger.log("Status change: <" + id + "> becomes " + PeerReviewImpl.getStatusString(newStatus));
        }
        this.challengeProtocol.notifyStatusChange(id, newStatus);
        this.commitmentProtocol.notifyStatusChange(id, newStatus);
        this.env.getSelectorManager().schedule(new TimerTask((RawSerializable)id, newStatus){
            final /* synthetic */ RawSerializable val$id;
            final /* synthetic */ int val$newStatus;
            {
                this.val$id = rawSerializable;
                this.val$newStatus = n;
            }

            public void run() {
                PeerReviewImpl.this.callback.notifyStatusChange(this.val$id, this.val$newStatus);
            }

            public String toString() {
                return "NotifyStatusChangeTask: " + this.val$id + "=>" + this.val$newStatus;
            }
        }, 3L);
    }

    @Override
    public void init(String dirname) throws IOException {
        assert (this.callback != null);
        File dir = new File(dirname);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Cannot open PeerReview directory: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException("Cannot open PeerReview directory: " + dir.getAbsolutePath());
        }
        File namebuf = new File(dir, "peers");
        this.infoStore = new PeerInfoStoreImpl<Handle, Identifier>(this.transport, this.stringTranslator, this.authenticatorSerialilzer, this.evidenceSerializer, this.env);
        this.infoStore.setStatusChangeListener(this);
        boolean newLogCreated = false;
        String historyName = dirname + "/local";
        this.history = this.historyFactory.open(historyName, "w");
        if (this.history == null) {
            this.history = this.historyFactory.create(historyName, 0L, this.transport.getEmptyHash());
            newLogCreated = true;
        }
        this.updateLogTime();
        if (!this.infoStore.setStorageDirectory(namebuf)) {
            throw new IllegalStateException("Cannot open info storage directory '" + namebuf + "'");
        }
        this.authInStore = new AuthenticatorStoreImpl(this);
        this.authInStore.setFilename(new File(dir, "authenticators.in"));
        this.authOutStore = new AuthenticatorStoreImpl(this);
        this.authOutStore.setFilename(new File(dir, "authenticators.out"));
        this.authPendingStore = new AuthenticatorStoreImpl(this, true);
        this.authPendingStore.setFilename(new File(dir, "authenticators.pending"));
        this.authCacheStore = new AuthenticatorStoreImpl(this, true);
        this.authCacheStore.setFilename(new File(dir, "authenticators.cache"));
        this.evidenceTransferProtocol = new EvidenceTransferProtocolImpl<Handle, Identifier>(this, this.transport, this.infoStore);
        this.commitmentProtocol = new CommitmentProtocolImpl<Handle, Identifier>(this, this.transport, this.infoStore, this.authOutStore, this.history, this.timeToleranceMillis);
        this.authPushProtocol = new AuthenticatorPushProtocolImpl<Handle, Identifier>(this, this.authInStore, this.authOutStore, this.authPendingStore, this.transport, this.infoStore, this.evidenceTransferProtocol, this.env);
        this.auditProtocol = new AuditProtocolImpl<Handle, Identifier>(this, this.history, this.infoStore, this.authInStore, this.transport, this.authOutStore, this.evidenceTransferProtocol, this.authCacheStore);
        this.challengeProtocol = new ChallengeResponseProtocolImpl<Handle, Identifier>(this, this.transport, this.infoStore, this.history, this.authOutStore, this.auditProtocol, this.commitmentProtocol);
        this.statementProtocol = new StatementProtocolImpl<Handle, Identifier>(this, this.challengeProtocol, this.infoStore, this.transport);
        this.evidenceTool = new EvidenceToolImpl<Handle, Identifier>(this, this.handleSerializer, this.idSerializer, this.transport.getHashSizeBytes(), this.transport.getSignatureSizeBytes());
        this.verifierFactory = new VerifierFactoryImpl(this);
        this.initialized = true;
        this.maintenanceTask = this.env.getSelectorManager().schedule(new TimerTask(){

            public void run() {
                PeerReviewImpl.this.doMaintenance();
            }

            public String toString() {
                return "DoMaintenanceTask";
            }
        }, 10000L, 10000L);
        this.authPushTask = this.env.getSelectorManager().schedule(new TimerTask(){

            public void run() {
                PeerReviewImpl.this.doAuthPush();
            }

            public String toString() {
                return "AuthPushTask";
            }
        }, 5000L, 5000L);
        this.checkpointTask = this.env.getSelectorManager().schedule(new TimerTask(){

            public void run() {
                PeerReviewImpl.this.doCheckpoint();
            }

            public String toString() {
                return "CheckpointTask";
            }
        }, newLogCreated ? 1L : 10000L, 10000L);
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        ((RawSerializable)this.transport.getLocalIdentifier()).serialize(sob);
        this.history.appendEntry((short)5, true, sob.getByteBuffer());
        this.callback.init();
        this.writeCheckpoint();
    }

    @Override
    public PeerReviewCallback<Handle, Identifier> getApp() {
        return this.callback;
    }

    @Override
    public SocketRequestHandle<Handle> openSocket(Handle i, SocketCallback<Handle> deliverSocketToMe, Map<String, Object> options) {
        return this.transport.openSocket(i, deliverSocketToMe, options);
    }

    @Override
    public void incomingSocket(P2PSocket<Handle> s) throws IOException {
        this.callback.incomingSocket(s);
    }

    @Override
    public void acceptMessages(boolean b) {
        this.transport.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.transport.acceptSockets(b);
    }

    @Override
    public Identifier getLocalId() {
        return (Identifier)((RawSerializable)this.identifierExtractor.extractIdentifier(this.transport.getLocalIdentifier()));
    }

    @Override
    public Handle getLocalHandle() {
        return (Handle)((RawSerializable)this.transport.getLocalIdentifier());
    }

    @Override
    public Handle getLocalIdentifier() {
        return (Handle)((RawSerializable)this.transport.getLocalIdentifier());
    }

    @Override
    public void setErrorHandler(ErrorHandler<Handle> handler) {
    }

    @Override
    public void destroy() {
        this.transport.destroy();
    }

    @Override
    public AuthenticatorSerializer getAuthenticatorSerializer() {
        return this.authenticatorSerialilzer;
    }

    @Override
    public Environment getEnvironment() {
        return this.env;
    }

    @Override
    public Serializer<Identifier> getIdSerializer() {
        return this.idSerializer;
    }

    @Override
    public long getTime() {
        return this.env.getTimeSource().currentTimeMillis();
    }

    @Override
    public Authenticator extractAuthenticator(long seq, short entryType, byte[] entryHash, byte[] hTopMinusOne, byte[] signature) {
        byte[] hash = this.transport.hash(seq, entryType, hTopMinusOne, entryHash);
        Authenticator ret = new Authenticator(seq, hash, signature);
        return ret;
    }

    @Override
    public Authenticator extractAuthenticator(Identifier id, long seq, short entryType, byte[] entryHash, byte[] hTopMinusOne, byte[] signature) {
        Authenticator ret = this.extractAuthenticator(seq, entryType, entryHash, hTopMinusOne, signature);
        if (this.addAuthenticatorIfValid(this.authOutStore, id, ret)) {
            return ret;
        }
        return null;
    }

    @Override
    public Serializer<Handle> getHandleSerializer() {
        return this.handleSerializer;
    }

    @Override
    public int getHashSizeInBytes() {
        return this.transport.getHashSizeBytes();
    }

    @Override
    public int getSignatureSizeInBytes() {
        return this.transport.getSignatureSizeBytes();
    }

    @Override
    public IdentifierExtractor<Handle, Identifier> getIdentifierExtractor() {
        return this.identifierExtractor;
    }

    @Override
    public void challengeSuspectedNode(Handle handle) {
        this.challengeProtocol.challengeSuspectedNode(handle);
    }

    @Override
    public void sendEvidenceToWitnesses(Identifier subject, long evidenceSeq, Evidence evidence) {
        AccusationMessage<Identifier> accusation = new AccusationMessage<Identifier>(this.getLocalId(), subject, evidenceSeq, evidence);
        if (this.logger.level <= 500) {
            this.logger.log("Relaying evidence to <" + subject + ">'s witnesses");
        }
        this.evidenceTransferProtocol.sendMessageToWitnesses(subject, accusation, null, null);
    }

    @Override
    public void transmit(Handle dest, PeerReviewMessage message, MessageCallback<Handle, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer();
            sob.writeByte((byte)1);
            sob.writeByte((byte)message.getType());
            message.serialize(sob);
            ByteBuffer buf = sob.getByteBuffer();
            this.transport.sendMessage(dest, buf, deliverAckToMe, options);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error serializing:" + message, ioe);
        }
    }

    @Override
    public boolean hasCertificate(Identifier id) {
        return this.transport.hasCertificate(id);
    }

    @Override
    public byte[] sign(byte[] bytes) {
        return this.transport.sign(bytes);
    }

    @Override
    public short getSignatureSizeBytes() {
        return this.transport.getSignatureSizeBytes();
    }

    @Override
    public boolean verify(Identifier id, Authenticator auth) {
        byte[] signedHash = this.transport.hash(auth.getPartToHashThenSign());
        int result = this.transport.verify(id, signedHash, auth.getSignature());
        return result == 1;
    }

    @Override
    public int verify(Identifier id, byte[] msg, byte[] signature) {
        return this.transport.verify(id, msg, signature);
    }

    @Override
    public byte[] getEmptyHash() {
        return this.transport.getEmptyHash();
    }

    @Override
    public short getHashSizeBytes() {
        return this.transport.getHashSizeBytes();
    }

    @Override
    public byte[] hash(long seq, short type, byte[] nodeHash, byte[] contentHash) {
        return this.transport.hash(seq, type, nodeHash, contentHash);
    }

    @Override
    public byte[] hash(ByteBuffer ... hashMe) {
        return this.transport.hash(hashMe);
    }

    public EvidenceSerializer getEvidenceSerializer() {
        return this.evidenceSerializer;
    }

    @Override
    public EvidenceTool<Handle, Identifier> getEvidenceTool() {
        return this.evidenceTool;
    }

    @Override
    public SecureHistoryFactory getHistoryFactory() {
        return this.historyFactory;
    }

    @Override
    public VerifierFactory<Handle, Identifier> getVerifierFactory() {
        return this.verifierFactory;
    }

    void disableAuthenticatorProcessing() {
        assert (this.initialized);
        this.maintenanceTask.cancel();
        this.authInStore.disableMemoryBuffer();
        this.authOutStore.disableMemoryBuffer();
        this.authPendingStore.disableMemoryBuffer();
    }

    @Override
    public SecureHistory getHistory() {
        return this.history;
    }

    @Override
    public long getTimeToleranceMillis() {
        return this.timeToleranceMillis;
    }

    @Override
    public void sendEvidence(Handle dest, Identifier evidenceAgainst) {
        this.evidenceTransferProtocol.sendEvidence(dest, evidenceAgainst);
    }
}

