/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.nat;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.time.TimeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirewallTLImpl<Identifier, MessageType>
implements TransportLayer<Identifier, MessageType>,
TransportLayerCallback<Identifier, MessageType> {
    protected final int UDP_OPEN_MILLIS;
    protected Map<Identifier, Long> udpTable;
    protected TransportLayer<Identifier, MessageType> tl;
    protected TransportLayerCallback<Identifier, MessageType> callback;
    protected TimeSource timeSource;
    protected Environment environment;
    protected Logger logger;

    public FirewallTLImpl(TransportLayer<Identifier, MessageType> tl, int udp_open_millis, Environment env) {
        this.UDP_OPEN_MILLIS = udp_open_millis;
        this.environment = env;
        this.timeSource = this.environment.getTimeSource();
        this.logger = env.getLogManager().getLogger(FirewallTLImpl.class, null);
        this.udpTable = new HashMap<Identifier, Long>();
        this.tl = tl;
        tl.setCallback(this);
        tl.acceptSockets(false);
    }

    @Override
    public MessageRequestHandle<Identifier, MessageType> sendMessage(Identifier i, MessageType m, MessageCallback<Identifier, MessageType> deliverAckToMe, Map<String, Object> options) {
        long now = this.timeSource.currentTimeMillis();
        this.udpTable.put(i, now);
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }

    @Override
    public void messageReceived(Identifier i, MessageType m, Map<String, Object> options) throws IOException {
        if (this.udpTable.containsKey(i)) {
            long now = this.timeSource.currentTimeMillis();
            if (this.udpTable.get(i) + (long)this.UDP_OPEN_MILLIS >= now) {
                if (this.logger.level <= 400) {
                    this.logger.log("accepting messageReceived(" + i + "," + m + "," + options + ")");
                }
                this.udpTable.put(i, now);
                this.callback.messageReceived(i, m, options);
                return;
            }
        }
        if (this.logger.level <= 500) {
            this.logger.log("dropping messageReceived(" + i + "," + m + "," + options + ")");
        }
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("closing incomingSocket(" + s + ")");
        }
        s.close();
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        return this.tl.openSocket(i, deliverSocketToMe, options);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, MessageType> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }
}

