/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.multiaddress;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.mpisws.p2p.transport.simpleidentity.InetSocketAddressSerializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class MultiInetSocketAddress
implements Serializable {
    static InetSocketAddressSerializer serializer = new InetSocketAddressSerializer();
    protected InetSocketAddress[] address;

    public MultiInetSocketAddress(InetSocketAddress address) {
        this(new InetSocketAddress[]{address});
    }

    public MultiInetSocketAddress(InetSocketAddress[] addressList) {
        this.address = addressList;
    }

    public MultiInetSocketAddress(InetSocketAddress outer, InetSocketAddress inner) {
        this(new InetSocketAddress[]{outer, inner});
    }

    public int hashCode() {
        int result = 31173;
        for (int i = 0; i < this.address.length; ++i) {
            result ^= this.address[i].hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof MultiInetSocketAddress)) {
            return false;
        }
        MultiInetSocketAddress that = (MultiInetSocketAddress)o;
        return this.addressEquals(that);
    }

    public boolean addressEquals(MultiInetSocketAddress that) {
        if (this.address.length != that.address.length) {
            return that.getInnermostAddress().equals(this.getInnermostAddress());
        }
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            if (this.address[ctr].equals(that.address[ctr])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "";
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            s = s + this.address[ctr];
            if (ctr >= this.address.length - 1) continue;
            s = s + ":";
        }
        return s;
    }

    public void toStringShort(StringBuffer result) {
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            InetSocketAddress theAddr = this.address[ctr];
            InetAddress theAddr2 = theAddr.getAddress();
            if (theAddr2 == null) {
                result.append(theAddr.toString());
            } else {
                String ha = theAddr2.getHostAddress();
                result.append(ha + ":" + theAddr.getPort());
            }
            if (ctr >= this.address.length - 1) continue;
            result.append(";");
        }
    }

    public InetSocketAddress getInnermostAddress() {
        return this.address[this.address.length - 1];
    }

    public InetSocketAddress getOutermostAddress() {
        return this.address[0];
    }

    public int getNumAddresses() {
        return this.address.length;
    }

    public InetSocketAddress getAddress(int index) {
        return this.address[index];
    }

    public static MultiInetSocketAddress build(InputBuffer buf) throws IOException {
        int numAddresses = buf.readByte();
        InetSocketAddress[] saddr = new InetSocketAddress[numAddresses];
        for (int ctr = 0; ctr < numAddresses; ++ctr) {
            saddr[ctr] = serializer.deserialize(buf, null, null);
        }
        return new MultiInetSocketAddress(saddr);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)this.address.length);
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            serializer.serialize(this.address[ctr], buf);
        }
    }

    public short getSerializedLength() {
        int ret = 1;
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            ret += serializer.getSerializedLength(this.address[ctr]);
        }
        return (short)ret;
    }
}

