/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.direct;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.direct.ConnectorExceptionDelivery;
import org.mpisws.p2p.transport.direct.Delivery;
import org.mpisws.p2p.transport.direct.DirectTransportLayer;
import org.mpisws.p2p.transport.direct.GenericNetworkSimulator;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import rice.environment.Environment;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectAppSocket<Identifier, MessageType> {
    public static final byte[] EOF = new byte[0];
    private static final int MAX_BYTES_IN_FLIGHT = 10000;
    Identifier acceptor;
    Identifier connector;
    SocketCallback<Identifier> connectorReceiver;
    GenericNetworkSimulator<Identifier, MessageType> simulator;
    DirectAppSocketEndpoint acceptorEndpoint;
    DirectAppSocketEndpoint connectorEndpoint;
    SocketRequestHandle<Identifier> connectorHandle;
    Logger acceptorLogger;
    Logger connectorLogger;
    Map<String, Object> options;

    public DirectAppSocket(Identifier acceptor, Identifier connector, SocketCallback<Identifier> connectorCallback, GenericNetworkSimulator<Identifier, MessageType> simulator, SocketRequestHandle<Identifier> handle, Map<String, Object> options) {
        this.options = options;
        this.acceptor = acceptor;
        this.connector = connector;
        this.connectorReceiver = connectorCallback;
        this.simulator = simulator;
        this.connectorHandle = handle;
        Environment aEnv = simulator.getEnvironment(acceptor);
        Environment cEnv = simulator.getEnvironment(connector);
        this.acceptorLogger = aEnv.getLogManager().getLogger(DirectAppSocket.class, "");
        this.connectorLogger = cEnv.getLogManager().getLogger(DirectAppSocket.class, "");
        this.acceptorEndpoint = new DirectAppSocketEndpoint(acceptor, this.acceptorLogger);
        this.connectorEndpoint = new DirectAppSocketEndpoint(connector, this.connectorLogger);
        this.acceptorEndpoint.setCounterpart(this.connectorEndpoint);
        this.connectorEndpoint.setCounterpart(this.acceptorEndpoint);
    }

    public Delivery getAcceptorDelivery() {
        return new AcceptorDelivery();
    }

    public String toString() {
        return "DAS{" + this.connector + "[" + this.connectorReceiver + "]->" + this.acceptor + "}";
    }

    class ConnectorDelivery
    implements Delivery {
        ConnectorDelivery() {
        }

        public void deliver() {
            if (DirectAppSocket.this.simulator.isAlive(DirectAppSocket.this.connector)) {
                DirectAppSocket.this.connectorReceiver.receiveResult(DirectAppSocket.this.connectorHandle, DirectAppSocket.this.connectorEndpoint);
            } else {
                System.out.println("NOT IMPLEMENTED: Connector died during application socket initiation.");
            }
        }

        public int getSeq() {
            return -1;
        }
    }

    class AcceptorDelivery
    implements Delivery {
        AcceptorDelivery() {
        }

        public void deliver() {
            if (DirectAppSocket.this.simulator.isAlive(DirectAppSocket.this.acceptor)) {
                DirectTransportLayer acceptorTL = DirectAppSocket.this.simulator.getTL(DirectAppSocket.this.acceptor);
                if (acceptorTL.canReceiveSocket()) {
                    acceptorTL.finishReceiveSocket(DirectAppSocket.this.acceptorEndpoint);
                    DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorDelivery(), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptor, DirectAppSocket.this.connector)));
                } else {
                    DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorExceptionDelivery(DirectAppSocket.this.connectorReceiver, DirectAppSocket.this.connectorHandle, new SocketTimeoutException()), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptor, DirectAppSocket.this.connector)));
                }
            } else {
                DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorExceptionDelivery(DirectAppSocket.this.connectorReceiver, DirectAppSocket.this.connectorHandle, new NodeIsFaultyException(DirectAppSocket.this.acceptor)), 0);
            }
        }

        public int getSeq() {
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DirectAppSocketEndpoint
    implements P2PSocket<Identifier> {
        Logger logger;
        DirectAppSocketEndpoint counterpart;
        P2PSocketReceiver<Identifier> reader;
        P2PSocketReceiver<Identifier> writer;
        Identifier localNodeHandle;
        int seq = 0;
        boolean outputClosed;
        int bytesInFlight = 0;
        LinkedList<byte[]> byteDeliveries = new LinkedList();
        int firstOffset = 0;

        public DirectAppSocketEndpoint(Identifier localNodeHandle, Logger logger) {
            this.localNodeHandle = localNodeHandle;
            this.logger = logger;
        }

        public void setCounterpart(DirectAppSocketEndpoint counterpart) {
            this.counterpart = counterpart;
        }

        public Identifier getRemoteNodeHandle() {
            return this.counterpart.localNodeHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(ByteBuffer dsts) throws IOException {
            int lengthRead = 0;
            DirectAppSocketEndpoint directAppSocketEndpoint = this;
            synchronized (directAppSocketEndpoint) {
                if (this.byteDeliveries.isEmpty()) {
                    return 0L;
                }
                if (this.byteDeliveries.getFirst() == EOF) {
                    return -1L;
                }
                Iterator i = this.byteDeliveries.iterator();
                while (i.hasNext()) {
                    byte[] msg = (byte[])i.next();
                    ByteBuffer curBuffer = dsts;
                    int lengthToPut = curBuffer.remaining();
                    if (lengthToPut > msg.length - this.firstOffset) {
                        lengthToPut = msg.length - this.firstOffset;
                    }
                    curBuffer.put(msg, this.firstOffset, lengthToPut);
                    this.firstOffset += lengthToPut;
                    lengthRead += lengthToPut;
                    if (this.firstOffset != msg.length) break;
                    i.remove();
                    this.firstOffset = 0;
                }
            }
            this.bytesInFlight -= lengthRead;
            if (this.logger.level <= 400) {
                this.logger.log(this + ".write(" + dsts + ") len:" + lengthRead + " inFlight:" + this.bytesInFlight);
            }
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                public void deliver() {
                    DirectAppSocketEndpoint.this.counterpart.notifyCanWrite();
                }

                public int getSeq() {
                    return 0;
                }

                public String toString() {
                    return DirectAppSocketEndpoint.this.toString() + " counterpart notifyCanWrite()";
                }
            }, 0);
            return lengthRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long write(ByteBuffer srcs) throws IOException {
            int lengthToReadFromBuffer;
            int lengthToWrite;
            if (this.outputClosed) {
                return -1L;
            }
            if (!DirectAppSocket.this.simulator.isAlive(this.counterpart.localNodeHandle)) {
                return -1L;
            }
            int availableToWrite = srcs.remaining();
            DirectAppSocketEndpoint directAppSocketEndpoint = this.counterpart;
            synchronized (directAppSocketEndpoint) {
                lengthToWrite = 10000 - this.counterpart.bytesInFlight;
                if (lengthToWrite > availableToWrite) {
                    lengthToWrite = availableToWrite;
                }
                this.counterpart.bytesInFlight += lengthToWrite;
            }
            final byte[] msg = new byte[lengthToWrite];
            for (int remaining = lengthToWrite; remaining > 0; remaining -= lengthToReadFromBuffer) {
                lengthToReadFromBuffer = srcs.remaining();
                if (remaining < lengthToReadFromBuffer) {
                    lengthToReadFromBuffer = remaining;
                }
                srcs.get(msg, lengthToWrite - remaining, lengthToReadFromBuffer);
            }
            if (this.logger.level <= 400) {
                this.logger.log(this + ".write(" + srcs + ") len:" + lengthToWrite + " inFlight:" + this.counterpart.bytesInFlight);
            }
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){
                int mySeq;
                {
                    this.mySeq = DirectAppSocketEndpoint.this.seq++;
                }

                public void deliver() {
                    DirectAppSocketEndpoint.this.counterpart.addToReadQueue(msg);
                }

                public int getSeq() {
                    return this.mySeq;
                }

                public String toString() {
                    return DirectAppSocketEndpoint.this.toString() + " deliver msg " + msg;
                }
            }, Math.round(DirectAppSocket.this.simulator.networkDelay(this.localNodeHandle, this.counterpart.localNodeHandle)));
            return lengthToWrite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addToReadQueue(byte[] msg) {
            DirectAppSocketEndpoint directAppSocketEndpoint = this;
            synchronized (directAppSocketEndpoint) {
                if (this.logger.level <= 500) {
                    if (msg == EOF) {
                        this.logger.log(this + ": addToReadQueue(EOF)");
                    } else {
                        this.logger.log(this + ": addToReadQueue(" + msg.length + ")");
                    }
                }
                this.byteDeliveries.addLast(msg);
            }
            this.notifyCanRead();
        }

        protected void notifyCanWrite() {
            if (this.writer == null) {
                return;
            }
            if (this.counterpart.bytesInFlight < 10000) {
                P2PSocketReceiver temp = this.writer;
                this.writer = null;
                try {
                    if (this.logger.level <= 300) {
                        this.logger.log(this + ".notifyCanWrite()");
                    }
                    temp.receiveSelectResult(this, false, true);
                }
                catch (IOException ioe) {
                    this.logger.logException("Error in " + temp, ioe);
                }
            }
        }

        protected void notifyCanRead() {
            if (this.byteDeliveries.isEmpty()) {
                return;
            }
            if (this.reader != null) {
                P2PSocketReceiver temp = this.reader;
                this.reader = null;
                try {
                    if (this.logger.level <= 300) {
                        this.logger.log(this + ".notifyCanRead()");
                    }
                    temp.receiveSelectResult(this, true, false);
                }
                catch (IOException ioe) {
                    this.logger.logException("Error in " + temp, ioe);
                }
            }
        }

        @Override
        public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
            if (wantToWrite) {
                this.writer = receiver;
                DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                    public void deliver() {
                        if (!DirectAppSocket.this.simulator.isAlive(DirectAppSocketEndpoint.this.localNodeHandle)) {
                            return;
                        }
                        DirectAppSocketEndpoint.this.notifyCanWrite();
                    }

                    public int getSeq() {
                        return 0;
                    }

                    public String toString() {
                        return DirectAppSocketEndpoint.this.toString() + " notifyCanWrite()";
                    }
                }, 0);
            }
            if (wantToRead) {
                this.reader = receiver;
                DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                    public void deliver() {
                        if (!DirectAppSocket.this.simulator.isAlive(DirectAppSocketEndpoint.this.localNodeHandle)) {
                            return;
                        }
                        DirectAppSocketEndpoint.this.notifyCanRead();
                    }

                    public int getSeq() {
                        return 0;
                    }

                    public String toString() {
                        return DirectAppSocketEndpoint.this.toString() + " notifyCanRead()";
                    }
                }, 0);
            }
        }

        @Override
        public void shutdownOutput() {
            if (this.logger.level <= 400) {
                this.logger.log(this + ".shutdownOutput()");
            }
            this.outputClosed = true;
            if (!DirectAppSocket.this.simulator.isAlive(this.counterpart.localNodeHandle)) {
                return;
            }
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){
                int mySeq;
                {
                    this.mySeq = DirectAppSocketEndpoint.this.seq++;
                }

                public void deliver() {
                    DirectAppSocketEndpoint.this.counterpart.addToReadQueue(EOF);
                }

                public int getSeq() {
                    return this.mySeq;
                }

                public String toString() {
                    return DirectAppSocketEndpoint.this.toString() + " counterpart shutDownOutput()";
                }
            }, Math.round(DirectAppSocket.this.simulator.networkDelay(this.localNodeHandle, this.counterpart.localNodeHandle)));
        }

        public void shutdownInput() {
        }

        @Override
        public void close() {
            this.shutdownOutput();
            this.shutdownInput();
        }

        public String toString() {
            return "DAS{" + this.localNodeHandle + ":" + DirectAppSocket.this.simulator.isAlive(this.localNodeHandle) + "->" + this.counterpart.localNodeHandle + ":" + DirectAppSocket.this.simulator.isAlive(this.counterpart.localNodeHandle) + " w:" + this.writer + " r:" + this.reader + "}";
        }

        @Override
        public Identifier getIdentifier() {
            return this.getRemoteNodeHandle();
        }

        @Override
        public Map<String, Object> getOptions() {
            return DirectAppSocket.this.options;
        }
    }
}

