/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.pki.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.mpisws.p2p.pki.x509.X509Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class X509SerializerImpl
implements X509Serializer {
    CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509", "BC");

    public void serialize(X509Certificate cert, OutputBuffer buf) throws IOException {
        try {
            byte[] encoded = cert.getEncoded();
            buf.writeInt(encoded.length);
            buf.write(encoded, 0, encoded.length);
        }
        catch (CertificateEncodingException cee) {
            IOException ioe = new IOException(cee.getLocalizedMessage());
            ioe.initCause(cee);
            throw ioe;
        }
    }

    public X509Certificate deserialize(InputBuffer buf) throws IOException {
        try {
            byte[] encoded = new byte[buf.readInt()];
            buf.read(encoded);
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(encoded);
            return (X509Certificate)this.certificatefactory.generateCertificate(bytearrayinputstream);
        }
        catch (CertificateException ce) {
            IOException ioe = new IOException(ce.getLocalizedMessage());
            ioe.initCause(ce);
            throw ioe;
        }
    }
}

