/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.pki.x509;

import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.mpisws.p2p.pki.x509.KeySerializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class KeySerializerImpl
implements KeySerializer {
    public void serialize(Key k, OutputBuffer buf) throws IOException {
        if (k instanceof PrivateKey) {
            buf.writeByte((byte)0);
        } else if (k instanceof PublicKey) {
            buf.writeByte((byte)1);
        } else {
            buf.writeByte((byte)2);
        }
        buf.writeUTF(k.getFormat());
        buf.writeUTF(k.getAlgorithm());
        byte[] encoded = k.getEncoded();
        buf.writeInt(encoded.length);
        buf.write(encoded, 0, encoded.length);
    }

    public Key deserialize(InputBuffer buf) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        byte keyType = buf.readByte();
        String format = buf.readUTF();
        String algorithm = buf.readUTF();
        byte[] encoded = new byte[buf.readInt()];
        buf.read(encoded);
        EncodedKeySpec spec = null;
        if (format.equals("PKCS#8") || format.equals("PKCS8")) {
            spec = new PKCS8EncodedKeySpec(encoded);
        } else if (format.equals("X.509") || format.equals("X509")) {
            spec = new X509EncodedKeySpec(encoded);
        } else if (format.equals("RAW")) {
            return new SecretKeySpec(encoded, algorithm);
        }
        if (spec == null) {
            throw new IOException("Unknown key type. Type: " + keyType + " Format:" + format + " Algorithm:" + algorithm);
        }
        if (keyType == 0) {
            return KeyFactory.getInstance(algorithm, "BC").generatePrivate(spec);
        }
        return KeyFactory.getInstance(algorithm, "BC").generatePublic(spec);
    }
}

