/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.sirf;

import java.io.IOException;
import java.io.OutputStream;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.GPSSerialDevice;
import org.dinopolis.gpstool.gpsinput.nmea.GPSNmeaDataProcessor;

public class GPSSirfDataProcessor
extends GPSNmeaDataProcessor {
    protected OutputStream out_stream_;
    protected static int[] SWITCH_SIRF_TO_NMEA_PAYLOAD = new int[]{129, 2, 1, 1, 0, 1, 5, 1, 5, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 18, 192};
    public static final int CHECKSUM_15BIT_LIMIT = (int)Math.pow(2.0, 15.0) - 1;

    public void open() throws GPSException {
        super.open();
        try {
            this.out_stream_ = this.gps_device_.getOutputStream();
            int[] message = GPSSirfDataProcessor.createSirfMessage(SWITCH_SIRF_TO_NMEA_PAYLOAD);
            for (int index = 0; index < message.length; ++index) {
                this.out_stream_.write(message[index]);
            }
            this.out_stream_.flush();
            if (this.gps_device_ instanceof GPSSerialDevice) {
                int speed = SWITCH_SIRF_TO_NMEA_PAYLOAD[SWITCH_SIRF_TO_NMEA_PAYLOAD.length - 1] + SWITCH_SIRF_TO_NMEA_PAYLOAD[SWITCH_SIRF_TO_NMEA_PAYLOAD.length - 2] << 8;
                System.err.println("setting speed to " + speed);
                ((GPSSerialDevice)this.gps_device_).setSerialPortSpeed(speed);
            }
        }
        catch (IOException e) {
            throw new GPSException(e.getMessage());
        }
    }

    protected static int calculateSirfChecksum(int[] message) {
        int checksum = 0;
        for (int index = 0; index < message.length; ++index) {
            checksum += message[index];
        }
        return checksum &= CHECKSUM_15BIT_LIMIT;
    }

    protected static int[] createSirfMessage(int[] payload) {
        int message_length = payload.length + 8;
        int[] message = new int[message_length];
        message[0] = 160;
        message[1] = 162;
        message[2] = (payload.length & 0xFF00) >> 8;
        message[3] = payload.length & 0xFF;
        System.arraycopy(payload, 0, message, 4, payload.length);
        int checksum = GPSSirfDataProcessor.calculateSirfChecksum(payload);
        message[message_length - 4] = (checksum & 0xFF00) >> 8;
        message[message_length - 3] = checksum & 0xFF;
        message[message_length - 2] = 176;
        message[message_length - 1] = 179;
        return message;
    }
}

