/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.nmea;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.GPSGeneralDataProcessor;
import org.dinopolis.gpstool.gpsinput.GPSPosition;
import org.dinopolis.gpstool.gpsinput.GPSPositionError;
import org.dinopolis.gpstool.gpsinput.SatelliteInfo;
import org.dinopolis.gpstool.gpsinput.nmea.NMEA0183Sentence;

public class GPSNmeaDataProcessor
extends GPSGeneralDataProcessor
implements Runnable {
    private static Logger logger_ = Logger.getLogger((Class)GPSNmeaDataProcessor.class);
    private static Logger logger_message_ = Logger.getLogger((String)(GPSNmeaDataProcessor.class.getName() + ".message"));
    private static Logger logger_nmea_ = Logger.getLogger((String)(GPSNmeaDataProcessor.class.getName() + ".nmea"));
    protected InputStream in_stream_ = null;
    protected Thread read_thread_;
    public static final int MAX_NMEA_MESSAGE_LENGTH = 90;
    private static final long EOFREACHED_WAIT_MS = 50L;
    private static final long NMEA_DEVICE_INFO_WAIT_MS = 1000L;
    SatelliteInfo[] satellite_infos_;
    int satellite_info_count_;
    boolean open_ = false;
    int delay_time_ = -1;
    int last_gsv_message_number_ = 0;
    boolean ignore_invalid_checksum_ = false;
    boolean print_ignore_warning_ = true;
    List gps_infos_;
    public static final String INIT_COLD_START = "$PSRF101,0,0,0,000,0,0,12,6*12";
    public static final String INIT_WARM_START = "$PSRF101,0,0,0,000,0,0,12,2*16";
    public static final String INIT_HOT_START = "$PSRF101,0,0,0,000,0,0,12,1*15";

    public GPSNmeaDataProcessor() {
    }

    public GPSNmeaDataProcessor(int delay_time) {
        this();
        this.setDelayTime(delay_time);
    }

    public void setDelayTime(int delay_time) {
        this.delay_time_ = delay_time;
    }

    public boolean isIgnoreInvalidChecksum() {
        return this.ignore_invalid_checksum_;
    }

    public void setIgnoreInvalidChecksum(boolean ignore_invalid_checksum) {
        this.ignore_invalid_checksum_ = ignore_invalid_checksum;
    }

    public void open() throws GPSException {
        if (this.gps_device_ == null) {
            throw new GPSException("no GPSDevice set!");
        }
        try {
            this.gps_device_.open();
            this.open_ = true;
            this.in_stream_ = this.gps_device_.getInputStream();
            this.read_thread_ = new Thread((Runnable)this, "GPSNmeaDataProcessor");
            this.read_thread_.setDaemon(true);
            this.read_thread_.start();
            this.sendInitNmea(this.gps_device_.getOutputStream());
        }
        catch (IOException e) {
            throw new GPSException(e.getMessage());
        }
    }

    private void sendInitNmea(OutputStream outStream) throws IOException {
        outStream.write(INIT_HOT_START.getBytes());
        outStream.write(13);
        outStream.write(10);
    }

    public void close() throws GPSException {
        if (this.gps_device_ == null) {
            throw new GPSException("no GPSDevice set!");
        }
        this.open_ = false;
        this.gps_device_.close();
    }

    public String[] getGPSInfo() {
        String[] info = null;
        if (this.gps_infos_ == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.gps_infos_ == null) {
                info = new String[]{"Unknown NMEA GPS"};
            }
        }
        if (info == null) {
            info = this.gps_infos_.toArray(new String[this.gps_infos_.size()]);
        }
        return info;
    }

    public void run() {
        this.readMessages();
    }

    public long startSendPositionPeriodically(long period) throws GPSException {
        return 1000L;
    }

    public void stopSendPositionPeriodically() throws GPSException {
    }

    protected void readMessages() {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"start reading from GPSDevice...");
        }
        try {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("inputstream: " + this.in_stream_));
            }
            if (!this.readGarbage()) {
                return;
            }
            int loopcount = 0;
            while (true) {
                int data;
                ++loopcount;
                int count = 0;
                char[] buffer = new char[90];
                while ((data = this.getNextByte()) != 13) {
                    if (count >= 89) {
                        System.err.println("ERROR: max. message length exceeded! (" + count + "):" + new String(buffer));
                        if (!this.readGarbage()) {
                            return;
                        }
                        ++loopcount;
                        count = 0;
                        buffer = new char[90];
                        continue;
                    }
                    if (data == 10) continue;
                    buffer[count] = (char)data;
                    ++count;
                }
                if (buffer[0] != '$') {
                    if (!this.readGarbage()) {
                        return;
                    }
                } else {
                    try {
                        NMEA0183Sentence message = new NMEA0183Sentence(buffer, 0, count);
                        buffer[count] = 13;
                        buffer[count + 1] = 10;
                        this.fireRawDataReceived(buffer, 0, count + 2);
                        if (logger_message_.isDebugEnabled()) {
                            logger_message_.debug((Object)("message: '" + message + "'"));
                            logger_message_.debug((Object)("sentenceId: '" + message.getSentenceId() + "'"));
                        }
                        if (!message.isValid() && this.ignore_invalid_checksum_ && this.print_ignore_warning_) {
                            logger_.error((Object)("ERORR: invalid checksum in NMEA message: " + message));
                            logger_.error((Object)("checksum of sentence: " + message.getChecksum() + ", calculated checksum: " + message.getCalculatedChecksum()));
                            logger_.warn((Object)"WARNING: As you chose to ingore invalid messages, this message is only printed once!");
                            this.print_ignore_warning_ = false;
                        }
                        if (this.ignore_invalid_checksum_ || message.isValid() || message.getSentenceId().equals("RFTXT")) {
                            try {
                                this.processNmeaSentence(message);
                            }
                            catch (Exception e) {
                                logger_.error((Object)"ERROR: Exception thrown on processing of NMEA sentences:");
                                logger_.error((Object)message);
                                e.printStackTrace();
                            }
                        } else {
                            logger_.error((Object)("ERORR: invalid checksum in NMEA message: " + message));
                            logger_.error((Object)("checksum of sentence: " + message.getChecksum() + ", calculated checksum: " + message.getCalculatedChecksum()));
                        }
                    }
                    catch (Exception e) {
                        logger_.error((Object)"ERROR: Exception thrown on creation or processing of NMEA sentences:");
                        logger_.error((Object)new String(buffer));
                        e.printStackTrace();
                    }
                }
                if (this.delay_time_ <= 0) continue;
                try {
                    Thread.sleep(this.delay_time_);
                }
                catch (InterruptedException ie) {}
            }
        }
        catch (IOException ioe) {
            if (this.open_) {
                ioe.printStackTrace();
            }
            return;
        }
    }

    private int getNextByte() throws IOException {
        int data = -1;
        while ((data = this.in_stream_.read()) < 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return data;
    }

    protected boolean readGarbage() {
        try {
            while (true) {
                int data;
                if ((data = this.getNextByte()) != 13) {
                    continue;
                }
                data = this.getNextByte();
                if (data == 10) {
                    return true;
                }
                if (!logger_message_.isDebugEnabled()) continue;
                logger_message_.debug((Object)"reading garbage...");
            }
        }
        catch (IOException ioe) {
            System.err.println("GPS Nmea Reading: IOException on beginning of reading, try once more: " + ioe.getMessage());
            return false;
        }
    }

    protected void processNmeaSentence(NMEA0183Sentence sentence) {
        String id = sentence.getSentenceId().toUpperCase();
        if (id.equals("GLL")) {
            this.processGLL(sentence);
            return;
        }
        if (id.equals("RMC")) {
            this.processRMC(sentence);
            return;
        }
        if (id.equals("HDG")) {
            this.processHDG(sentence);
            return;
        }
        if (id.equals("GGA")) {
            this.processGGA(sentence);
            return;
        }
        if (id.equals("GSV")) {
            this.processGSV(sentence);
            return;
        }
        if (id.equals("DBT")) {
            this.processDBT(sentence);
            return;
        }
        if (id.equals("VTG")) {
            this.processVTG(sentence);
            return;
        }
        if (id.equals("HDT")) {
            this.processHDT(sentence);
            return;
        }
        if (id.equals("RME")) {
            this.processRME(sentence);
            return;
        }
        if (id.equals("RFTXT")) {
            this.processRFTXT(sentence);
            return;
        }
        if (id.equals("GSA")) {
            this.processGSA(sentence);
            return;
        }
    }

    protected void processGLL(NMEA0183Sentence sentence) {
        List data_fields;
        String valid;
        if (logger_nmea_.isDebugEnabled()) {
            logger_nmea_.debug((Object)("GLL detected: " + sentence));
        }
        if ((valid = (String)(data_fields = sentence.getDataFields()).get(5)).equals("V")) {
            return;
        }
        String latitude = (String)data_fields.get(0);
        String north_south = (String)data_fields.get(1);
        String longitude = (String)data_fields.get(2);
        String east_west = (String)data_fields.get(3);
        String utc_time = (String)data_fields.get(4);
        if (latitude.length() == 0) {
            return;
        }
        double wgs84_lat = GPSNmeaDataProcessor.nmeaLatOrLongToWGS84(latitude);
        double wgs84_long = GPSNmeaDataProcessor.nmeaLatOrLongToWGS84(longitude);
        GPSPosition pos = new GPSPosition(wgs84_lat, north_south, wgs84_long, east_west);
        this.changeGPSData("location", pos);
    }

    protected void processDBT(NMEA0183Sentence sentence) {
        block3: {
            if (logger_nmea_.isDebugEnabled()) {
                logger_nmea_.debug((Object)("DBT detected: " + sentence));
            }
            List data_fields = sentence.getDataFields();
            String depth_str = (String)sentence.getDataFields().get(2);
            Float depth = null;
            try {
                depth = new Float(depth_str);
                this.changeGPSData("depth", depth);
            }
            catch (NumberFormatException nfe) {
                if (!logger_nmea_.isDebugEnabled()) break block3;
                nfe.printStackTrace();
            }
        }
    }

    protected void processGGA(NMEA0183Sentence sentence) {
        block5: {
            if (logger_nmea_.isDebugEnabled()) {
                logger_nmea_.debug((Object)("GGA detected: " + sentence));
            }
            List data_fields = sentence.getDataFields();
            String latitude = (String)data_fields.get(1);
            String north_south = (String)data_fields.get(2);
            String longitude = (String)data_fields.get(3);
            String east_west = (String)data_fields.get(4);
            int valid_fix = Integer.parseInt((String)data_fields.get(5));
            if (valid_fix == 0) {
                return;
            }
            if (latitude.length() == 0) {
                return;
            }
            double wgs84_lat = GPSNmeaDataProcessor.nmeaLatOrLongToWGS84(latitude);
            double wgs84_long = GPSNmeaDataProcessor.nmeaLatOrLongToWGS84(longitude);
            GPSPosition pos = new GPSPosition(wgs84_lat, north_south, wgs84_long, east_west);
            this.changeGPSData("location", pos);
            String num_sat = (String)data_fields.get(6);
            this.changeGPSData("number_satellites", new Integer(num_sat));
            String hdop = (String)data_fields.get(7);
            this.changeGPSData("horizontal_dop", new Float(hdop));
            try {
                String altitude = (String)data_fields.get(8);
                this.changeGPSData("altitude", new Float(altitude));
            }
            catch (NumberFormatException nfe) {
                if (!logger_nmea_.isDebugEnabled()) break block5;
                nfe.printStackTrace();
            }
        }
    }

    protected void processGSA(NMEA0183Sentence sentence) {
        if (logger_nmea_.isDebugEnabled()) {
            logger_nmea_.debug((Object)("GSA detected: " + sentence));
        }
        List data_fields = sentence.getDataFields();
        Integer[] satellites_ids = new Integer[12];
        String pdop = (String)data_fields.get(14);
        String hdop = (String)data_fields.get(15);
        String vdop = (String)data_fields.get(16);
        int valid_fix = Integer.parseInt((String)data_fields.get(1));
        for (int i = 0; i < 12; ++i) {
            String id = (String)data_fields.get(i + 2);
            if (id == null || id.length() <= 0) continue;
            satellites_ids[i] = new Integer(Integer.parseInt(id));
        }
        this.changeGPSData("position_dop", new Float(pdop));
        this.changeGPSData("horizontal_dop", new Float(hdop));
        this.changeGPSData("vertical_dop", new Float(vdop));
        this.changeGPSData("ids_satellites", satellites_ids);
    }

    protected void processRMC(NMEA0183Sentence sentence) {
        block4: {
            if (logger_nmea_.isDebugEnabled()) {
                logger_nmea_.debug((Object)("RMC detected: " + sentence));
            }
            List data_fields = sentence.getDataFields();
            String latitude = (String)data_fields.get(2);
            String north_south = (String)data_fields.get(3);
            String longitude = (String)data_fields.get(4);
            String east_west = (String)data_fields.get(5);
            if (latitude.length() == 0) {
                return;
            }
            double wgs84_lat = GPSNmeaDataProcessor.nmeaLatOrLongToWGS84(latitude);
            double wgs84_long = GPSNmeaDataProcessor.nmeaLatOrLongToWGS84(longitude);
            GPSPosition pos = new GPSPosition(wgs84_lat, north_south, wgs84_long, east_west);
            this.changeGPSData("location", pos);
            String speed_knots = (String)data_fields.get(6);
            try {
                float speed = Float.parseFloat(speed_knots);
                this.changeGPSData("speed", new Float(speed /= 0.54f));
            }
            catch (NumberFormatException nfe) {
                if (!logger_nmea_.isDebugEnabled()) break block4;
                nfe.printStackTrace();
            }
        }
    }

    protected void processGSV(NMEA0183Sentence sentence) {
        if (logger_nmea_.isDebugEnabled()) {
            logger_nmea_.debug((Object)("GSV detected: " + sentence));
        }
        try {
            List data_fields = sentence.getDataFields();
            int total_number_messages = Integer.parseInt((String)data_fields.get(0));
            int message_number = Integer.parseInt((String)data_fields.get(1));
            int number_satellites = Integer.parseInt((String)data_fields.get(2));
            if (message_number != this.last_gsv_message_number_ + 1 || message_number > 1 && number_satellites != this.satellite_infos_.length) {
                if (logger_nmea_.isDebugEnabled()) {
                    logger_nmea_.debug((Object)"GSV-message in wrong order, ignoring it!");
                }
                this.last_gsv_message_number_ = 0;
                return;
            }
            this.last_gsv_message_number_ = message_number;
            if (message_number == 1) {
                this.satellite_infos_ = new SatelliteInfo[number_satellites];
                this.satellite_info_count_ = 0;
            } else if (this.satellite_infos_ == null) {
                return;
            }
            for (int sat_count = 0; sat_count < 4 && (message_number - 1) * 4 + sat_count < number_satellites; ++sat_count) {
                int prn = Integer.parseInt((String)data_fields.get(3 + 4 * sat_count));
                float elevation = Float.parseFloat((String)data_fields.get(4 + 4 * sat_count));
                float azimuth = Float.parseFloat((String)data_fields.get(5 + 4 * sat_count));
                String srn_string = (String)data_fields.get(6 + 4 * sat_count);
                int srn = srn_string.length() > 0 ? Integer.parseInt((String)data_fields.get(6 + 4 * sat_count)) : 0;
                this.satellite_infos_[this.satellite_info_count_++] = new SatelliteInfo(prn, elevation, azimuth, srn);
            }
            if (message_number == total_number_messages) {
                this.changeGPSData("satellite_info", this.satellite_infos_);
                this.last_gsv_message_number_ = 0;
            }
        }
        catch (NumberFormatException nfe) {
            if (logger_nmea_.isDebugEnabled()) {
                nfe.printStackTrace();
            }
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            System.err.println("WARNING: ArrayIndexOutOfBoundsException in NMEA Sentence: " + sentence + ": " + aiobe.getMessage());
        }
    }

    protected void processHDG(NMEA0183Sentence sentence) {
        block3: {
            if (logger_nmea_.isDebugEnabled()) {
                logger_nmea_.debug((Object)("HDG detected: " + sentence));
            }
            String heading_str = (String)sentence.getDataFields().get(0);
            Float heading = null;
            try {
                heading = new Float(heading_str);
                this.changeGPSData("heading", heading);
            }
            catch (NumberFormatException nfe) {
                if (!logger_nmea_.isDebugEnabled()) break block3;
                nfe.printStackTrace();
            }
        }
    }

    protected void processRME(NMEA0183Sentence sentence) {
        block3: {
            if (logger_nmea_.isDebugEnabled()) {
                logger_nmea_.debug((Object)("RME detected: " + sentence));
            }
            String horizontal_str = (String)sentence.getDataFields().get(0);
            String vertical_str = (String)sentence.getDataFields().get(2);
            String spherical_str = (String)sentence.getDataFields().get(2);
            Double horizontal_error = null;
            Double vertical_error = null;
            Double spherical_error = null;
            try {
                horizontal_error = new Double(horizontal_str);
                vertical_error = new Double(vertical_str);
                spherical_error = new Double(spherical_str);
                this.changeGPSData("epe", new GPSPositionError(spherical_error, horizontal_error, vertical_error));
            }
            catch (NumberFormatException nfe) {
                if (!logger_nmea_.isDebugEnabled()) break block3;
                nfe.printStackTrace();
            }
        }
    }

    protected void processVTG(NMEA0183Sentence sentence) {
        block6: {
            String groundSpeedKms;
            block5: {
                if (logger_nmea_.isDebugEnabled()) {
                    logger_nmea_.debug((Object)("VTG detected: " + sentence));
                }
                List data_fields = sentence.getDataFields();
                String trueCourse = (String)data_fields.get(0);
                groundSpeedKms = (String)data_fields.get(6);
                Float heading = null;
                try {
                    heading = new Float(trueCourse);
                    this.changeGPSData("heading", heading);
                }
                catch (NumberFormatException nfe) {
                    if (!logger_nmea_.isDebugEnabled()) break block5;
                    nfe.printStackTrace();
                }
            }
            try {
                float speed = Float.parseFloat(groundSpeedKms);
                this.changeGPSData("speed", new Float(speed));
            }
            catch (NumberFormatException nfe) {
                if (!logger_nmea_.isDebugEnabled()) break block6;
                nfe.printStackTrace();
            }
        }
    }

    protected void processHDT(NMEA0183Sentence sentence) {
        block3: {
            if (logger_nmea_.isDebugEnabled()) {
                logger_nmea_.debug((Object)("HDT detected: " + sentence));
            }
            String heading_str = (String)sentence.getDataFields().get(0);
            Float heading = null;
            try {
                heading = new Float(heading_str);
                this.changeGPSData("heading", heading);
            }
            catch (NumberFormatException nfe) {
                if (!logger_nmea_.isDebugEnabled()) break block3;
                nfe.printStackTrace();
            }
        }
    }

    protected void processRFTXT(NMEA0183Sentence sentence) {
        if (logger_nmea_.isDebugEnabled()) {
            logger_nmea_.debug((Object)("RFTXT detected: " + sentence));
        }
        String data = (String)sentence.getDataFields().get(0);
        if (this.gps_infos_ == null || data.startsWith("Version:")) {
            this.gps_infos_ = new ArrayList();
        }
        this.gps_infos_.add(data);
    }

    public GPSPosition getGPSPosition() {
        return (GPSPosition)this.getGPSData("location");
    }

    protected GPSPosition getGPSPosition(NMEA0183Sentence sentence) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("position sentence = " + sentence));
        }
        return GPSNmeaDataProcessor.nmeaGllToPos(sentence);
    }

    protected static GPSPosition nmeaGllToPos(NMEA0183Sentence sentence) {
        if (sentence == null) {
            return null;
        }
        List data_fields = sentence.getDataFields();
        String latitude = (String)data_fields.get(0);
        String north_south = (String)data_fields.get(1);
        String longitude = (String)data_fields.get(2);
        String east_west = (String)data_fields.get(3);
        double wgs84_lat = GPSNmeaDataProcessor.nmeaLatOrLongToWGS84(latitude);
        double wgs84_long = GPSNmeaDataProcessor.nmeaLatOrLongToWGS84(longitude);
        GPSPosition pos = new GPSPosition(wgs84_lat, north_south, wgs84_long, east_west);
        return pos;
    }

    protected static double nmeaLatOrLongToWGS84(String nmea_pos) throws NumberFormatException {
        int comma_pos = nmea_pos.indexOf(46);
        if (comma_pos != 4 && comma_pos != 5) {
            throw new NumberFormatException("unknown NMEA position format: '" + nmea_pos + "'");
        }
        String wgs84_deg = nmea_pos.substring(0, comma_pos - 2);
        String wgs84_min = nmea_pos.substring(comma_pos - 2);
        double wgs84_pos = Double.parseDouble(wgs84_deg) + Double.parseDouble(wgs84_min) / 60.0;
        return wgs84_pos;
    }

    public float getHeading() {
        Float heading = (Float)this.getGPSData("heading");
        if (heading != null) {
            return heading.floatValue();
        }
        return -1.0f;
    }

    protected float getHeading(NMEA0183Sentence sentence) {
        if (sentence == null) {
            return -1.0f;
        }
        String heading_str = (String)sentence.getDataFields().get(0);
        try {
            return Float.parseFloat(heading_str);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return -1.0f;
        }
    }
}

