/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;

class GarminPacket {
    public static final int GARMIN_MAX_PACKET_SIZE = 255;
    protected int[] data_;
    protected int packet_id_;
    protected int packet_size_;
    protected int put_index_;
    protected int get_index_;

    public GarminPacket() {
    }

    public GarminPacket(int packet_id, int data_size) {
        this.setPacketId(packet_id);
        this.initializeData(data_size);
    }

    public void initializeData(int data_size) {
        this.data_ = new int[data_size];
        this.packet_size_ = data_size;
        this.reset();
    }

    public void appendData(GarminPacket garmin_packet) {
        this.appendData(garmin_packet, 0);
    }

    public void appendData(GarminPacket garmin_packet, int offset) {
        int[] new_data_ = new int[this.packet_size_ + garmin_packet.getPacketSize() - offset];
        System.arraycopy(this.data_, 0, new_data_, 0, this.packet_size_);
        int[] add_data = garmin_packet.getRawData();
        System.arraycopy(add_data, offset, new_data_, this.packet_size_, add_data.length - offset);
        this.data_ = new_data_;
        this.packet_size_ = new_data_.length;
        this.put_index_ = new_data_.length;
    }

    public int[] getRawData() {
        return this.data_;
    }

    public int getPacketId() {
        return this.packet_id_;
    }

    public void setPacketId(int packet_id) {
        this.packet_id_ = packet_id;
    }

    public int getPacketSize() {
        return this.packet_size_;
    }

    public void setPacket_size(int packet_size) {
        this.packet_size_ = packet_size;
    }

    public void put(int value) {
        this.data_[this.put_index_++] = value;
    }

    public void put(int[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.data_[this.put_index_++] = value[i];
        }
    }

    public void checkGet() throws IllegalStateException {
        if (this.get_index_ >= this.put_index_) {
            throw new IllegalStateException("Not enough data available in packet");
        }
    }

    public short get() throws IllegalStateException {
        this.checkGet();
        return (short)this.data_[this.get_index_++];
    }

    public short get(int offset) {
        return (short)this.data_[offset];
    }

    public boolean getBoolean(int offset) {
        return GarminDataConverter.getGarminBoolean(this.data_, offset);
    }

    public int getByte(int offset) {
        return this.get(offset);
    }

    public int getWord(int offset) {
        return GarminDataConverter.getGarminWord(this.data_, offset);
    }

    public int getInt(int offset) {
        return this.getSignedInt(offset);
    }

    public int getSignedInt(int offset) {
        return GarminDataConverter.getGarminSignedInt(this.data_, offset);
    }

    public int getUnsignedInt(int offset) {
        return GarminDataConverter.getGarminSignedInt(this.data_, offset);
    }

    public float getFloat(int offset) {
        return GarminDataConverter.getGarminFloat(this.data_, offset);
    }

    public long getLong(int offset) {
        return this.getSignedInt(offset);
    }

    public long getLongWord(int offset) {
        return this.getUnsignedInt(offset);
    }

    public long getSignedLong(int offset) {
        return GarminDataConverter.getGarminSignedLong(this.data_, offset);
    }

    public long getUnsignedLong(int offset) {
        return GarminDataConverter.getGarminUnsignedLong(this.data_, offset);
    }

    public double getDouble(int offset) {
        return GarminDataConverter.getGarminDouble(this.data_, offset);
    }

    public byte[] getNextAsByteArray(int offset, int length) {
        return GarminDataConverter.getGarminByteArray(this.data_, offset, length);
    }

    public String getString(int offset) {
        return GarminDataConverter.getGarminString(this.data_, offset);
    }

    public String getString(int offset, int max_length) {
        return GarminDataConverter.getGarminString(this.data_, offset, max_length);
    }

    public double getSemicircleDegrees(int offset) {
        return GarminDataConverter.getGarminSemicircleDegrees(this.data_, offset);
    }

    public double getRadiantDegrees(int offset) {
        return GarminDataConverter.getGarminRadiantDegrees(this.data_, offset);
    }

    public boolean getNextAsBoolean() throws IllegalStateException {
        this.checkGet();
        boolean value = GarminDataConverter.getGarminBoolean(this.data_, this.get_index_);
        ++this.get_index_;
        return value;
    }

    public void setNextAsBoolean(boolean value) {
        this.data_ = GarminDataConverter.setGarminBoolean(value, this.data_, this.put_index_);
        ++this.put_index_;
    }

    public short getNextAsByte() throws IllegalStateException {
        this.checkGet();
        short value = GarminDataConverter.getGarminByte(this.data_, this.get_index_);
        ++this.get_index_;
        return value;
    }

    public void setNextAsByte(int value) {
        this.data_ = GarminDataConverter.setGarminByte(value, this.data_, this.put_index_);
        ++this.put_index_;
    }

    public int getNextAsInt() throws IllegalStateException {
        this.checkGet();
        return this.getNextAsSignedInt();
    }

    public void setNextAsInt(int value) {
        this.setNextAsSignedInt(value);
    }

    public int getNextAsSignedInt() throws IllegalStateException {
        this.checkGet();
        int value = GarminDataConverter.getGarminSignedInt(this.data_, this.get_index_);
        this.get_index_ += 2;
        return value;
    }

    public void setNextAsSignedInt(int value) {
        this.data_ = GarminDataConverter.setGarminSignedInt(value, this.data_, this.put_index_);
        this.put_index_ += 2;
    }

    public int getNextAsUnsignedInt() throws IllegalStateException {
        this.checkGet();
        int value = GarminDataConverter.getGarminUnsignedInt(this.data_, this.get_index_);
        this.get_index_ += 2;
        return value;
    }

    public void setNextAsUnsignedInt(int value) {
        this.data_ = GarminDataConverter.setGarminUnsignedInt(value, this.data_, this.put_index_);
        this.put_index_ += 2;
    }

    public int getNextAsWord() throws IllegalStateException {
        this.checkGet();
        return this.getNextAsUnsignedInt();
    }

    public void setNextAsWord(int value) {
        this.setNextAsUnsignedInt(value);
    }

    public float getNextAsFloat() throws IllegalStateException {
        this.checkGet();
        float value = GarminDataConverter.getGarminFloat(this.data_, this.get_index_);
        this.get_index_ += 4;
        return value;
    }

    public void setNextAsFloat(float value) {
        this.data_ = GarminDataConverter.setGarminFloat(value, this.data_, this.put_index_);
        this.put_index_ += 4;
    }

    public long getNextAsLong() throws IllegalStateException {
        this.checkGet();
        return this.getNextAsUnsignedLong();
    }

    public void setNextAsLong(long value) {
        this.setNextAsUnsignedLong(value);
    }

    public long getNextAsLongWord() throws IllegalStateException {
        this.checkGet();
        return this.getNextAsUnsignedLong();
    }

    public void setNextAsLongWord(long value) {
        this.setNextAsUnsignedLong(value);
    }

    public long getNextAsUnsignedLong() throws IllegalStateException {
        this.checkGet();
        long value = GarminDataConverter.getGarminUnsignedLong(this.data_, this.get_index_);
        this.get_index_ += 4;
        return value;
    }

    public void setNextAsUnsignedLong(long value) {
        this.data_ = GarminDataConverter.setGarminUnsignedLong(value, this.data_, this.put_index_);
        this.put_index_ += 4;
    }

    public long getNextAsSignedLong() throws IllegalStateException {
        this.checkGet();
        long value = GarminDataConverter.getGarminSignedLong(this.data_, this.get_index_);
        this.get_index_ += 4;
        return value;
    }

    public void setNextAsSignedLong(long value) {
        this.data_ = GarminDataConverter.setGarminSignedLong(value, this.data_, this.put_index_);
        this.put_index_ += 4;
    }

    public double getNextAsDouble() throws IllegalStateException {
        this.checkGet();
        double value = GarminDataConverter.getGarminDouble(this.data_, this.get_index_);
        this.get_index_ += 8;
        return value;
    }

    public void setNextAsDouble(double value) {
        this.data_ = GarminDataConverter.setGarminDouble(value, this.data_, this.put_index_);
        this.put_index_ += 8;
    }

    public byte[] getNextAsByteArray(int length) throws IllegalStateException {
        this.checkGet();
        byte[] value = new byte[length];
        value = GarminDataConverter.getGarminByteArray(this.data_, this.get_index_, length);
        this.get_index_ += length;
        return value;
    }

    public void setNextAsByteArray(byte[] value) {
        this.data_ = GarminDataConverter.setGarminByteArray(value, this.data_, this.put_index_);
        this.put_index_ += value.length;
    }

    public String getNextAsString() throws IllegalStateException {
        this.checkGet();
        String value = GarminDataConverter.getGarminString(this.data_, this.get_index_);
        this.get_index_ += value.length() + 1;
        return value;
    }

    public void setNextAsString(String value) {
        int length = value.length() + 1;
        this.data_ = GarminDataConverter.setGarminString(value, this.data_, this.put_index_, length, true);
        this.put_index_ += length;
    }

    public void setNextAsString(String value, int max_length, boolean zero_terminate) {
        this.data_ = GarminDataConverter.setGarminString(value, this.data_, this.put_index_, max_length, zero_terminate);
        this.put_index_ = zero_terminate ? (this.put_index_ += Math.min(value.length() + 1, max_length)) : (this.put_index_ += max_length);
    }

    public String getNextAsString(int max_length) throws IllegalStateException {
        this.checkGet();
        String value = GarminDataConverter.getGarminString(this.data_, this.get_index_, max_length);
        this.get_index_ += value.length();
        return value;
    }

    public double getNextAsSemicircleDegrees() throws IllegalStateException {
        this.checkGet();
        double value = GarminDataConverter.getGarminSemicircleDegrees(this.data_, this.get_index_);
        this.get_index_ += 4;
        return value;
    }

    public void setNextAsSemicircleDegrees(double value) {
        this.data_ = GarminDataConverter.setGarminSemicircleDegrees(value, this.data_, this.put_index_);
        this.put_index_ += 4;
    }

    public double getNextAsRadiantDegrees() throws IllegalStateException {
        this.checkGet();
        double value = GarminDataConverter.getGarminRadiantDegrees(this.data_, this.get_index_);
        this.get_index_ += 8;
        return value;
    }

    public void setNextAsRadiantDegrees(double value) {
        this.data_ = GarminDataConverter.setGarminRadiantDegrees(value, this.data_, this.put_index_);
        this.put_index_ += 8;
    }

    public byte calcChecksum() {
        int checksum = (this.packet_id_ & 0xFF) + this.packet_size_;
        for (int index = 0; index < this.packet_size_; ++index) {
            checksum += this.data_[index] & 0xFF;
        }
        checksum = -checksum;
        return (byte)checksum;
    }

    public int[] getCompatibilityBuffer() {
        int[] buffer = new int[this.packet_size_ + 2];
        buffer[0] = this.packet_id_;
        buffer[1] = this.packet_size_;
        for (int index = 0; index < this.packet_size_; ++index) {
            buffer[index + 2] = this.data_[index];
        }
        return buffer;
    }

    public void reset() {
        this.get_index_ = 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Garminpacket[id=").append(this.packet_id_);
        buffer.append(",size=").append(this.packet_size_);
        buffer.append(",data=[");
        for (int index = 0; index < this.packet_size_; ++index) {
            buffer.append(this.data_[index]);
            buffer.append(" ");
        }
        buffer.append("]]");
        return buffer.toString();
    }

    public static void main(String[] args) {
        int index;
        GarminPacket gp = new GarminPacket(69, 84);
        for (index = 0; index < gp.getPacketSize(); ++index) {
            gp.put(index);
        }
        for (index = 0; index < gp.getPacketSize(); ++index) {
            System.out.println("index: " + index + " value: " + gp.getNextAsByte());
        }
        System.out.println(gp);
    }
}

