/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;

public class GarminFile {
    int num_data_packets_;
    GarminPacket data_;

    public GarminFile(GarminPacket garmin_packet) {
        if (garmin_packet.getPacketSize() != 4) {
            throw new IllegalArgumentException("File Header has size != 4");
        }
        this.num_data_packets_ = (int)garmin_packet.getNextAsLongWord();
        this.data_ = new GarminPacket(0, 0);
    }

    public int getDataPacketCount() {
        return this.num_data_packets_;
    }

    public void addDataPacket(GarminPacket garmin_packet) {
        this.data_.appendData(garmin_packet, 1);
    }

    public short getNextAsByte() throws IllegalStateException {
        return this.data_.getNextAsByte();
    }

    public int getNextAsSignedInt() throws IllegalStateException {
        return this.data_.getNextAsSignedInt();
    }

    public int getNextAsWord() throws IllegalStateException {
        return this.data_.getNextAsWord();
    }

    public float getNextAsFloat() throws IllegalStateException {
        return this.data_.getNextAsFloat();
    }

    public long getNextAsLongWord() throws IllegalStateException {
        return this.data_.getNextAsLongWord();
    }

    public long getNextAsSignedLong() throws IllegalStateException {
        return this.data_.getNextAsSignedLong();
    }

    public String getNextAsString() throws IllegalStateException {
        return this.data_.getNextAsString();
    }

    public String getNextAsString(int max_length) throws IllegalStateException {
        return this.data_.getNextAsString(max_length);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GarminFile[");
        buffer.append("num_packets=").append(this.num_data_packets_).append(",");
        if (this.data_.getPacketSize() > 1024) {
            buffer.append("data (limited to 1024 bytes)=").append(this.data_.toString().substring(0, 1024));
        } else {
            buffer.append("data=").append(this.data_);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

