/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import java.util.HashSet;
import java.util.Vector;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminProduct;

public class GarminCapabilities {
    Vector product_capabilities_ = new Vector();
    HashSet capabilities_ = new HashSet();

    public GarminCapabilities(int[] buffer) {
        for (int i = 0; i < buffer[1] / 3; ++i) {
            String letter = GarminDataConverter.getGarminString(buffer, 2 + 3 * i, 1);
            int number = GarminDataConverter.getGarminWord(buffer, 3 + 3 * i);
            String full_name = letter + number;
            this.capabilities_.add(full_name);
            this.product_capabilities_.add(full_name);
        }
    }

    public GarminCapabilities(GarminPacket pack) {
        for (int i = 0; i < pack.getPacketSize() / 3; ++i) {
            String letter = pack.getNextAsString(1);
            int number = pack.getNextAsWord();
            String full_name = letter + number;
            this.capabilities_.add(full_name);
            this.product_capabilities_.add(full_name);
        }
    }

    /*
     * WARNING - void declaration
     */
    public GarminCapabilities(GarminProduct info) throws GPSException {
        void var31_31;
        void var30_30;
        void var29_29;
        void var28_28;
        void var27_27;
        int i;
        String[] all = new String[]{"P0", "A100", "A200"};
        String[] lnk1 = new String[]{"L1", "A10"};
        String[] lnk2 = new String[]{"L2", "A11"};
        String[] dta1 = new String[]{"D100", "D200"};
        String[] dta2 = new String[]{"D100", "D201"};
        String[] dta3 = new String[]{"D101", "D201"};
        String[] dta4 = new String[]{"D102", "D201"};
        String[] dta13 = new String[]{"D103", "D201"};
        String[] dta5 = new String[]{"D104", "D201"};
        String[] dta6 = new String[]{"D150", "D201"};
        String[] dta7 = new String[]{"D151", "D200"};
        String[] dta8 = new String[]{"D151", "D201"};
        String[] dta9 = new String[]{"D152", "D200"};
        String[] dta10 = new String[]{"D152", "D201"};
        String[] dta11 = new String[]{"D154", "D201"};
        String[] dta12 = new String[]{"D155", "D201"};
        String[] trk1 = new String[]{"A300", "D300"};
        String[] prx1 = new String[]{"A400"};
        String[] prx2 = new String[]{"A400", "D400"};
        String[] prx3 = new String[]{"A400", "D450"};
        String[] prx4 = new String[]{"A400", "D403"};
        String[] alm1 = new String[]{"A500", "D500"};
        String[] alm2 = new String[]{"A500", "D501"};
        String[] alm3 = new String[]{"A500", "D550"};
        String[] alm4 = new String[]{"A500", "D551"};
        switch (info.getProductId()) {
            case 7: {
                String[] lnk = lnk1;
                String[] dta = dta1;
                String[] trk = null;
                String[] prx = null;
                String[] alm = alm1;
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 35: 
            case 42: {
                String[] lnk = lnk1;
                String[] dta = dta1;
                String[] trk = trk1;
                String[] prx = prx2;
                String[] alm = alm1;
                break;
            }
            case 14: {
                String[] lnk = lnk1;
                String[] dta = dta1;
                String[] trk = null;
                String[] prx = prx2;
                String[] alm = alm1;
                break;
            }
            case 15: {
                String[] lnk = lnk1;
                String[] dta = dta7;
                String[] trk = null;
                String[] prx = prx1;
                String[] alm = alm1;
                break;
            }
            case 20: 
            case 33: 
            case 34: 
            case 52: {
                String[] lnk = lnk2;
                String[] dta = dta6;
                String[] trk = null;
                String[] prx = prx3;
                String[] alm = alm3;
                break;
            }
            case 22: {
                String[] lnk = lnk1;
                String[] dta = dta9;
                String[] trk = trk1;
                String[] prx = prx1;
                String[] alm = alm1;
                break;
            }
            case 36: {
                String[] alm;
                String[] prx;
                String[] trk;
                String[] dta;
                String[] lnk;
                if (info.getProductSoftware() < 300) {
                    lnk = lnk1;
                    dta = dta9;
                    trk = trk1;
                    prx = prx1;
                    alm = alm1;
                    break;
                }
                lnk = lnk1;
                dta = dta9;
                trk = trk1;
                prx = null;
                alm = alm1;
                break;
            }
            case 45: {
                String[] lnk = lnk1;
                String[] dta = dta10;
                String[] trk = trk1;
                String[] prx = null;
                String[] alm = alm1;
                break;
            }
            case 29: {
                String[] alm;
                String[] prx;
                String[] trk;
                String[] dta;
                String[] lnk;
                if (info.getProductSoftware() < 400) {
                    lnk = lnk1;
                    dta = dta3;
                    trk = trk1;
                    prx = prx1;
                    alm = alm1;
                    break;
                }
                lnk = lnk1;
                dta = dta4;
                trk = trk1;
                prx = null;
                alm = alm1;
                break;
            }
            case 44: {
                String[] lnk = lnk1;
                String[] dta = dta3;
                String[] trk = trk1;
                String[] prx = prx1;
                String[] alm = alm1;
                break;
            }
            case 31: 
            case 41: 
            case 47: 
            case 55: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 74: {
                String[] lnk = lnk1;
                String[] dta = dta2;
                String[] trk = trk1;
                String[] prx = null;
                String[] alm = alm1;
                break;
            }
            case 39: {
                String[] lnk = lnk1;
                String[] dta = dta8;
                String[] trk = trk1;
                String[] prx = null;
                String[] alm = alm1;
                break;
            }
            case 48: {
                String[] lnk = lnk1;
                String[] dta = dta11;
                String[] trk = trk1;
                String[] prx = null;
                String[] alm = alm2;
                break;
            }
            case 49: 
            case 76: 
            case 88: {
                String[] lnk = lnk1;
                String[] dta = dta4;
                String[] trk = trk1;
                String[] prx = prx1;
                String[] alm = alm2;
                break;
            }
            case 50: 
            case 53: 
            case 112: {
                String[] lnk = lnk1;
                String[] dta = dta10;
                String[] trk = trk1;
                String[] prx = null;
                String[] alm = alm2;
                break;
            }
            case 64: 
            case 98: {
                String[] lnk = lnk2;
                String[] dta = dta6;
                String[] trk = null;
                String[] prx = prx3;
                String[] alm = alm4;
                break;
            }
            case 71: {
                String[] lnk = lnk1;
                String[] dta = dta12;
                String[] trk = trk1;
                String[] prx = null;
                String[] alm = alm2;
                break;
            }
            case 72: {
                String[] lnk = lnk1;
                String[] dta = dta5;
                String[] trk = trk1;
                String[] prx = null;
                String[] alm = alm2;
                break;
            }
            case 77: {
                String[] alm;
                String[] prx;
                String[] trk;
                String[] dta;
                String[] lnk;
                if (info.getProductSoftware() < 301) {
                    lnk = lnk1;
                    dta = dta2;
                    trk = trk1;
                    prx = prx1;
                    alm = alm2;
                    break;
                }
                if (info.getProductSoftware() < 350 || info.getProductSoftware() >= 361) {
                    lnk = lnk1;
                    dta = dta13;
                    trk = trk1;
                    prx = prx4;
                    alm = alm2;
                    break;
                }
                lnk = lnk1;
                dta = dta13;
                trk = trk1;
                prx = null;
                alm = alm2;
                break;
            }
            case 73: 
            case 97: {
                String[] lnk = lnk1;
                String[] dta = dta13;
                String[] trk = trk1;
                String[] prx = null;
                String[] alm = alm2;
                break;
            }
            case 87: 
            case 95: 
            case 96: 
            case 100: 
            case 105: 
            case 106: {
                String[] lnk = lnk1;
                String[] dta = dta13;
                String[] trk = trk1;
                String[] prx = prx4;
                String[] alm = alm2;
                break;
            }
            default: {
                throw new GPSException("Garmin GPS not supported for default capabilities, GPS Id is " + info.getProductId());
            }
        }
        for (i = 0; i < all.length; ++i) {
            this.capabilities_.add(all[i]);
            this.product_capabilities_.add(all[i]);
        }
        for (i = 0; i < ((void)var27_27).length; ++i) {
            this.capabilities_.add(var27_27[i]);
            this.product_capabilities_.add(var27_27[i]);
        }
        for (i = 0; i < ((void)var28_28).length; ++i) {
            this.capabilities_.add(var28_28[i]);
            this.product_capabilities_.add(var28_28[i]);
        }
        if (var29_29 != null) {
            for (i = 0; i < ((void)var29_29).length; ++i) {
                this.capabilities_.add(var29_29[i]);
                this.product_capabilities_.add(var29_29[i]);
            }
        }
        if (var30_30 != null) {
            for (i = 0; i < ((void)var30_30).length; ++i) {
                this.capabilities_.add(var30_30[i]);
                this.product_capabilities_.add(var30_30[i]);
            }
        }
        for (i = 0; i < ((void)var31_31).length; ++i) {
            this.capabilities_.add(var31_31[i]);
            this.product_capabilities_.add(var31_31[i]);
        }
    }

    public String toString() {
        return this.product_capabilities_.toString();
    }

    public Vector getProductCapabilities() {
        return this.product_capabilities_;
    }

    public boolean hasCapability(String name) {
        return this.capabilities_.contains(name);
    }
}

