/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.GPSGeneralDataProcessor;
import org.dinopolis.gpstool.gpsinput.GPSPosition;
import org.dinopolis.gpstool.gpsinput.GPSPositionError;
import org.dinopolis.gpstool.gpsinput.GPSRoute;
import org.dinopolis.gpstool.gpsinput.GPSTrack;
import org.dinopolis.gpstool.gpsinput.GPSTrackpoint;
import org.dinopolis.gpstool.gpsinput.GPSWaypoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminCapabilities;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDisplayData;
import org.dinopolis.gpstool.gpsinput.garmin.GarminFile;
import org.dinopolis.gpstool.gpsinput.garmin.GarminFlashInfo;
import org.dinopolis.gpstool.gpsinput.garmin.GarminMapDescription;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPVT;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPVTD800;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPVTD802;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminProduct;
import org.dinopolis.gpstool.gpsinput.garmin.GarminRoute;
import org.dinopolis.gpstool.gpsinput.garmin.GarminRouteD200;
import org.dinopolis.gpstool.gpsinput.garmin.GarminRouteD201;
import org.dinopolis.gpstool.gpsinput.garmin.GarminRouteD202;
import org.dinopolis.gpstool.gpsinput.garmin.GarminRouteLinkD210;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrack;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrackD310;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrackD311;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrackpointD300;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrackpointD301;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrackpointD304;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD100;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD101;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD102;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD103;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD107;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD108;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD109;
import org.dinopolis.gpstool.gpsinput.garmin.ResultReceivedListener;

public class GPSGarminDataProcessor
extends GPSGeneralDataProcessor {
    protected InputStream in_stream_ = null;
    protected OutputStream out_stream_ = null;
    protected WatchDogThread watch_dog_;
    protected ReaderThread read_thread_;
    protected SimpleDateFormat track_date_format = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
    protected Object acknowledge_lock_ = new Object();
    protected boolean send_success_ = false;
    protected int send_packet_id_ = 0;
    protected List result_routes_;
    protected List result_tracks_;
    protected List result_waypoints_;
    protected GarminPVT result_pvt_;
    protected GarminFlashInfo result_flash_info_;
    protected BufferedImage result_screenshot_;
    protected long result_serial_number_;
    protected GarminFile result_file_;
    protected Object waypoint_sync_request_lock_ = new Object();
    protected Object track_sync_request_lock_ = new Object();
    protected Object route_sync_request_lock_ = new Object();
    protected Object pvt_sync_request_lock_ = new Object();
    protected Object product_info_lock_ = new Object();
    protected Object screenshot_sync_request_lock_ = new Object();
    protected Object serial_number_sync_request_lock_ = new Object();
    protected Object flash_info_sync_request_lock_ = new Object();
    protected Object file_sync_request_lock_ = new Object();
    protected static Logger logger_ = Logger.getLogger((String)"org.dinopolis.gpstool.gpsinput.garmin.GPSGarminDataProcessor");
    protected static Logger logger_packet_ = Logger.getLogger((String)"org.dinopolis.gpstool.gpsinput.garmin.GPSGarminDataProcessor.packet");
    protected static Logger logger_packet_detail_ = Logger.getLogger((String)"org.dinopolis.gpstool.gpsinput.garmin.GPSGarminDataProcessor.packet_detail");
    protected static Logger logger_map_ = Logger.getLogger((String)"org.dinopolis.gpstool.gpsinput.garmin.GPSGarminDataProcessor.map");
    protected static Logger logger_threads_ = Logger.getLogger((String)"org.dinopolis.gpstool.gpsinput.garmin.GPSGarminDataProcessor.packet.threads");
    protected Vector result_listeners_;
    protected Vector route_listeners_;
    protected Vector track_listeners_;
    protected Vector waypoint_listeners_;
    protected boolean send_pvt_periodically_ = false;
    public GarminCapabilities capabilities_;
    public GarminProduct product_info_;
    protected static final long ACK_TIMEOUT = 2000L;
    protected static final int MAX_TRIES = 5;
    protected static final int RECEIVED_WAYPOINTS = 1;
    protected static final int RECEIVED_TRACKS = 2;
    protected static final int RECEIVED_ROUTES = 4;
    public static final int DLE = 16;
    public static final int ETX = 3;
    public static final int ACK = 6;
    public static final int NAK = 21;
    public static final int Pid_Protocol_Array = 253;
    public static final int Pid_Product_Rqst = 254;
    public static final int Pid_Product_Data = 255;
    public static final int Pid_Unit_Id_Info = 9;
    public static final int Pid_Command_Data_L001 = 10;
    public static final int Pid_Xfer_Cmplt_L001 = 12;
    public static final int Pid_Date_Time_Data_L001 = 14;
    public static final int Pid_Position_Data_L001 = 17;
    public static final int Pid_Prx_Wpt_Data_L001 = 19;
    public static final int Pid_Satellite_Info = 26;
    public static final int Pid_Records_L001 = 27;
    public static final int Pid_Enable_Async_Events = 28;
    public static final int Pid_Rte_Hdr_L001 = 29;
    public static final int Pid_Rte_Wpt_Data_L001 = 30;
    public static final int Pid_Almanac_Data_L001 = 31;
    public static final int Pid_Version_Info = 32;
    public static final int Pid_Trk_Data_L001 = 34;
    public static final int Pid_Wpt_Data_L001 = 35;
    public static final int Pid_Serial_Number = 38;
    public static final int Pid_Communication_Speed = 49;
    public static final int Pid_Pvt_Data_L001 = 51;
    public static final int Pid_Display_Data_L001 = 69;
    public static final int Pid_Flash_Erase_Response = 74;
    public static final int Pid_Flash_Erase_Request = 75;
    public static final int Pid_File_Data = 90;
    public static final int Pid_File_Header = 91;
    public static final int Pid_File_Not_Exist = 92;
    public static final int Pid_Flash_Info = 95;
    public static final int Pid_Rte_Link_Data_L001 = 98;
    public static final int Pid_Trk_Hdr_L001 = 99;
    public static final int Pid_Unlock_Code_Send = 108;
    public static final int Pid_Unlock_Code_Response = 109;
    public static final int Pid_Almanac_Data_L002 = 4;
    public static final int Pid_Command_Data_L002 = 11;
    public static final int Pid_Xfer_Cmplt_L002 = 12;
    public static final int Pid_Date_Time_Data_L002 = 20;
    public static final int Pid_Position_Data_L002 = 24;
    public static final int Pid_Records_L002 = 35;
    public static final int Pid_Rte_Hdr_L002 = 37;
    public static final int Pid_Rte_Wpt_Data_L002 = 39;
    public static final int Pid_Wpt_Data_L002 = 43;
    public static final int Cmnd_Abort_Transfer_A010 = 0;
    public static final int Cmnd_Transfer_Alm_A010 = 1;
    public static final int Cmnd_Transfer_Posn_A010 = 2;
    public static final int Cmnd_Transfer_Prx_A010 = 3;
    public static final int Cmnd_Transfer_Rte_A010 = 4;
    public static final int Cmnd_Transfer_Time_A010 = 5;
    public static final int Cmnd_Transfer_Trk_A010 = 6;
    public static final int Cmnd_Transfer_Wpt_A010 = 7;
    public static final int Cmnd_Turn_Off_Pwr_A010 = 8;
    public static final int Cmnd_Transfer_SerialNr = 14;
    public static final int Cmnd_Transfer_Voltage_A010 = 17;
    public static final int Cmnd_Transfer_Screenbitmap_A010 = 32;
    public static final int Cmnd_Start_Pvt_Data_A010 = 49;
    public static final int Cmnd_Stop_Pvt_Data_A010 = 50;
    public static final int Cmnd_Get_Map_Flash_Info = 63;
    public static final int Cmnd_Abort_Transfer_A011 = 0;
    public static final int Cmnd_Transfer_Alm_A011 = 4;
    public static final int Cmnd_Transfer_Rte_A011 = 8;
    public static final int Cmnd_Transfer_Time_A011 = 20;
    public static final int Cmnd_Transfer_Wpt_A011 = 21;
    public static final int Cmnd_Turn_Off_Pwr_A011 = 26;
    public static final int Cmnd_Set_Serial_Speed = 48;
    public static final int Pid_Change_Serial_Speed = 49;
    public static final int Pid_Request_File = 89;
    public static final int Pid_Voltage_Response = 40;
    public static final int Cmnd_Transfer_Temp_Correction = 15;
    public static final int Pid_Temp_Correction_L001 = 39;

    public GPSGarminDataProcessor() {
        this.watch_dog_ = new WatchDogThread();
        this.watch_dog_.setDaemon(true);
        this.watch_dog_.pauseWatching(true);
        this.watch_dog_.startWatching();
        this.read_thread_ = new ReaderThread();
        this.read_thread_.setDaemon(true);
    }

    public void open() throws GPSException {
        if (this.gps_device_ == null) {
            throw new GPSException("no GPSDevice set!");
        }
        try {
            this.gps_device_.open();
            this.in_stream_ = this.gps_device_.getInputStream();
            this.out_stream_ = this.gps_device_.getOutputStream();
            this.read_thread_.start();
            GarminProduct info = this.getGarminProductInfo(2000L);
            if (info == null) {
                this.close();
                throw new GPSException("Garmin device does not respond!");
            }
        }
        catch (IOException e) {
            throw new GPSException(e);
        }
    }

    public void close() throws GPSException {
        if (this.read_thread_ != null && this.read_thread_.isAlive()) {
            this.read_thread_.stopThread();
        }
        if (this.watch_dog_ != null && this.watch_dog_.isAlive()) {
            this.watch_dog_.stopWatching();
        }
        if (this.in_stream_ != null) {
            try {
                this.in_stream_.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            this.in_stream_ = null;
        }
        if (this.out_stream_ != null) {
            try {
                this.out_stream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out_stream_ = null;
        }
        if (this.gps_device_ != null) {
            this.gps_device_.close();
        }
    }

    public String[] getGPSInfo() {
        String[] info;
        String name = this.product_info_.getProductName() + " (id=" + this.product_info_.getProductId() + ") V" + (double)this.product_info_.getProductSoftware() / 100.0;
        Vector capabilities = this.capabilities_.getProductCapabilities();
        StringBuffer capabilities_string = new StringBuffer("Supported Formats: ");
        for (int index = 0; index < capabilities.size() - 1; ++index) {
            capabilities_string.append(capabilities.get(index)).append(", ");
        }
        capabilities_string.append(capabilities.get(capabilities.size() - 1));
        long serial_number = -1L;
        try {
            serial_number = this.getSerialNumber(1000L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (serial_number != -1L) {
            String ser_num_str = "Serial Nr. " + serial_number;
            info = new String[]{name, capabilities_string.toString(), ser_num_str};
        } else {
            info = new String[]{name, capabilities_string.toString()};
        }
        return info;
    }

    public long startSendPositionPeriodically(long period) throws GPSException {
        try {
            this.requestStartPvtData();
        }
        catch (IOException ioe) {
            throw new GPSException(ioe);
        }
        return 1000L;
    }

    public void stopSendPositionPeriodically() throws GPSException {
        try {
            this.requestStopPvtData();
        }
        catch (IOException ioe) {
            throw new GPSException(ioe);
        }
    }

    public List getWaypoints() throws GPSException, UnsupportedOperationException {
        return this.getWaypoints(0L);
    }

    public void setWaypoints(List waypoints) throws GPSException, UnsupportedOperationException {
        if (!this.capabilities_.hasCapability("A100")) {
            throw new UnsupportedOperationException("Garmin Device does not support waypoint transfer");
        }
        int num_packets = waypoints.size();
        int packet_count = 1;
        this.fireProgressActionStart("setwaypoints", 1, num_packets + 1);
        GarminPacket records = new GarminPacket();
        if (this.capabilities_.hasCapability("L1")) {
            records.setPacketId(27);
        } else {
            records.setPacketId(35);
        }
        records.initializeData(2);
        records.setNextAsWord(num_packets);
        GarminPacket xfer_cmplt = new GarminPacket();
        if (this.capabilities_.hasCapability("L1")) {
            xfer_cmplt.setPacketId(12);
        } else {
            xfer_cmplt.setPacketId(12);
        }
        xfer_cmplt.initializeData(2);
        if (this.capabilities_.hasCapability("A10")) {
            xfer_cmplt.setNextAsWord(7);
        }
        if (this.capabilities_.hasCapability("A11")) {
            xfer_cmplt.setNextAsWord(21);
        }
        this.putPacket(records);
        for (int i = 0; i < waypoints.size(); ++i) {
            GarminPacket pack = new GarminPacket();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Sending waypoint " + waypoints.get(i)));
            }
            if (this.capabilities_.hasCapability("L1")) {
                if (this.capabilities_.hasCapability("D100")) {
                    pack = new GarminWaypointD100((GPSWaypoint)waypoints.get(i)).toGarminPacket(35);
                } else if (this.capabilities_.hasCapability("D101")) {
                    pack = new GarminWaypointD101((GPSWaypoint)waypoints.get(i)).toGarminPacket(35);
                } else if (this.capabilities_.hasCapability("D102")) {
                    pack = new GarminWaypointD102((GPSWaypoint)waypoints.get(i)).toGarminPacket(35);
                } else if (this.capabilities_.hasCapability("D103")) {
                    pack = new GarminWaypointD103((GPSWaypoint)waypoints.get(i)).toGarminPacket(35);
                } else if (this.capabilities_.hasCapability("D107")) {
                    pack = new GarminWaypointD107((GPSWaypoint)waypoints.get(i)).toGarminPacket(35);
                } else if (this.capabilities_.hasCapability("D108")) {
                    pack = new GarminWaypointD108((GPSWaypoint)waypoints.get(i)).toGarminPacket(35);
                } else if (this.capabilities_.hasCapability("D109")) {
                    pack = new GarminWaypointD109((GPSWaypoint)waypoints.get(i)).toGarminPacket(35);
                } else {
                    System.err.println("ERROR: no possible waypoint packet found!");
                }
            } else if (this.capabilities_.hasCapability("L2")) {
                if (this.capabilities_.hasCapability("D100")) {
                    pack = new GarminWaypointD100((GPSWaypoint)waypoints.get(i)).toGarminPacket(43);
                } else if (this.capabilities_.hasCapability("D101")) {
                    pack = new GarminWaypointD101((GPSWaypoint)waypoints.get(i)).toGarminPacket(43);
                } else if (this.capabilities_.hasCapability("D102")) {
                    pack = new GarminWaypointD102((GPSWaypoint)waypoints.get(i)).toGarminPacket(43);
                } else if (this.capabilities_.hasCapability("D103")) {
                    pack = new GarminWaypointD103((GPSWaypoint)waypoints.get(i)).toGarminPacket(43);
                } else if (this.capabilities_.hasCapability("D107")) {
                    pack = new GarminWaypointD107((GPSWaypoint)waypoints.get(i)).toGarminPacket(43);
                } else if (this.capabilities_.hasCapability("D108")) {
                    pack = new GarminWaypointD108((GPSWaypoint)waypoints.get(i)).toGarminPacket(43);
                } else if (this.capabilities_.hasCapability("D109")) {
                    pack = new GarminWaypointD109((GPSWaypoint)waypoints.get(i)).toGarminPacket(43);
                } else {
                    System.err.println("ERROR: no possible waypoint packet found!");
                }
            } else {
                System.err.println("ERROR: no possible waypoint protocol found!");
            }
            if (packet_count % 10 == 0) {
                this.fireProgressActionProgress("setwaypoints", packet_count);
            }
            this.putPacket(pack);
            ++packet_count;
        }
        this.fireProgressActionProgress("setwaypoints", num_packets);
        this.putPacket(xfer_cmplt);
        this.fireProgressActionEnd("setwaypoints");
    }

    public List getRoutes() throws UnsupportedOperationException, GPSException {
        return this.getRoutes(0L);
    }

    public void setRoutes(List routes) throws GPSException, UnsupportedOperationException {
        if (!this.capabilities_.hasCapability("A200") && !this.capabilities_.hasCapability("A201")) {
            throw new UnsupportedOperationException("Garmin Device does not support route transfer");
        }
        int num_packets = routes.size();
        boolean add_link_packets = this.capabilities_.hasCapability("D210");
        for (int route_count = 0; route_count < routes.size(); ++route_count) {
            int num_points = ((GPSRoute)routes.get(route_count)).getWaypoints().size();
            num_packets += num_points;
            if (!add_link_packets) continue;
            num_packets += num_points - 1;
        }
        System.out.println("Sending " + num_packets + " packets.");
        int packet_count = 1;
        this.fireProgressActionStart("setroutes", 1, num_packets + 1);
        GarminPacket records = new GarminPacket();
        if (this.capabilities_.hasCapability("L1")) {
            records.setPacketId(27);
        } else if (this.capabilities_.hasCapability("L2")) {
            records.setPacketId(35);
        } else {
            throw new UnsupportedOperationException("Garmin Device no link protocol found !");
        }
        records.initializeData(2);
        records.setNextAsWord(num_packets);
        GarminPacket xfer_cmplt = new GarminPacket();
        if (this.capabilities_.hasCapability("L1")) {
            xfer_cmplt.setPacketId(12);
        } else {
            xfer_cmplt.setPacketId(12);
        }
        xfer_cmplt.initializeData(2);
        if (this.capabilities_.hasCapability("A10")) {
            xfer_cmplt.setNextAsWord(6);
        }
        this.putPacket(records);
        GarminRouteLinkD210 link_packet_d210 = new GarminRouteLinkD210();
        link_packet_d210.setClassId(3);
        link_packet_d210.setSubclass(new byte[]{0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        GarminPacket link_packet = link_packet_d210.toGarminPacket(98);
        for (int route_count = 0; route_count < routes.size(); ++route_count) {
            GarminPacket pack = new GarminPacket();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Sending route " + routes.get(route_count)));
            }
            if (this.capabilities_.hasCapability("L1")) {
                if (this.capabilities_.hasCapability("D200")) {
                    pack = new GarminRouteD200((GPSRoute)routes.get(route_count)).toGarminPacket(29);
                } else if (this.capabilities_.hasCapability("D201")) {
                    pack = new GarminRouteD201((GPSRoute)routes.get(route_count)).toGarminPacket(29);
                } else if (this.capabilities_.hasCapability("D202")) {
                    pack = new GarminRouteD202((GPSRoute)routes.get(route_count)).toGarminPacket(29);
                } else if (!this.capabilities_.hasCapability("A300")) {
                    System.err.println("ERROR: no possible route header packet found!");
                }
            } else if (this.capabilities_.hasCapability("L2")) {
                if (this.capabilities_.hasCapability("D200")) {
                    pack = new GarminRouteD200((GPSRoute)routes.get(route_count)).toGarminPacket(37);
                } else if (this.capabilities_.hasCapability("D201")) {
                    pack = new GarminRouteD201((GPSRoute)routes.get(route_count)).toGarminPacket(37);
                } else if (this.capabilities_.hasCapability("D202")) {
                    pack = new GarminRouteD202((GPSRoute)routes.get(route_count)).toGarminPacket(37);
                } else if (!this.capabilities_.hasCapability("A300")) {
                    System.err.println("ERROR: no possible route header packet found!");
                }
            } else {
                System.err.println("ERROR: no possible route header protocol found!");
            }
            if (packet_count % 10 == 0) {
                this.fireProgressActionProgress("setroutes", packet_count);
            }
            this.putPacket(pack);
            ++packet_count;
            GPSRoute route = (GPSRoute)routes.get(route_count);
            List waypoints = route.getWaypoints();
            int waypoint_number = waypoints.size();
            for (int waypoint_count = 0; waypoint_count < waypoint_number; ++waypoint_count) {
                GPSWaypoint waypoint = (GPSWaypoint)waypoints.get(waypoint_count);
                if (this.capabilities_.hasCapability("L1")) {
                    if (this.capabilities_.hasCapability("D100")) {
                        pack = new GarminWaypointD100(waypoint).toGarminPacket(30);
                    } else if (this.capabilities_.hasCapability("D101")) {
                        pack = new GarminWaypointD101(waypoint).toGarminPacket(30);
                    } else if (this.capabilities_.hasCapability("D102")) {
                        pack = new GarminWaypointD102(waypoint).toGarminPacket(30);
                    } else if (this.capabilities_.hasCapability("D103")) {
                        pack = new GarminWaypointD103(waypoint).toGarminPacket(30);
                    } else if (this.capabilities_.hasCapability("D107")) {
                        pack = new GarminWaypointD107(waypoint).toGarminPacket(30);
                    } else if (this.capabilities_.hasCapability("D108")) {
                        pack = new GarminWaypointD108(waypoint).toGarminPacket(30);
                    } else if (this.capabilities_.hasCapability("D109")) {
                        pack = new GarminWaypointD109(waypoint).toGarminPacket(30);
                    } else {
                        System.err.println("ERROR: no possible waypoint packet found!");
                    }
                } else if (this.capabilities_.hasCapability("L2")) {
                    if (this.capabilities_.hasCapability("D100")) {
                        pack = new GarminWaypointD100(waypoint).toGarminPacket(39);
                    } else if (this.capabilities_.hasCapability("D101")) {
                        pack = new GarminWaypointD101(waypoint).toGarminPacket(39);
                    } else if (this.capabilities_.hasCapability("D102")) {
                        pack = new GarminWaypointD102(waypoint).toGarminPacket(39);
                    } else if (this.capabilities_.hasCapability("D103")) {
                        pack = new GarminWaypointD103(waypoint).toGarminPacket(39);
                    } else if (this.capabilities_.hasCapability("D107")) {
                        pack = new GarminWaypointD107(waypoint).toGarminPacket(39);
                    } else if (this.capabilities_.hasCapability("D108")) {
                        pack = new GarminWaypointD108(waypoint).toGarminPacket(39);
                    } else if (this.capabilities_.hasCapability("D109")) {
                        pack = new GarminWaypointD109(waypoint).toGarminPacket(39);
                    } else {
                        System.err.println("ERROR: no possible waypoint packet found!");
                    }
                } else {
                    System.err.println("ERROR: no possible route point protocol found!");
                }
                if (packet_count % 10 == 0) {
                    this.fireProgressActionProgress("setroutes", packet_count);
                }
                this.putPacket(pack);
                if (waypoint_count < waypoint_number - 1 && this.capabilities_.hasCapability("D210")) {
                    this.putPacket(link_packet);
                    link_packet.reset();
                }
                ++packet_count;
            }
        }
        this.fireProgressActionProgress("setroutes", num_packets);
        this.putPacket(xfer_cmplt);
        this.fireProgressActionEnd("setroutes");
    }

    public List getTracks() throws GPSException, UnsupportedOperationException {
        return this.getTracks(0L);
    }

    public void setTracks(List tracks) throws GPSException, UnsupportedOperationException {
        if (!this.capabilities_.hasCapability("A300") && !this.capabilities_.hasCapability("A301")) {
            throw new UnsupportedOperationException("Garmin Device does not support track transfer");
        }
        int num_packets = tracks.size();
        for (int track_count = 0; track_count < tracks.size(); ++track_count) {
            num_packets += ((GPSTrack)tracks.get(track_count)).getWaypoints().size();
        }
        int packet_count = 1;
        this.fireProgressActionStart("settracks", 1, num_packets + 1);
        GarminPacket records = new GarminPacket();
        if (this.capabilities_.hasCapability("L1")) {
            records.setPacketId(27);
        } else {
            records.setPacketId(35);
        }
        records.initializeData(2);
        records.setNextAsWord(num_packets);
        GarminPacket xfer_cmplt = new GarminPacket();
        if (this.capabilities_.hasCapability("L1")) {
            xfer_cmplt.setPacketId(12);
        } else {
            xfer_cmplt.setPacketId(12);
        }
        xfer_cmplt.initializeData(2);
        if (this.capabilities_.hasCapability("A10")) {
            xfer_cmplt.setNextAsWord(6);
        }
        this.putPacket(records);
        for (int track_count = 0; track_count < tracks.size(); ++track_count) {
            GarminPacket pack = new GarminPacket();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Sending track " + tracks.get(track_count)));
            }
            if (this.capabilities_.hasCapability("L1")) {
                if (this.capabilities_.hasCapability("D310")) {
                    pack = new GarminTrackD310((GPSTrack)tracks.get(track_count)).toGarminPacket(99);
                } else if (!this.capabilities_.hasCapability("A300")) {
                    System.err.println("ERROR: no possible track header packet found!");
                }
            } else {
                System.err.println("ERROR: no possible track header protocol found!");
            }
            if (packet_count % 10 == 0) {
                this.fireProgressActionProgress("settracks", packet_count);
            }
            this.putPacket(pack);
            ++packet_count;
            GPSTrack current_track = (GPSTrack)tracks.get(track_count);
            System.out.println(current_track.getIdentification());
            List waypoints = current_track.getWaypoints();
            int waypoint_number = waypoints.size();
            for (int j = 0; j < waypoint_number; ++j) {
                GPSTrackpoint trackpoint = (GPSTrackpoint)waypoints.get(j);
                if (this.capabilities_.hasCapability("L1")) {
                    if (this.capabilities_.hasCapability("D300")) {
                        pack = new GarminTrackpointD300(trackpoint).toGarminPacket(34);
                    } else if (this.capabilities_.hasCapability("D301")) {
                        pack = new GarminTrackpointD301(trackpoint).toGarminPacket(34);
                    } else {
                        System.err.println("ERROR: no possible track point packet found!");
                    }
                } else {
                    System.err.println("ERROR: no possible track point protocol found!");
                }
                if (packet_count % 10 == 0) {
                    this.fireProgressActionProgress("settracks", packet_count);
                }
                this.putPacket(pack);
                ++packet_count;
            }
        }
        this.fireProgressActionProgress("settracks", num_packets);
        this.putPacket(xfer_cmplt);
        this.fireProgressActionEnd("settracks");
    }

    public BufferedImage getScreenShot() throws UnsupportedOperationException, GPSException {
        return this.getScreenShot(0L);
    }

    public long getSerialNumber() throws GPSException {
        try {
            return this.getSerialNumber(0L);
        }
        catch (IOException ioe) {
            throw new GPSException(ioe);
        }
    }

    protected static float calcHeading(float speed_north, float speed_east) {
        double heading = Math.toDegrees(Math.atan2(speed_north, speed_east));
        if ((heading = 90.0 - heading) < 0.0) {
            heading = 360.0 + heading;
        }
        return (float)heading;
    }

    protected static float calcSpeed(float speed_north, float speed_east) {
        return (float)(Math.sqrt(speed_north * speed_north + speed_east * speed_east) * 3.6);
    }

    protected boolean sendCommand(int request, int cmd, long timeout) throws IOException {
        if (logger_packet_.isDebugEnabled()) {
            logger_packet_.debug((Object)("Sending request " + request + "/" + cmd));
        }
        GarminPacket garmin_packet = new GarminPacket(request, 2);
        garmin_packet.put(cmd);
        garmin_packet.put(0);
        this.putPacket(garmin_packet, timeout);
        return this.send_success_;
    }

    protected boolean sendCommand(int request, long timeout) throws IOException {
        if (logger_packet_.isDebugEnabled()) {
            logger_packet_.debug((Object)("Sending request " + request));
        }
        GarminPacket garmin_packet = new GarminPacket(request, 0);
        this.putPacket(garmin_packet, timeout);
        return this.send_success_;
    }

    protected void sendCommandAsync(int request, int cmd) throws IOException {
        if (logger_packet_.isDebugEnabled()) {
            logger_packet_.debug((Object)("Sending request async " + request + "/" + cmd));
        }
        GarminPacket garmin_packet = new GarminPacket(request, 2);
        garmin_packet.put(cmd);
        garmin_packet.put(0);
        this.putPacketAsync(garmin_packet);
    }

    protected void sendCommandAsync(int request) throws IOException {
        if (logger_packet_.isDebugEnabled()) {
            logger_packet_.debug((Object)("Sending request async " + request));
        }
        GarminPacket garmin_packet = new GarminPacket(request, 0);
        this.putPacketAsync(garmin_packet);
    }

    protected void putPacketAsync(GarminPacket garmin_packet) {
        try {
            if (logger_packet_.isDebugEnabled()) {
                logger_packet_.debug((Object)("Sending packet async " + garmin_packet.getPacketId()));
            }
            if (logger_packet_detail_.isDebugEnabled()) {
                logger_packet_detail_.debug((Object)("send packet details: " + garmin_packet));
            }
            this.out_stream_.write(16);
            this.out_stream_.write(garmin_packet.getPacketId());
            int packet_size = garmin_packet.getPacketSize();
            if (packet_size == 16) {
                this.out_stream_.write(16);
            }
            this.out_stream_.write(packet_size);
            for (int index = 0; index < packet_size; ++index) {
                short data = garmin_packet.get();
                if (data == 16) {
                    this.out_stream_.write(16);
                }
                this.out_stream_.write(data);
            }
            byte checksum = garmin_packet.calcChecksum();
            if (checksum == 16) {
                this.out_stream_.write(16);
            }
            this.out_stream_.write(checksum);
            this.out_stream_.write(16);
            this.out_stream_.write(3);
            this.out_stream_.flush();
            String buffer_string = "sent: " + garmin_packet.toString() + "\n";
            this.fireRawDataReceived(buffer_string.toCharArray(), 0, buffer_string.length());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void putPacket(GarminPacket garmin_packet) {
        this.putPacket(garmin_packet, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putPacket(GarminPacket garmin_packet, long timeout) {
        do {
            Object object = this.acknowledge_lock_;
            synchronized (object) {
                this.send_success_ = false;
                this.send_packet_id_ = 0;
                this.putPacketAsync(garmin_packet);
                try {
                    this.acknowledge_lock_.wait(timeout);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        } while (this.send_success_ && this.send_packet_id_ == garmin_packet.getPacketId());
    }

    protected GarminPacket getPacket() {
        try {
            byte calc_checksum;
            int bytes_scanned = 0;
            int packet_id = 0;
            this.watch_dog_.setPacketId(packet_id);
            while (true) {
                packet_id = this.in_stream_.read();
                this.watch_dog_.pauseWatching(false);
                this.watch_dog_.reset();
                ++bytes_scanned;
                if (packet_id != 16) continue;
                packet_id = this.in_stream_.read();
                this.watch_dog_.reset();
                ++bytes_scanned;
                if (packet_id != 16 && packet_id != 3) break;
            }
            this.watch_dog_.setPacketId(packet_id);
            int data = this.in_stream_.read();
            this.watch_dog_.reset();
            if (data == 16) {
                data = this.in_stream_.read();
                this.watch_dog_.reset();
                if (data != 16) {
                    if (logger_packet_.isDebugEnabled()) {
                        logger_packet_.debug((Object)"missing DLE stuffing in packet size");
                    }
                    this.sendCommandAsync(21, packet_id);
                    this.watch_dog_.pauseWatching(true);
                    return null;
                }
            }
            int packet_size = data & 0xFF;
            GarminPacket garmin_packet = new GarminPacket(packet_id, packet_size);
            if (logger_packet_.isDebugEnabled()) {
                logger_packet_.debug((Object)("receiving packet id: " + packet_id + " size: " + packet_size));
            }
            for (int data_index = 0; data_index < packet_size; ++data_index) {
                data = this.in_stream_.read();
                this.watch_dog_.reset();
                garmin_packet.put(data);
                if (data != 16) continue;
                data = this.in_stream_.read();
                this.watch_dog_.reset();
                if (data == 16) continue;
                if (logger_packet_.isDebugEnabled()) {
                    logger_packet_.debug((Object)"missing DLE stuffing in packet data");
                }
                this.sendCommandAsync(21, packet_id);
                this.watch_dog_.pauseWatching(true);
                return null;
            }
            byte packet_checksum = (byte)this.in_stream_.read();
            this.watch_dog_.reset();
            if (packet_checksum == 16) {
                packet_checksum = (byte)this.in_stream_.read();
                this.watch_dog_.reset();
                if (packet_checksum != 16) {
                    if (logger_packet_.isDebugEnabled()) {
                        logger_packet_.debug((Object)"missing DLE stuffing in packet checksum");
                    }
                    this.sendCommandAsync(21, packet_id);
                    this.watch_dog_.pauseWatching(true);
                    return null;
                }
            }
            if ((calc_checksum = garmin_packet.calcChecksum()) != packet_checksum) {
                if (logger_packet_.isDebugEnabled()) {
                    logger_packet_.debug((Object)("bad checksum (is " + calc_checksum + " should be " + packet_checksum));
                }
                this.sendCommandAsync(21, packet_id);
                this.watch_dog_.pauseWatching(true);
                return null;
            }
            int dle = this.in_stream_.read();
            int etx = this.in_stream_.read();
            this.watch_dog_.reset();
            if (dle != 16 || etx != 3) {
                if (logger_packet_.isDebugEnabled()) {
                    StringBuffer debug_message = new StringBuffer();
                    debug_message.append("bad packet framing\n");
                    debug_message.append("id is " + packet_id);
                    debug_message.append("\nsize is " + packet_size);
                    debug_message.append("\ndata is: \n");
                    for (int i = 0; i < packet_size; ++i) {
                        debug_message.append(garmin_packet.get() + " ");
                    }
                    debug_message.append("\nchecksum is " + packet_checksum);
                    debug_message.append("\nDLE byte is " + dle);
                    debug_message.append("\nETX byte is " + etx);
                    logger_packet_.debug((Object)debug_message.toString());
                }
                this.sendCommandAsync(21, packet_id);
                this.watch_dog_.pauseWatching(true);
                return null;
            }
            if (packet_id != 6 && packet_id != 21) {
                this.sendCommandAsync(6, packet_id);
            }
            this.watch_dog_.pauseWatching(true);
            String buffer_string = "received: " + garmin_packet.toString() + "\n";
            this.fireRawDataReceived(buffer_string.toCharArray(), 0, buffer_string.length());
            return garmin_packet;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GarminProduct getGarminProductInfo(long timeout) throws IOException, GPSException {
        if (this.product_info_ != null) {
            return this.product_info_;
        }
        Object object = this.product_info_lock_;
        synchronized (object) {
            this.requestProductInfo();
            try {
                this.product_info_lock_.wait(timeout);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        if (this.product_info_ != null && this.capabilities_ == null) {
            this.capabilities_ = new GarminCapabilities(this.product_info_);
        }
        return this.product_info_;
    }

    protected GarminCapabilities getGarminCapabilities(long timeout) throws IOException, GPSException {
        if (this.product_info_ == null) {
            this.getGarminProductInfo(timeout);
        }
        return this.capabilities_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GarminPVT getPVT(long timeout) throws IOException {
        Object object = this.pvt_sync_request_lock_;
        synchronized (object) {
            this.result_pvt_ = null;
            this.requestPVT();
            try {
                this.pvt_sync_request_lock_.wait(timeout);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        return this.result_pvt_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRoutes(long timeout) throws GPSException, UnsupportedOperationException {
        if (!this.capabilities_.hasCapability("A200") && !this.capabilities_.hasCapability("A201")) {
            throw new UnsupportedOperationException("Garmin Device does not support route transfer");
        }
        try {
            Object object = this.route_sync_request_lock_;
            synchronized (object) {
                this.result_routes_ = null;
                this.requestRoutes();
                try {
                    this.route_sync_request_lock_.wait(timeout);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            return this.result_routes_;
        }
        catch (IOException e) {
            throw new GPSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTracks(long timeout) throws GPSException, UnsupportedOperationException {
        if (!(this.capabilities_.hasCapability("A300") || this.capabilities_.hasCapability("A301") || this.capabilities_.hasCapability("A302"))) {
            throw new UnsupportedOperationException("Garmin Device does not support track transfer");
        }
        try {
            Object object = this.track_sync_request_lock_;
            synchronized (object) {
                this.result_tracks_ = null;
                this.requestTracks();
                try {
                    this.track_sync_request_lock_.wait(timeout);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            return this.result_tracks_;
        }
        catch (IOException e) {
            throw new GPSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getScreenShot(long timeout) throws GPSException {
        try {
            Object object = this.screenshot_sync_request_lock_;
            synchronized (object) {
                this.result_screenshot_ = null;
                this.requestScreenShot();
                try {
                    this.screenshot_sync_request_lock_.wait(timeout);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            return this.result_screenshot_;
        }
        catch (IOException e) {
            throw new GPSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSerialNumber(long timeout) throws IOException {
        Object object = this.serial_number_sync_request_lock_;
        synchronized (object) {
            this.result_serial_number_ = -1L;
            this.requestSerialNumber();
            try {
                this.serial_number_sync_request_lock_.wait(timeout);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        return this.result_serial_number_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWaypoints(long timeout) throws GPSException, UnsupportedOperationException {
        if (!this.capabilities_.hasCapability("A100")) {
            throw new UnsupportedOperationException("Garmin Device does not support waypoint transfer");
        }
        try {
            Object object = this.waypoint_sync_request_lock_;
            synchronized (object) {
                this.result_waypoints_ = null;
                this.requestWaypoints();
                try {
                    this.waypoint_sync_request_lock_.wait(timeout);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            return this.result_waypoints_;
        }
        catch (IOException e) {
            throw new GPSException(e);
        }
    }

    private void getMap(GarminMapDescription map_description, long timeout) throws IOException {
        String[] suffices = new String[]{"TRE", "LBL", "RGN", "NET", "NOD", "SRT"};
        for (int suffix_index = 0; suffix_index < suffices.length; ++suffix_index) {
            GarminFile map = this.getMapFile(map_description, suffices[suffix_index], timeout);
        }
    }

    private GarminFile getMapFile(GarminMapDescription map_description, String suffix, long timeout) throws IOException, FileNotFoundException {
        GarminFile map = null;
        try {
            map = this.getFile(map_description.getImageFileName() + ".TRE", timeout);
            System.out.println("Successfully downloaded map by using the ImageFileName: " + map_description.getMapName());
        }
        catch (FileNotFoundException fnfe) {
            map = this.getFile(map_description.getMapNumberFileName() + ".TRE", timeout);
            System.out.println("Successfully downloaded map by using mapnumberfilename: " + map_description.getMapName());
        }
        return map;
    }

    private List getMaps(long timeout) throws IOException {
        GarminFile map_dir = this.getFile("MAPSOURC.MPS", timeout);
        System.out.println("getMaps:" + map_dir);
        Vector<GarminMapDescription> maps_in_unit = new Vector<GarminMapDescription>();
        short has_next = map_dir.getNextAsByte();
        while (has_next == 76) {
            int length = map_dir.getNextAsWord();
            int product_number = (int)map_dir.getNextAsLongWord();
            int img_number = (int)map_dir.getNextAsLongWord();
            String map_type = map_dir.getNextAsString();
            String map_name = map_dir.getNextAsString();
            String map_area = map_dir.getNextAsString();
            int map_number = (int)map_dir.getNextAsLongWord();
            map_dir.getNextAsLongWord();
            GarminMapDescription map_description = new GarminMapDescription();
            map_description.setMapLength(length);
            map_description.setMapProductNumber(product_number);
            map_description.setImageNumber(img_number);
            map_description.setMapType(map_type);
            map_description.setMapName(map_name);
            map_description.setMapArea(map_area);
            map_description.setMapNumber(map_number);
            maps_in_unit.add(map_description);
            has_next = map_dir.getNextAsByte();
        }
        return maps_in_unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GarminFile getFile(String filename, long timeout) throws IOException, FileNotFoundException {
        Object object = this.flash_info_sync_request_lock_;
        synchronized (object) {
            this.result_flash_info_ = null;
            this.requestMapFlashInfo();
            try {
                this.flash_info_sync_request_lock_.wait(timeout);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        if (this.result_flash_info_ == null) {
            return null;
        }
        int map_area = this.result_flash_info_.getMapArea();
        GarminPacket request_packet = new GarminPacket(89, 6 + filename.length() + 1);
        request_packet.setNextAsLongWord(0L);
        request_packet.setNextAsWord(map_area);
        request_packet.setNextAsString(filename);
        if (logger_map_.isDebugEnabled()) {
            logger_map_.debug((Object)("Requesting file '" + filename + "' on map area " + map_area + " with packet: " + request_packet));
        }
        Object object2 = this.file_sync_request_lock_;
        synchronized (object2) {
            this.result_file_ = null;
            this.putPacketAsync(request_packet);
            try {
                this.file_sync_request_lock_.wait(timeout);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (this.result_file_ == null) {
                throw new FileNotFoundException("File '" + filename + "' was not found on gps device.");
            }
            return this.result_file_;
        }
    }

    private void setMaps() {
    }

    public void requestPowerOff() throws IOException {
        if (this.capabilities_.hasCapability("L1") && this.capabilities_.hasCapability("A10")) {
            this.sendCommandAsync(10, 8);
        }
        if (this.capabilities_.hasCapability("L2") && this.capabilities_.hasCapability("A11")) {
            this.sendCommandAsync(11, 26);
        }
    }

    public void requestVoltage() throws IOException {
        this.sendCommandAsync(10, 17);
    }

    public void requestSerialNumber() throws IOException {
        if (this.capabilities_.hasCapability("L1")) {
            this.sendCommandAsync(10, 14);
        } else {
            this.sendCommandAsync(11, 14);
        }
    }

    public void requestScreenShot() throws IOException {
        this.sendCommandAsync(10, 32);
    }

    protected void requestAsyncEvents() {
        GarminPacket garmin_packet = new GarminPacket(28, 2);
        garmin_packet.put(128);
        garmin_packet.put(0);
        this.putPacketAsync(garmin_packet);
    }

    protected void requestMapFlashInfo() throws IOException {
        if (this.capabilities_.hasCapability("L1") && this.capabilities_.hasCapability("A10")) {
            this.sendCommandAsync(10, 63);
        }
    }

    private void requestEraseFlash(int map_area) {
        GarminPacket garmin_packet = new GarminPacket(75, 2);
        garmin_packet.setNextAsWord(map_area);
        this.putPacketAsync(garmin_packet);
    }

    protected void requestStartPvtData() throws IOException {
        if (this.capabilities_.hasCapability("L1") && this.capabilities_.hasCapability("A10")) {
            this.sendCommandAsync(10, 49);
            this.send_pvt_periodically_ = true;
        }
    }

    protected void requestStopPvtData() throws IOException {
        if (this.capabilities_.hasCapability("L1") && this.capabilities_.hasCapability("A10")) {
            this.sendCommandAsync(10, 50);
            this.send_pvt_periodically_ = false;
        }
    }

    protected boolean requestRoutes() throws IOException {
        boolean success = false;
        for (int num_tries = 0; !success && num_tries < 5; ++num_tries) {
            if (!this.capabilities_.hasCapability("A200") && !this.capabilities_.hasCapability("A201")) continue;
            if (this.capabilities_.hasCapability("L1")) {
                if (this.capabilities_.hasCapability("A10")) {
                    success = this.sendCommand(10, 4, 2000L);
                    continue;
                }
                success = this.sendCommand(10, 8, 2000L);
                continue;
            }
            success = this.capabilities_.hasCapability("A10") ? this.sendCommand(11, 4, 2000L) : this.sendCommand(11, 8, 2000L);
        }
        return success;
    }

    protected boolean requestWaypoints() throws IOException {
        boolean success = false;
        for (int num_tries = 0; !success && num_tries < 5; ++num_tries) {
            if (!this.capabilities_.hasCapability("A100")) continue;
            if (this.capabilities_.hasCapability("L1")) {
                if (this.capabilities_.hasCapability("A10")) {
                    success = this.sendCommand(10, 7, 2000L);
                    continue;
                }
                success = this.sendCommand(10, 21, 2000L);
                continue;
            }
            success = this.capabilities_.hasCapability("A10") ? this.sendCommand(11, 7, 2000L) : this.sendCommand(11, 21, 2000L);
        }
        return success;
    }

    protected boolean requestTracks() throws IOException {
        boolean success = false;
        for (int num_tries = 0; !success && num_tries < 5; ++num_tries) {
            if (!this.capabilities_.hasCapability("A300") && !this.capabilities_.hasCapability("A301") && !this.capabilities_.hasCapability("A302") || !this.capabilities_.hasCapability("L1") || !this.capabilities_.hasCapability("A10")) continue;
            success = this.sendCommand(10, 6, 2000L);
        }
        return success;
    }

    protected boolean requestProductInfo() throws IOException {
        boolean success = false;
        for (int num_tries = 0; !success && num_tries < 5; ++num_tries) {
            success = this.sendCommand(254, 2000L);
        }
        return success;
    }

    protected boolean requestPVT() throws IOException {
        if (this.capabilities_.hasCapability("A800") && this.capabilities_.hasCapability("L1") && this.capabilities_.hasCapability("A10")) {
            boolean success = false;
            for (int num_tries = 0; !success && num_tries < 5; ++num_tries) {
                success = this.sendCommand(10, 49, 2000L);
            }
            return success;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRoutesReceived(Vector routes) {
        Object object = this.route_sync_request_lock_;
        synchronized (object) {
            this.result_routes_ = routes;
            this.route_sync_request_lock_.notify();
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Routes received: " + routes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTracksReceived(Vector tracks) {
        Object object = this.track_sync_request_lock_;
        synchronized (object) {
            this.result_tracks_ = tracks;
            this.track_sync_request_lock_.notify();
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Tracks received: " + tracks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWaypointsReceived(List waypoints) {
        Object object = this.waypoint_sync_request_lock_;
        synchronized (object) {
            this.result_waypoints_ = waypoints;
            this.waypoint_sync_request_lock_.notify();
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Waypoints received: " + waypoints));
        }
    }

    protected void fireTransferCompleteReceived() {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"TransferComplete received");
        }
    }

    protected void fireProductDataReceived(GarminProduct product) {
        this.product_info_ = product;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("product data received: " + product));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProtocolArrayReceived(GarminCapabilities capabilities) {
        Object object = this.product_info_lock_;
        synchronized (object) {
            this.capabilities_ = capabilities;
            this.product_info_lock_.notify();
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("product capabilities received: " + this.capabilities_));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePVTDataReceived(GarminPVT pvt) {
        Object object = this.pvt_sync_request_lock_;
        synchronized (object) {
            if (pvt != null && pvt.getFix() > 1) {
                this.changeGPSData("location", new GPSPosition(pvt.getLat(), pvt.getLon()));
                this.changeGPSData("speed", new Float(GPSGarminDataProcessor.calcSpeed(pvt.getNorth(), pvt.getEast())));
                double altitude = pvt.getAlt() + pvt.getMslHeight();
                this.changeGPSData("altitude", new Float(altitude));
                this.changeGPSData("heading", new Float(GPSGarminDataProcessor.calcHeading(pvt.getNorth(), pvt.getEast())));
                GPSPositionError pos_error = new GPSPositionError(pvt.getEpe(), pvt.getEph(), pvt.getEpv());
                this.changeGPSData("epe", pos_error);
            }
            this.pvt_sync_request_lock_.notify();
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("pvt received: " + pvt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDisplayDataReceived(GarminDisplayData display_data) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("display data received: " + display_data));
        }
        Object object = this.screenshot_sync_request_lock_;
        synchronized (object) {
            this.result_screenshot_ = display_data.getImage();
            this.screenshot_sync_request_lock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSerialNumberReceived(long serial_number) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("serial number received: " + serial_number));
        }
        Object object = this.serial_number_sync_request_lock_;
        synchronized (object) {
            this.result_serial_number_ = serial_number;
            this.serial_number_sync_request_lock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFlashInfoReceived(GarminFlashInfo flash_info) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("flash info received: " + flash_info));
        }
        Object object = this.flash_info_sync_request_lock_;
        synchronized (object) {
            this.result_flash_info_ = flash_info;
            this.flash_info_sync_request_lock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFileNotFoundReceived(GarminPacket file_not_found) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("file not found received: " + file_not_found));
        }
        Object object = this.file_sync_request_lock_;
        synchronized (object) {
            this.result_file_ = null;
            this.file_sync_request_lock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFileReceived(GarminFile garmin_file) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("file received (maybe shortened): " + garmin_file));
        }
        Object object = this.file_sync_request_lock_;
        synchronized (object) {
            this.result_file_ = garmin_file;
            this.file_sync_request_lock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResult(boolean result, int packet_id) {
        Object object = this.acknowledge_lock_;
        synchronized (object) {
            this.send_success_ = result;
            this.send_packet_id_ = packet_id;
            this.acknowledge_lock_.notify();
        }
        if (this.result_listeners_ != null) {
            Iterator listeners = this.result_listeners_.iterator();
            while (listeners.hasNext()) {
                ResultReceivedListener listener = (ResultReceivedListener)listeners.next();
                listener.receivedResult(result, packet_id);
            }
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Result received: " + result + " for packet id " + packet_id));
        }
    }

    private void displayDataReceived(GarminPacket garmin_packet) {
        try {
            int corrupt_images_retries = 1;
            int num_corrupt_packets = 0;
            GarminDisplayData display_data = new GarminDisplayData(garmin_packet);
            int height = display_data.getHeight();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Reading Display Data with " + height + " lines."));
            }
            do {
                GarminPacket ignore;
                num_corrupt_packets = 0;
                this.fireProgressActionStart("getscreenshot", 1, height);
                for (int linenum = 0; linenum < height - num_corrupt_packets; ++linenum) {
                    GarminPacket next_garmin_packet;
                    do {
                        if ((next_garmin_packet = this.getPacket()) != null) continue;
                        ++num_corrupt_packets;
                    } while (next_garmin_packet == null);
                    if (next_garmin_packet.getPacketId() != 69) {
                        System.err.println("WARNING: Expected Display Data, received: " + next_garmin_packet);
                        continue;
                    }
                    if (linenum % 10 == 0) {
                        this.fireProgressActionProgress("getscreenshot", linenum);
                    }
                    display_data.addData(next_garmin_packet);
                }
                if (num_corrupt_packets <= 0 || corrupt_images_retries <= 0) continue;
                System.err.println("WARNING: " + num_corrupt_packets + " corrupt packets detected, retry reading display data");
                this.requestScreenShot();
                while ((ignore = this.getPacket()) != null && ignore.getPacketId() != 69) {
                }
            } while (num_corrupt_packets > 0 && corrupt_images_retries-- > 0);
            this.fireProgressActionProgress("getscreenshot", height);
            this.fireProgressActionEnd("getscreenshot");
            this.fireDisplayDataReceived(display_data);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void firePacketReceived(GarminPacket garmin_packet) {
        int packet_id = garmin_packet.getPacketId();
        int packets_type_received = 0;
        switch (packet_id) {
            case 21: {
                this.fireResult(false, packet_id);
                break;
            }
            case 6: {
                this.fireResult(true, packet_id);
                break;
            }
            case 255: {
                this.fireProductDataReceived(new GarminProduct(garmin_packet));
                break;
            }
            case 253: {
                this.fireProtocolArrayReceived(new GarminCapabilities(garmin_packet));
                break;
            }
            case 51: {
                if (this.capabilities_ == null) {
                    return;
                }
                if (this.capabilities_.hasCapability("D800")) {
                    this.firePVTDataReceived(new GarminPVTD800(garmin_packet));
                }
                if (!this.capabilities_.hasCapability("D802")) break;
                this.firePVTDataReceived(new GarminPVTD802(garmin_packet));
                break;
            }
            case 69: {
                if (this.capabilities_ == null) {
                    return;
                }
                this.displayDataReceived(garmin_packet);
                break;
            }
            case 27: 
            case 35: {
                if (this.capabilities_ == null) {
                    return;
                }
                int packet_num = garmin_packet.getWord(0);
                int packet_count = 0;
                if (logger_packet_.isDebugEnabled()) {
                    logger_packet_.debug((Object)("Receiving " + packet_num + " packets from device."));
                }
                Vector<Object> items = new Vector<Object>();
                GarminRoute item = null;
                boolean transfer_complete = false;
                block32: while (!transfer_complete) {
                    GarminPacket next_garmin_packet;
                    while ((next_garmin_packet = this.getPacket()) == null) {
                    }
                    ++packet_count;
                    if (logger_packet_.isDebugEnabled()) {
                        logger_packet_.debug((Object)("read packet " + packet_count + " of " + packet_num));
                    }
                    if (logger_packet_detail_.isDebugEnabled()) {
                        logger_packet_detail_.debug((Object)("packet details: " + next_garmin_packet.toString()));
                    }
                    packet_id = next_garmin_packet.getPacketId();
                    switch (packet_id) {
                        case 29: 
                        case 37: {
                            if (packets_type_received == 0) {
                                this.fireProgressActionStart("getroutes", 1, packet_num);
                            }
                            packets_type_received = 4;
                            if (item != null) {
                                items.add(item);
                            }
                            if (this.capabilities_.hasCapability("D200")) {
                                item = new GarminRouteD200(next_garmin_packet);
                            }
                            if (this.capabilities_.hasCapability("D201")) {
                                item = new GarminRouteD201(next_garmin_packet);
                            }
                            if (!this.capabilities_.hasCapability("D202")) continue block32;
                            item = new GarminRouteD202(next_garmin_packet);
                            continue block32;
                        }
                        case 30: 
                        case 39: {
                            if (packet_id == 39 && this.capabilities_.hasCapability("L1")) {
                                System.out.println("Unknown packet1: " + next_garmin_packet);
                                continue block32;
                            }
                            if (packet_count % 10 == 0) {
                                this.fireProgressActionProgress("getroutes", packet_count);
                            }
                            if (this.capabilities_.hasCapability("D100")) {
                                ((GarminRoute)item).addWaypoint(new GarminWaypointD100(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D101")) {
                                ((GarminRoute)item).addWaypoint(new GarminWaypointD101(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D102")) {
                                ((GarminRoute)item).addWaypoint(new GarminWaypointD102(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D103")) {
                                ((GarminRoute)item).addWaypoint(new GarminWaypointD103(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D107")) {
                                ((GarminRoute)item).addWaypoint(new GarminWaypointD107(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D108")) {
                                item.addWaypoint(new GarminWaypointD108(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D109")) {
                                item.addWaypoint(new GarminWaypointD109(next_garmin_packet));
                            } else {
                                System.err.println("WARNING: unsupported garmin waypoint type!");
                            }
                            if (!logger_.isDebugEnabled()) continue block32;
                            logger_.debug((Object)"Received Waypoint");
                            continue block32;
                        }
                        case 98: {
                            if (this.capabilities_ == null) {
                                return;
                            }
                            if (packet_count % 10 != 0) continue block32;
                            this.fireProgressActionProgress("getroutes", packet_count);
                            continue block32;
                        }
                        case 99: {
                            if (packets_type_received == 0) {
                                this.fireProgressActionStart("gettracks", 1, packet_num);
                            }
                            packets_type_received = 2;
                            if (item != null) {
                                items.add(item);
                            }
                            if (this.capabilities_.hasCapability("D310")) {
                                item = new GarminTrackD310(next_garmin_packet);
                            }
                            if (this.capabilities_.hasCapability("D311")) {
                                item = new GarminTrackD311(next_garmin_packet);
                            }
                            if (!logger_.isDebugEnabled()) continue block32;
                            logger_.debug((Object)("Received Track Header: " + item));
                            continue block32;
                        }
                        case 34: {
                            GarminTrackpointD304 gtp;
                            if (logger_.isDebugEnabled()) {
                                logger_.debug((Object)"Received Track Data");
                            }
                            if (packet_count % 10 == 0) {
                                this.fireProgressActionProgress("gettracks", packet_count);
                            }
                            if (item == null) {
                                item = new GarminTrack();
                                item.setIdentification(this.track_date_format.format(new Date()));
                                this.fireProgressActionStart("gettracks", 1, packet_num);
                                packets_type_received = 2;
                            }
                            if (this.capabilities_.hasCapability("D300")) {
                                ((GarminTrack)item).addWaypoint(new GarminTrackpointD300(next_garmin_packet));
                            }
                            if (this.capabilities_.hasCapability("D301")) {
                                ((GarminTrack)item).addWaypoint(new GarminTrackpointD301(next_garmin_packet));
                            }
                            if (!this.capabilities_.hasCapability("D304") || !(gtp = new GarminTrackpointD304(next_garmin_packet)).has_valid_position()) continue block32;
                            ((GarminTrack)item).addWaypoint(gtp);
                            continue block32;
                        }
                        case 35: 
                        case 43: {
                            if (this.capabilities_ == null) {
                                return;
                            }
                            if (packets_type_received == 0) {
                                this.fireProgressActionStart("getwaypoints", 1, packet_num);
                            }
                            packets_type_received = 1;
                            if (items == null) {
                                items = new Vector();
                            }
                            if (packet_count % 10 == 0) {
                                this.fireProgressActionProgress("getwaypoints", packet_count);
                            }
                            if (this.capabilities_.hasCapability("D100")) {
                                items.add(new GarminWaypointD100(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D101")) {
                                items.add(new GarminWaypointD101(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D102")) {
                                items.add(new GarminWaypointD102(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D103")) {
                                items.add(new GarminWaypointD103(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D107")) {
                                items.add(new GarminWaypointD107(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D108")) {
                                items.add(new GarminWaypointD108(next_garmin_packet));
                            } else if (this.capabilities_.hasCapability("D109")) {
                                items.add(new GarminWaypointD109(next_garmin_packet));
                            } else {
                                System.err.println("WARNING: unsupported garmin waypoint type!");
                            }
                            if (!logger_.isDebugEnabled()) continue block32;
                            logger_.debug((Object)"Received Waypoint");
                            continue block32;
                        }
                        case 12: {
                            if (logger_.isDebugEnabled()) {
                                logger_.debug((Object)"transfer complete");
                            }
                            transfer_complete = true;
                            continue block32;
                        }
                    }
                    logger_.warn((Object)("WARNING GPSGarminDataProcessor: unknown packet id: " + packet_id));
                    if (!logger_.isDebugEnabled()) continue;
                    logger_.debug((Object)("unknown packet: " + next_garmin_packet));
                }
                if (item != null) {
                    items.add(item);
                }
                switch (packets_type_received) {
                    case 4: {
                        this.fireProgressActionProgress("getroutes", packet_num);
                        this.fireProgressActionEnd("getroutes");
                        this.fireRoutesReceived(items);
                        break;
                    }
                    case 2: {
                        this.fireProgressActionProgress("gettracks", packet_num);
                        this.fireProgressActionEnd("gettracks");
                        this.fireTracksReceived(items);
                        break;
                    }
                    case 1: {
                        this.fireProgressActionProgress("getwaypoints", packet_num);
                        this.fireProgressActionEnd("getwaypoints");
                        this.fireWaypointsReceived(items);
                        break;
                    }
                    default: {
                        if (items.size() != 0) break;
                        this.fireProgressActionProgress("getwaypoints", packet_num);
                        this.fireProgressActionEnd("getwaypoints");
                        this.fireProgressActionProgress("getroutes", packet_num);
                        this.fireProgressActionEnd("getroutes");
                        this.fireProgressActionProgress("gettracks", packet_num);
                        this.fireProgressActionEnd("gettracks");
                        this.fireWaypointsReceived(items);
                        this.fireRoutesReceived(items);
                        this.fireTracksReceived(items);
                    }
                }
                packets_type_received = 0;
                break;
            }
            case 12: {
                this.fireTransferCompleteReceived();
                break;
            }
            case 90: {
                System.out.println("WARNING: unexpected File_Data: " + garmin_packet);
                break;
            }
            case 91: {
                GarminFile garmin_file = new GarminFile(garmin_packet);
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Pid_File_Header: " + garmin_file));
                }
                int packet_count = 0;
                while (packet_count < garmin_file.getDataPacketCount()) {
                    GarminPacket next_garmin_packet;
                    while ((next_garmin_packet = this.getPacket()) == null) {
                    }
                    ++packet_count;
                    if (next_garmin_packet.getPacketId() != 90) {
                        logger_.warn((Object)("WARNING GPSGarminDataProcessor: unknown packet id: " + packet_id + " while waiting for File Data!"));
                        if (logger_.isDebugEnabled()) {
                            logger_.debug((Object)("unknown packet: " + garmin_packet));
                        }
                    }
                    garmin_file.addDataPacket(next_garmin_packet);
                }
                this.fireFileReceived(garmin_file);
                break;
            }
            case 92: {
                System.out.println("Pid_File_Not_Exist: " + garmin_packet);
                this.fireFileNotFoundReceived(garmin_packet);
                break;
            }
            case 95: {
                System.out.println("Pid_File_Flash_Info: " + garmin_packet);
                GarminFlashInfo flash_info = new GarminFlashInfo(garmin_packet);
                this.fireFlashInfoReceived(flash_info);
                break;
            }
            case 74: {
                System.out.println("Pid_Flash_Erase_Response: " + garmin_packet);
                break;
            }
            case 109: {
                System.out.println("Pid_Unlock_Code_Response: " + garmin_packet);
                if (garmin_packet.getPacketSize() != 2) {
                    System.err.println("Wrong response for unlock code");
                    return;
                }
                short success = garmin_packet.getNextAsByte();
                if (success == 0) {
                    System.err.println("Illegal unlock code");
                    return;
                }
                if (success != 1) break;
                break;
            }
            case 40: {
                System.out.println("Voltage packet received - not handled yet!");
                break;
            }
            case 38: {
                this.fireSerialNumberReceived(garmin_packet.getNextAsLongWord());
                break;
            }
            default: {
                logger_.warn((Object)("WARNING GPSGarminDataProcessor: unknown packet id: " + packet_id));
                if (!logger_.isDebugEnabled()) break;
                logger_.debug((Object)("unknown packet: " + garmin_packet));
            }
        }
    }

    public GPSPosition getGPSPosition() {
        try {
            GarminPVT pvtdata = this.getPVT(0L);
            if (pvtdata != null) {
                return new GPSPosition(pvtdata.getLat(), pvtdata.getLon());
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public float getHeading() {
        return -1.0f;
    }

    public void addResultReceivedListener(ResultReceivedListener listener) {
        if (this.result_listeners_ == null) {
            this.result_listeners_ = new Vector();
        }
        this.result_listeners_.add(listener);
    }

    public void removeResultReceivedListener(ResultReceivedListener listener) {
        if (this.result_listeners_ == null) {
            return;
        }
        this.result_listeners_.remove(listener);
    }

    class WatchDogThread
    extends Thread {
        boolean paused_;
        boolean reset_;
        int packet_id_;

        public WatchDogThread() {
            super("GarminWatchDog");
            this.paused_ = false;
            this.reset_ = false;
            this.packet_id_ = 0;
        }

        public void startWatching() {
            try {
                this.start();
            }
            catch (IllegalThreadStateException ignore) {
                ignore.printStackTrace();
            }
        }

        public void pauseWatching(boolean pause) {
            this.paused_ = pause;
        }

        public void setPacketId(int packet_id) {
            this.packet_id_ = packet_id;
        }

        public void reset() {
            this.reset_ = true;
        }

        public void run() {
            if (logger_threads_.isDebugEnabled()) {
                logger_threads_.debug((Object)"WATCHDOG started");
            }
            while (!this.isInterrupted()) {
                this.reset_ = false;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    if (logger_threads_.isDebugEnabled()) {
                        logger_threads_.debug((Object)"WATCHDOG was interrupted");
                    }
                    this.interrupt();
                    return;
                }
                if (this.paused_ || this.reset_) continue;
                if (logger_threads_.isDebugEnabled()) {
                    logger_threads_.debug((Object)"WATCHDOG sending NAK");
                }
                try {
                    GPSGarminDataProcessor.this.sendCommandAsync(21, this.packet_id_);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (logger_threads_.isDebugEnabled()) {
                logger_threads_.debug((Object)"WATCHDOG ended");
            }
        }

        public void stopWatching() {
            this.interrupt();
        }
    }

    class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("Garmin Reader");
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    GarminPacket garmin_packet;
                    if (logger_packet_.isDebugEnabled()) {
                        logger_packet_.debug((Object)"waiting for packet...");
                    }
                    if ((garmin_packet = GPSGarminDataProcessor.this.getPacket()) == null) {
                        if (!logger_packet_.isDebugEnabled()) continue;
                        logger_packet_.debug((Object)"invalid packet received");
                        continue;
                    }
                    if (logger_packet_.isDebugEnabled()) {
                        logger_packet_.debug((Object)("packet received: " + garmin_packet.getPacketId()));
                    }
                    if (logger_packet_detail_.isDebugEnabled()) {
                        logger_packet_detail_.debug((Object)("packet details: " + garmin_packet.toString()));
                    }
                    GPSGarminDataProcessor.this.firePacketReceived(garmin_packet);
                }
                catch (NullPointerException npe) {
                    if (this.isInterrupted()) continue;
                    throw npe;
                }
            }
        }

        public void stopThread() {
            this.interrupt();
        }
    }
}

