/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

public class GPSPosition {
    double longitude_;
    double latitude_;
    double altitude_;
    String name_;

    public GPSPosition() {
    }

    public GPSPosition(double latitude_wgs84, String north_south, double longitude_wgs84, String east_west) throws IllegalArgumentException {
        this(latitude_wgs84, north_south, longitude_wgs84, east_west, Double.NaN, "");
    }

    public GPSPosition(double latitude_wgs84, String north_south, double longitude_wgs84, String east_west, double altitude) throws IllegalArgumentException {
        this(latitude_wgs84, north_south, longitude_wgs84, east_west, altitude, "");
    }

    public GPSPosition(double latitude_wgs84, String north_south, double longitude_wgs84, String east_west, String name) throws IllegalArgumentException {
        this(latitude_wgs84, north_south, longitude_wgs84, east_west, Double.NaN, name);
    }

    public GPSPosition(double latitude_wgs84, String north_south, double longitude_wgs84, String east_west, double altitude, String name) throws IllegalArgumentException {
        north_south = north_south.toUpperCase();
        east_west = east_west.toUpperCase();
        if (!(north_south.equals("N") || north_south.equals("S") || east_west.equals("E") || east_west.equals("W"))) {
            throw new IllegalArgumentException("invalid gps position: " + latitude_wgs84 + north_south + " " + longitude_wgs84 + east_west);
        }
        if (north_south.equals("N")) {
            this.setLatitude(latitude_wgs84);
        } else {
            this.setLatitude(-latitude_wgs84);
        }
        if (east_west.equals("E")) {
            this.setLongitude(longitude_wgs84);
        } else {
            this.setLongitude(-longitude_wgs84);
        }
        this.altitude_ = altitude;
        this.name_ = name;
    }

    public GPSPosition(double latitude, double longitude) {
        this(latitude, longitude, Double.NaN, "");
    }

    public GPSPosition(double latitude, double longitude, double altitude) {
        this(latitude, longitude, altitude, "");
    }

    public GPSPosition(double latitude, double longitude, double altitude, String name) {
        this.altitude_ = altitude;
        this.name_ = name;
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public GPSPosition(GPSPosition gpsposition) {
        this.setLatitude(gpsposition.latitude_);
        this.setLongitude(gpsposition.longitude_);
        this.altitude_ = gpsposition.altitude_;
        this.name_ = gpsposition.name_;
    }

    public double getLongitude() {
        return this.longitude_;
    }

    public void setLongitude(double longitude) {
        this.longitude_ = longitude;
    }

    public double getLatitude() {
        return this.latitude_;
    }

    public void setLatitude(double latitude) {
        this.latitude_ = latitude;
    }

    public double getAltitude() {
        return this.altitude_;
    }

    public void setAltitude(double altitude) {
        this.altitude_ = altitude;
    }

    public String toString() {
        StringBuffer tostring = new StringBuffer("GPSPosition[");
        if (this.name_.length() > 0) {
            tostring.append("name=").append(this.name_).append(", ");
        }
        tostring.append("lat: " + this.latitude_ + ", long:" + this.longitude_);
        tostring.append("]");
        return tostring.toString();
    }

    public boolean equals(Object pos) {
        if (!(pos instanceof GPSPosition)) {
            return false;
        }
        return this.latitude_ == ((GPSPosition)pos).latitude_ && this.longitude_ == ((GPSPosition)pos).longitude_;
    }
}

