/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui.property_editor;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class DoubleField
extends JTextField {
    private NumberFormat double_formatter_ = NumberFormat.getNumberInstance();

    public DoubleField() {
        this.double_formatter_.setParseIntegerOnly(false);
    }

    public double getValue() {
        double ret_val = 0.0;
        try {
            ret_val = this.double_formatter_.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret_val;
    }

    public void setValue(double value) {
        this.setText(this.double_formatter_.format(value));
    }

    protected Document createDefaultModel() {
        return new DoubleDocument();
    }

    protected class DoubleDocument
    extends PlainDocument {
        protected DoubleDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String curVal = this.getText(0, this.getLength());
            boolean hasDot = curVal.indexOf(".") != -1;
            char[] buffer = str.toCharArray();
            char[] digit = new char[buffer.length];
            int j = 0;
            if (offs == 0 && buffer != null && buffer.length > 0 && buffer[0] == '-') {
                digit[j++] = buffer[0];
            }
            for (int i = 0; i < buffer.length; ++i) {
                if (Character.isDigit(buffer[i])) {
                    digit[j++] = buffer[i];
                }
                if (hasDot || buffer[i] != '.') continue;
                digit[j++] = 46;
                hasDot = true;
            }
            String added = new String(digit, 0, j);
            try {
                StringBuffer val = new StringBuffer(curVal);
                val.insert(offs, added);
                if (val.toString().equals(".") || val.toString().equals("-") || val.toString().equals("-.")) {
                    super.insertString(offs, added, a);
                } else {
                    Double.valueOf(val.toString());
                    super.insertString(offs, added, a);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

