/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui.property_editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import org.dinopolis.util.gui.ResourceEditorPanel;

public class ColorEditor
extends PropertyEditorSupport
implements ActionListener {
    private JPanel editing_component_;
    private JButton selected_color_button_;
    private Color selected_color_;
    public static final Color[] COLORS = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
    public static final String[] COLOR_NAMES = new String[]{"white", "lightGray", "gray", "darkGray", "black", "red", "pink", "orange", "yellow", "green", "magenta", "cyan", "blue"};
    public static final String DEFAULT_KEY = "resource_editor.button.default";

    public String getAsText() {
        if (this.selected_color_ == null) {
            return null;
        }
        return this.selected_color_.getRed() + "," + this.selected_color_.getGreen() + "," + this.selected_color_.getBlue();
    }

    public void setAsText(String value) throws IllegalArgumentException {
        StringTokenizer tok = new StringTokenizer(value, ",");
        int tokens = tok.countTokens();
        if (tokens == 1) {
            this.selected_color_ = ColorEditor.getColorFromName(value);
            if (this.selected_color_button_ == null || this.selected_color_ == null) {
                throw new IllegalArgumentException("'" + value + "' is not a " + "valid color!");
            }
            this.selected_color_button_.setForeground(this.selected_color_);
            return;
        }
        if (tokens >= 3) {
            try {
                int a = 255;
                int r = Integer.parseInt(tok.nextToken());
                int g = Integer.parseInt(tok.nextToken());
                int b = Integer.parseInt(tok.nextToken());
                if (tokens > 3) {
                    a = Integer.parseInt(tok.nextToken());
                }
                this.selected_color_ = new Color(r, g, b, a);
                if (this.selected_color_button_ != null) {
                    this.selected_color_button_.setForeground(this.selected_color_);
                }
                return;
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        throw new NumberFormatException("'" + value + "' is not a " + "valid color!");
    }

    public Component getCustomEditor() {
        if (this.editing_component_ == null) {
            this.createEditingComponent();
        }
        return this.editing_component_;
    }

    protected void createEditingComponent() {
        this.editing_component_ = new JPanel();
        this.editing_component_.setLayout(new BorderLayout());
        this.selected_color_button_ = new JButton(ResourceEditorPanel.getResources().getString("color_editor.color_button_text"));
        if (this.selected_color_ != null) {
            this.selected_color_button_.setForeground(this.selected_color_);
        }
        JButton reset = new JButton(ResourceEditorPanel.getResources().getString(DEFAULT_KEY));
        reset.setActionCommand("reset");
        reset.addActionListener(this);
        this.editing_component_.add((Component)reset, "East");
        this.selected_color_button_.addActionListener(this);
        this.selected_color_button_.setOpaque(false);
        this.editing_component_.add((Component)this.selected_color_button_, "Center");
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.selected_color_ = (Color)value;
        if (this.selected_color_button_ != null) {
            if (this.selected_color_ == null) {
                this.selected_color_ = (Color)this.getValue();
            }
            this.selected_color_button_.setForeground(this.selected_color_);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if ("reset".equals(event.getActionCommand())) {
            this.setValue(null);
            return;
        }
        Color new_color = JColorChooser.showDialog(this.editing_component_, "Choose a Color", this.selected_color_);
        if (new_color != null && !new_color.equals(this.selected_color_)) {
            this.setValue(new_color);
        }
    }

    public static Color getColorFromName(String name) throws IllegalArgumentException {
        if (name == null || name.length() <= 0) {
            return null;
        }
        for (int count = 0; count < COLOR_NAMES.length; ++count) {
            if (!COLOR_NAMES[count].equalsIgnoreCase(name)) continue;
            return COLORS[count];
        }
        throw new IllegalArgumentException("'" + name + "' is not a valid " + "Color!");
    }
}

