/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SplashScreen
extends JWindow {
    JProgressBar progress_bar_;
    JLabel status_line_;

    public SplashScreen(Icon banner, int display_millis) {
        this(new JLabel(banner), display_millis);
    }

    public SplashScreen(Icon banner, int display_millis, int progress_min_value, int progress_max_value) {
        this(new JLabel(banner), display_millis, progress_min_value, progress_max_value);
    }

    public SplashScreen(String text, int display_millis) {
        this(new JLabel(text), display_millis);
    }

    public SplashScreen(String text, int display_millis, int progress_min_value, int progress_max_value) {
        this(new JLabel(text), display_millis, progress_min_value, progress_max_value);
    }

    public SplashScreen(JLabel label, int display_millis) {
        this(label, display_millis, 0, 0);
    }

    public SplashScreen(JLabel label, int display_millis, int progress_min_value, int progress_max_value) {
        this.getContentPane().add((Component)label, "Center");
        if (progress_min_value != 0 || progress_max_value != 0) {
            JPanel status_panel = new JPanel(new BorderLayout());
            this.progress_bar_ = new JProgressBar(progress_min_value, progress_max_value);
            status_panel.add((Component)this.progress_bar_, "Center");
            this.status_line_ = new JLabel();
            status_panel.add((Component)this.status_line_, "South");
            this.getContentPane().add((Component)status_panel, "South");
        }
        this.pack();
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension label_size = this.getContentPane().getPreferredSize();
        this.setLocation(screen_size.width / 2 - label_size.width / 2, screen_size.height / 2 - label_size.height / 2);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                SplashScreen.this.close();
            }
        });
        final Runnable closer = new Runnable(){

            public void run() {
                SplashScreen.this.close();
            }
        };
        final int display_millis_ = display_millis;
        this.setVisible(true);
        if (display_millis_ >= 0) {
            Runnable waiter = new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(display_millis_);
                        SwingUtilities.invokeAndWait(closer);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread splash = new Thread(waiter, "SplashThread");
            splash.setDaemon(true);
            splash.start();
        }
    }

    public void setStatus(String text, int progress_value) {
        this.setStatus(text);
        this.setProgress(progress_value);
    }

    public void setStatus(String text) {
        if (this.status_line_ != null) {
            this.status_line_.setText(text);
        }
    }

    public void setProgress(int progress_value) {
        if (this.progress_bar_ != null) {
            this.progress_bar_.setValue(progress_value);
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] arguments) {
        SplashScreen splash = new SplashScreen(new ImageIcon("/filer/cdaller/texte/pic/cdaller.jpg"), 5000, 0, 100);
        splash.setStatus("loading plugins...", 10);
        try {
            Thread.sleep(500L);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        splash.setStatus("initialize plugins...", 20);
        try {
            Thread.sleep(500L);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        splash.setStatus("start plugin 1...", 30);
        try {
            Thread.sleep(500L);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        splash.setStatus("start another plugin ...", 50);
        try {
            Thread.sleep(500L);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        splash.setStatus("finish first plugin...", 70);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        splash.setStatus("open window...", 100);
    }
}

