/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.dinopolis.util.ResourceManager;
import org.dinopolis.util.Resources;
import org.dinopolis.util.gui.property_editor.ArrayEditor;
import org.dinopolis.util.gui.property_editor.BooleanEditor;
import org.dinopolis.util.gui.property_editor.DoubleEditor;
import org.dinopolis.util.gui.property_editor.IntEditor;
import org.dinopolis.util.gui.property_editor.StringChooser;
import org.dinopolis.util.gui.property_editor.StringSelector;
import org.dinopolis.util.resource.ResourceGroup;

public class ResourceEditorPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final String RESOURCE_BOUNDLE_NAME = "ResourceEditor";
    public static final String RESOURCE_DIR_NAME = "resources";
    private static Resources edit_resources_;
    private static Resources my_resources_;
    public static final String KEY_APPLY_BUTTON = "resource_editor.button.apply";
    public static final String KEY_INFO_BUTTON_ICON_POSITION = "resource_editor.info_icon_position";
    public static final String KEY_INFO_BUTTON_ICON = "resource_editor.info_icon";
    public static final String APPLY_COMMAND = "apply";
    public static final String KEY_BUTTONS_INSETS = "buttons.insets";
    public static final String KEY_TAB_DEFAULT = "resource_editor.tab.default";
    public static final String KEY_PROPERTY_EDITOR_SEARCH_PATH = "resource_editor.editor_search_path";
    public static final String KEY_HIDE_RESOURCES = "resources.hidden";
    private JTabbedPane editor_panel_;
    private Insets button_insets_;
    private JButton apply_button_;
    private String position_info_button_;
    private Icon info_icon_;
    private HashMap key_editor_map_;
    private HashSet hide_key_set_;
    private PropertyEditorManager property_editor_manager_;
    private String[] property_editor_manager_default_search_path_;
    private Vector type_save_;
    private Thread update_thread_;

    public ResourceEditorPanel(Resources resources) {
        this(resources, RESOURCE_DIR_NAME);
    }

    public ResourceEditorPanel(Resources resources, String resource_dir) throws MissingResourceException {
        this(resources, resource_dir, true);
    }

    public ResourceEditorPanel(Resources resources, String resource_dir, boolean show_apply_button) throws MissingResourceException {
        my_resources_ = ResourceManager.getResources(this.getClass(), RESOURCE_BOUNDLE_NAME, resource_dir, Locale.getDefault());
        my_resources_.addPropertyChangeListener(this);
        edit_resources_ = resources;
        edit_resources_.attachResources(my_resources_);
        this.type_save_ = new Vector();
        this.property_editor_manager_ = new PropertyEditorManager();
        PropertyEditorManager.registerEditor(Integer.TYPE, IntEditor.class);
        PropertyEditorManager.registerEditor(Double.TYPE, DoubleEditor.class);
        PropertyEditorManager.registerEditor(Boolean.TYPE, BooleanEditor.class);
        this.property_editor_manager_default_search_path_ = PropertyEditorManager.getEditorSearchPath();
        this.hide_key_set_ = new HashSet();
        this.key_editor_map_ = new HashMap();
        this.updateResources();
        this.setLayout(new BorderLayout());
        this.editor_panel_ = new JTabbedPane();
        this.add((Component)this.editor_panel_, "Center");
        Component buttons = this.createButtons();
        if (show_apply_button) {
            this.add(buttons, "South");
        }
    }

    public static Resources getResources() {
        return my_resources_;
    }

    public void updateResources() {
        String[] seach_path = my_resources_.getStringArray(KEY_PROPERTY_EDITOR_SEARCH_PATH, (String[])null);
        if (seach_path != null) {
            String[] addeed_path = new String[this.property_editor_manager_default_search_path_.length + seach_path.length];
            System.arraycopy(seach_path, 0, addeed_path, 0, seach_path.length);
            System.arraycopy(this.property_editor_manager_default_search_path_, 0, addeed_path, this.property_editor_manager_default_search_path_.length, this.property_editor_manager_default_search_path_.length);
            PropertyEditorManager.setEditorSearchPath(addeed_path);
        }
        if (this.apply_button_ != null) {
            int insets = my_resources_.getInt(KEY_BUTTONS_INSETS);
            this.button_insets_ = new Insets(insets, insets, insets, insets);
            this.apply_button_.setText(my_resources_.getString(KEY_APPLY_BUTTON));
            this.apply_button_.setMargin(this.button_insets_);
        }
        this.position_info_button_ = my_resources_.getString(KEY_INFO_BUTTON_ICON_POSITION).equals("left") ? "West" : "East";
        this.info_icon_ = my_resources_.getIcon(KEY_INFO_BUTTON_ICON);
        this.hide_key_set_.clear();
        String[] to_hide = edit_resources_.getStringArray(KEY_HIDE_RESOURCES, new String[0]);
        for (int count = 0; count < to_hide.length; ++count) {
            this.hide_key_set_.add(to_hide[count]);
        }
    }

    public void registerEditor(Class type, Class editor) {
        PropertyEditorManager.registerEditor(type, editor);
    }

    protected PropertyEditor getEditor(String key) {
        PropertyEditor editor = (PropertyEditor)this.key_editor_map_.get(key);
        if (editor != null) {
            return editor;
        }
        editor = this.createTypeSaveEditor(key);
        if (editor == null) {
            editor = this.createStringEditor(key);
        } else {
            this.type_save_.add(key);
        }
        if (editor != null) {
            this.key_editor_map_.put(key, editor);
            editor.addPropertyChangeListener(this);
        }
        return editor;
    }

    protected PropertyEditor createTypeSaveEditor(String key) {
        Class<?> type = edit_resources_.getType(key);
        if (type == null) {
            return null;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            return editor;
        }
        if (type.isArray() && (editor = PropertyEditorManager.findEditor(type = type.getComponentType())) != null) {
            return new ArrayEditor(type, editor);
        }
        return null;
    }

    protected PropertyEditor createStringEditor(String key) {
        return PropertyEditorManager.findEditor(String.class);
    }

    protected Component getEditingOrViewComponent(String key, PropertyEditor editor) {
        if (editor == null) {
            return null;
        }
        String[] possible_values = edit_resources_.getPossibleValues(key);
        if (possible_values != null) {
            Class type = edit_resources_.getType(key);
            String[] values = edit_resources_.getPossibleValues(key);
            String[] titles = new String[values.length];
            for (int count = 0; count < titles.length; ++count) {
                titles[count] = edit_resources_.getTitle(key + "." + values[count]);
            }
            if (type != null && type.isArray()) {
                return new StringSelector(editor, values, titles);
            }
            return new StringChooser(editor, values, titles);
        }
        if (editor.getTags() != null) {
            Class type = edit_resources_.getType(key);
            if (type != null && type.isArray()) {
                return new StringSelector(editor);
            }
            return new StringChooser(editor);
        }
        Component editor_component = editor.getCustomEditor();
        if (editor_component != null) {
            return editor_component;
        }
        return null;
    }

    public JButton getApplyButton() {
        return this.apply_button_;
    }

    public Insets getButtonInsets() {
        return this.button_insets_;
    }

    protected Component createButtons() {
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new BoxLayout(button_panel, 0));
        button_panel.add(Box.createGlue());
        int insets = my_resources_.getInt(KEY_BUTTONS_INSETS);
        this.button_insets_ = new Insets(insets, insets, insets, insets);
        this.apply_button_ = new JButton(my_resources_.getString(KEY_APPLY_BUTTON));
        this.apply_button_.setMargin(this.button_insets_);
        this.apply_button_.setActionCommand(APPLY_COMMAND);
        this.apply_button_.addActionListener(this);
        button_panel.add(this.apply_button_);
        button_panel.add(Box.createGlue());
        return button_panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEditors() {
        if (this.update_thread_ == null) {
            this.update_thread_ = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    ResourceEditorPanel.this.setAllEditors();
                                    this.wait();
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };
            this.update_thread_.start();
        } else {
            Thread thread = this.update_thread_;
            synchronized (thread) {
                this.update_thread_.notify();
            }
        }
    }

    protected void setAllEditors() {
        this.editor_panel_.removeAll();
        this.key_editor_map_.clear();
        TreeSet keys = new TreeSet();
        Enumeration enum_resources = edit_resources_.getKeys();
        while (enum_resources.hasMoreElements()) {
            keys.add(enum_resources.nextElement());
        }
        String[] groups = this.getChildren("resource.groups");
        boolean hide = false;
        for (int count = 0; count < groups.length; ++count) {
            String group_or_element = groups[count];
            if (!this.isResourceGroup(group_or_element)) continue;
            hide = this.isToHide(group_or_element);
            String[] sub_groups = this.getChildren(group_or_element);
            if (sub_groups.length <= 0) continue;
            JPanel group = null;
            for (int sub_count = 0; sub_count < sub_groups.length; ++sub_count) {
                String sub_group_or_element = sub_groups[sub_count];
                boolean bl = hide = hide && this.isToHide(sub_group_or_element);
                if (this.isResourceGroup(sub_group_or_element)) {
                    String[] sub_sub_groups = this.getChildren(sub_group_or_element);
                    if (sub_sub_groups.length <= 0) continue;
                    JPanel sub_group = null;
                    for (int sub_sub_count = 0; sub_sub_count < sub_sub_groups.length; ++sub_sub_count) {
                        String sub_sub_group_or_element = sub_sub_groups[sub_sub_count];
                        boolean bl2 = hide = hide && this.isToHide(sub_sub_group_or_element);
                        if (this.isResourceGroup(sub_sub_group_or_element)) continue;
                        if (!hide) {
                            if (group == null) {
                                group = this.createTab(group_or_element);
                                this.editor_panel_.addTab(this.getTitle(group_or_element), this.createTabWrapper(group));
                            }
                            if (sub_group == null) {
                                sub_group = this.createGroup(sub_group_or_element);
                                group.add(sub_group);
                            }
                            this.addEditor(sub_sub_group_or_element, sub_group);
                        }
                        keys.remove(sub_sub_group_or_element);
                    }
                    continue;
                }
                if (!hide) {
                    if (group == null) {
                        group = this.createTab(group_or_element);
                        this.editor_panel_.addTab(this.getTitle(group_or_element), this.createTabWrapper(group));
                    }
                    this.addEditor(sub_group_or_element, group);
                }
                keys.remove(sub_group_or_element);
            }
        }
        if (!this.isToHide(KEY_TAB_DEFAULT)) {
            JPanel default_panel = null;
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (this.isToHide(key)) continue;
                if (default_panel == null) {
                    default_panel = this.createTab("default");
                    this.editor_panel_.addTab(my_resources_.getString(KEY_TAB_DEFAULT), this.createTabWrapper(default_panel));
                }
                this.addEditor(key, default_panel);
            }
        }
        this.apply_button_.setEnabled(false);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void addEditor(String key, JPanel panel) {
        Component comp;
        boolean value_set;
        String description;
        String title;
        PropertyEditor editor;
        block12: {
            editor = this.getEditor(key);
            if (editor == null) {
                return;
            }
            title = edit_resources_.getTitle(key);
            if (title == null) {
                title = key;
            }
            description = edit_resources_.getDescription(key);
            value_set = false;
            try {
                if (!this.type_save_.contains(key)) break block12;
                try {
                    Object value = edit_resources_.get(key);
                    editor.setValue(value);
                }
                catch (MissingResourceException exc) {
                    editor.setValue(null);
                }
                value_set = true;
            }
            catch (IllegalArgumentException exc) {
                // empty catch block
            }
        }
        if (!value_set) {
            String string_value = "";
            try {
                string_value = edit_resources_.getString(key);
            }
            catch (MissingResourceException exc) {
                // empty catch block
            }
            try {
                editor.setAsText(string_value);
            }
            catch (IllegalArgumentException exc) {
                System.err.println(exc.getMessage());
                return;
            }
        }
        if ((comp = this.getEditingOrViewComponent(key, editor)) != null) {
            JPanel container_panel = new JPanel();
            container_panel.setLayout(new BorderLayout());
            container_panel.setBorder(BorderFactory.createTitledBorder(title));
            container_panel.add(comp, "Center");
            JButton info_button = new JButton(this.info_icon_);
            info_button.setMargin(new Insets(0, 0, 0, 0));
            info_button.addActionListener(new AbstractAction(description){

                public void actionPerformed(ActionEvent event) {
                    JOptionPane.showMessageDialog(ResourceEditorPanel.this, (String)this.getValue("Name"), "Description", 1);
                }
            });
            info_button.setEnabled(description != null);
            container_panel.add((Component)info_button, this.position_info_button_);
            panel.add(container_panel);
        }
    }

    private boolean isResourceGroup(String key) {
        return ResourceGroup.class == edit_resources_.getType(key);
    }

    private String[] getChildren(String key) {
        return edit_resources_.getStringArray(key, new String[0]);
    }

    private JPanel createTab(String key) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    private Component createTabWrapper(JPanel tab) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)tab, "North");
        JScrollPane scroll_pane = new JScrollPane(panel);
        return scroll_pane;
    }

    private JPanel createGroup(String key) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 0));
        panel.setBorder(BorderFactory.createTitledBorder(this.getTitle(key)));
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public String getTitle(String key) {
        String title = edit_resources_.getTitle(key);
        if (title == null) {
            title = key;
        }
        return title;
    }

    private boolean isToHide(String key) {
        return this.hide_key_set_.contains(key);
    }

    public void apply() {
        Iterator key_editor_map_iterator = this.key_editor_map_.keySet().iterator();
        boolean changed = false;
        while (key_editor_map_iterator.hasNext()) {
            String key = (String)key_editor_map_iterator.next();
            PropertyEditor editor = (PropertyEditor)this.key_editor_map_.get(key);
            String resource_value = edit_resources_.getString(key, null);
            String editors_value = editor.getAsText();
            if (ResourceEditorPanel.areEqual(editors_value, resource_value)) continue;
            if (editors_value == null) {
                edit_resources_.unset(key);
            } else {
                edit_resources_.setString(key, editors_value);
            }
            changed = true;
        }
        if (changed) {
            try {
                edit_resources_.store();
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
            int selected_tab = this.editor_panel_.getSelectedIndex();
            this.setAllEditors();
            this.editor_panel_.setSelectedIndex(selected_tab);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(APPLY_COMMAND)) {
            this.apply();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == my_resources_) {
            this.updateResources();
            this.invalidate();
            this.validate();
            this.repaint();
            return;
        }
        Iterator key_editor_map_iterator = this.key_editor_map_.keySet().iterator();
        boolean changed = false;
        while (key_editor_map_iterator.hasNext()) {
            Object resource_value;
            String key = (String)key_editor_map_iterator.next();
            PropertyEditor editor = (PropertyEditor)this.key_editor_map_.get(key);
            Object editors_value = editor.getValue();
            try {
                resource_value = edit_resources_.get(key);
            }
            catch (MissingResourceException exc) {
                resource_value = null;
            }
            catch (IllegalArgumentException exc) {
                resource_value = edit_resources_.getString(key);
                editors_value = editor.getAsText();
            }
            if (ResourceEditorPanel.areEqual(editors_value, resource_value)) continue;
            changed = true;
        }
        this.apply_button_.setEnabled(changed);
    }

    private static boolean areEqual(Object first, Object second) {
        if (first == second) {
            return true;
        }
        if (first != null) {
            return first.equals(second);
        }
        return false;
    }
}

