/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.dinopolis.util.ResourceManager;
import org.dinopolis.util.Resources;
import org.dinopolis.util.gui.ResourceEditorPanel;

public class ResourceEditorFrame
extends JFrame
implements ActionListener,
PropertyChangeListener {
    private static final String KEY_OK_BUTTON = "resource_editor.button.ok";
    private static final String OK_COMMAND = "ok";
    private static final String KEY_CANCEL_BUTTON = "resource_editor.button.cancel";
    private static final String CANCEL_COMMAND = "cancel";
    private static final String KEY_TITLE = "resource_editor.frame_title";
    private static final String KEY_WINDOW_DIMENSION_WIDTH = "resource_editor.dimension.width";
    private static final String KEY_WINDOW_DIMENSION_HEIGHT = "resource_editor.dimension.height";
    private static final String KEY_WINDOW_LOCATION_X = "resource_editor.location.x";
    private static final String KEY_WINDOW_LOCATION_Y = "resource_editor.location.y";
    private JButton ok_button_;
    private JButton cancel_button_;
    private JButton apply_button_;
    private Point stored_location_;
    private String title_;
    private ResourceEditorPanel editor_panel_;
    private boolean remember_;

    public ResourceEditorFrame(Resources resources) {
        this(resources, "resources");
    }

    public ResourceEditorFrame(Resources resources, String resource_dir) throws MissingResourceException {
        this(resources, resource_dir, null);
    }

    public ResourceEditorFrame(Resources resources, String resource_dir, String title) throws MissingResourceException {
        this.editor_panel_ = new ResourceEditorPanel(resources, resource_dir, false);
        ResourceEditorPanel.getResources().addPropertyChangeListener(this);
        this.title_ = title;
        if (this.title_ != null) {
            this.setTitle(this.title_);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.editor_panel_, "Center");
        this.getContentPane().add(this.createButtons(), "South");
        UIManager.addPropertyChangeListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (ResourceEditorFrame.this.remember_) {
                        ResourceEditorFrame.this.storeEditorResources();
                    }
                }
                catch (IOException ioe) {
                    System.err.println("Resources or resource editor could not be stored: " + ioe.getMessage());
                }
            }
        });
        this.updateLocation();
        this.updateSize();
        this.reset();
    }

    public void rememberSizeAndPosition(boolean remember) {
        this.remember_ = remember;
    }

    public void registerEditor(Class type, Class editor) {
        this.editor_panel_.registerEditor(type, editor);
    }

    void updateSize() {
        try {
            this.setSize(ResourceEditorPanel.getResources().getInt(KEY_WINDOW_DIMENSION_WIDTH), ResourceEditorPanel.getResources().getInt(KEY_WINDOW_DIMENSION_HEIGHT));
        }
        catch (MissingResourceException exc) {
            this.pack();
        }
        catch (NumberFormatException exc) {
            this.pack();
        }
    }

    void updateLocation() {
        try {
            this.setLocation(ResourceEditorPanel.getResources().getInt(KEY_WINDOW_LOCATION_X), ResourceEditorPanel.getResources().getInt(KEY_WINDOW_LOCATION_Y));
        }
        catch (MissingResourceException exc) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void updateResources() {
        if (this.title_ == null) {
            this.setTitle(ResourceEditorPanel.getResources().getString(KEY_TITLE));
        }
        if (this.ok_button_ != null) {
            this.ok_button_.setText(ResourceEditorPanel.getResources().getString(KEY_OK_BUTTON));
            this.ok_button_.setMargin(this.editor_panel_.getButtonInsets());
        }
        if (this.cancel_button_ != null) {
            this.cancel_button_.setText(ResourceEditorPanel.getResources().getString(KEY_CANCEL_BUTTON));
            this.cancel_button_.setMargin(this.editor_panel_.getButtonInsets());
        }
    }

    protected Component createButtons() {
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new BoxLayout(button_panel, 0));
        button_panel.add(Box.createGlue());
        this.ok_button_ = new JButton(ResourceEditorPanel.getResources().getString(KEY_OK_BUTTON));
        this.ok_button_.setMargin(this.editor_panel_.getButtonInsets());
        this.ok_button_.setActionCommand(OK_COMMAND);
        this.ok_button_.addActionListener(this);
        button_panel.add(this.ok_button_);
        this.cancel_button_ = new JButton(ResourceEditorPanel.getResources().getString(KEY_CANCEL_BUTTON));
        this.cancel_button_.setMargin(this.editor_panel_.getButtonInsets());
        this.cancel_button_.setActionCommand(CANCEL_COMMAND);
        this.cancel_button_.addActionListener(this);
        button_panel.add(this.cancel_button_);
        button_panel.add(this.editor_panel_.getApplyButton());
        button_panel.add(Box.createGlue());
        return button_panel;
    }

    public void setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            if (!visible) {
                this.stored_location_ = this.getLocationOnScreen();
                super.setVisible(visible);
                return;
            }
            super.setVisible(visible);
            if (this.stored_location_ != null) {
                this.setLocation(this.stored_location_);
            }
            return;
        }
        super.setVisible(visible);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(OK_COMMAND)) {
            this.editor_panel_.apply();
        }
        if (command.equals(OK_COMMAND) || command.equals(CANCEL_COMMAND)) {
            this.setVisible(false);
        }
    }

    public void reset() {
        Thread update_thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    ResourceEditorFrame.this.editor_panel_.setAllEditors();
                    ResourceEditorFrame.this.updateLocation();
                    ResourceEditorFrame.this.updateSize();
                }
            }
        };
        update_thread.start();
    }

    public void storeEditorResources() throws IOException, UnsupportedOperationException {
        Resources resources = ResourceEditorPanel.getResources();
        Point location = this.getLocation();
        Dimension dimension = this.getSize();
        resources.setInt(KEY_WINDOW_LOCATION_X, location.x);
        resources.setInt(KEY_WINDOW_LOCATION_Y, location.y);
        resources.setInt(KEY_WINDOW_DIMENSION_WIDTH, dimension.width);
        resources.setInt(KEY_WINDOW_DIMENSION_HEIGHT, dimension.height);
        ResourceEditorPanel.getResources().store();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == ResourceEditorPanel.getResources()) {
            this.updateResources();
            this.invalidate();
            this.validate();
            this.repaint();
            return;
        }
        if (event.getSource() == UIManager.class) {
            SwingUtilities.updateComponentTreeUI(this);
            this.updateSize();
        }
    }

    public static void main(String[] args) {
        try {
            Resources edit_resources = args.length <= 0 ? ResourceManager.getResources(ResourceEditorFrame.class, "ResourceEditor", "resources", Locale.getDefault()) : ResourceManager.getResources(Class.forName(args[0]), args[1], args[2], Locale.getDefault());
            ResourceEditorFrame frame = new ResourceEditorFrame(edit_resources);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

