/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.commandarguments;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dinopolis.util.commandarguments.CommandArgumentException;
import org.dinopolis.util.commandarguments.InvalidCommandArgumentException;
import org.dinopolis.util.commandarguments.InvalidCommandArgumentFormatException;

public class CommandArguments {
    Map args_;
    Map valid_args_ = new TreeMap();
    List real_arguments_;

    public CommandArguments(List args, String[] valid_args) throws CommandArgumentException {
        this(args.toArray(new String[args.size()]), valid_args);
    }

    public CommandArguments(String[] args, String[] valid_args) throws CommandArgumentException {
        this.args_ = new TreeMap();
        this.real_arguments_ = new ArrayList();
        for (int count = 0; count < valid_args.length; ++count) {
            String valid_arg = valid_args[count];
            int last_pos = valid_arg.length() - 1;
            if (last_pos < 0) continue;
            if (valid_arg.charAt(last_pos) == '#' || valid_arg.charAt(last_pos) == '%' || valid_arg.charAt(last_pos) == '*') {
                this.valid_args_.put(valid_arg.substring(0, last_pos), new Integer(valid_arg.charAt(last_pos)));
                continue;
            }
            this.valid_args_.put(valid_arg, new Integer(0));
        }
        for (int arg_count = 0; arg_count < args.length; ++arg_count) {
            String value;
            int token;
            String argument;
            String given_argument = args[arg_count];
            if (given_argument.startsWith("--")) {
                argument = given_argument.substring(2);
                if (!this.valid_args_.containsKey(argument)) {
                    throw new InvalidCommandArgumentException("Argument '" + argument + "' is not valid.", arg_count);
                }
                token = (Integer)this.valid_args_.get(argument);
                if (token == 0) {
                    this.args_.put(argument, null);
                    continue;
                }
                try {
                    value = args[++arg_count];
                    if (token == 42) {
                        this.args_.put(argument, value);
                        continue;
                    }
                    if (token == 35) {
                        this.args_.put(argument, new Integer(value));
                        continue;
                    }
                    if (token != 37) continue;
                    this.args_.put(argument, new Double(value));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidCommandArgumentFormatException("Invalid number format given for argument '" + argument + "'.", arg_count - 1);
                }
                catch (ArrayIndexOutOfBoundsException aiobe) {
                    throw new InvalidCommandArgumentFormatException("Missing value for argument '" + argument + "'.", arg_count - 1);
                }
            }
            if (given_argument.startsWith("-")) {
                int len = given_argument.length();
                for (int count_char = 1; count_char < len; ++count_char) {
                    argument = new String(new char[]{given_argument.charAt(count_char)});
                    if (!this.valid_args_.containsKey(argument)) {
                        throw new InvalidCommandArgumentException("Argument '" + argument + "' is not valid.", arg_count);
                    }
                    token = (Integer)this.valid_args_.get(argument);
                    if (token == 0) {
                        this.args_.put(argument, null);
                        continue;
                    }
                    try {
                        if (count_char == len - 1) {
                            value = args[++arg_count];
                        } else {
                            value = given_argument.substring(count_char + 1);
                            count_char = len;
                        }
                        if (token == 42) {
                            this.args_.put(argument, value);
                            continue;
                        }
                        if (token == 35) {
                            this.args_.put(argument, new Integer(value));
                            continue;
                        }
                        if (token != 37) continue;
                        this.args_.put(argument, new Double(value));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidCommandArgumentFormatException("Invalid number format given for argument '" + argument + "'.", arg_count - 1);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new InvalidCommandArgumentFormatException("Missing value for argument '" + argument + "'.", arg_count - 1);
                    }
                }
                continue;
            }
            this.real_arguments_.add(given_argument);
        }
    }

    public boolean isSet(String option_name) {
        return this.args_.containsKey(option_name);
    }

    public Object getValue(String option_name) {
        return this.args_.get(option_name);
    }

    public String getStringValue(String option_name) {
        return (String)this.args_.get(option_name);
    }

    public Integer getIntegerValue(String option_name) {
        return (Integer)this.args_.get(option_name);
    }

    public Double getDoubleValue(String option_name) {
        return (Double)this.args_.get(option_name);
    }

    public String getArgumentAt(int position) {
        return (String)this.real_arguments_.get(position);
    }

    public List getArguments() {
        return new ArrayList(this.real_arguments_);
    }

    public int length() {
        return this.real_arguments_.size();
    }
}

