/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.wiki.service;

import java.net.URISyntaxException;
import java.net.URL;
import org.debux.webmotion.server.mapping.Properties;

public class WikiConfig {
    public static WikiConfig instance;
    public static final String PROPERTY_SITE_NAME = "site.name";
    public static final String PROPERTY_FILE_PATH = "file.path";
    public static final String PROPERTY_MEDIA_PATH = "media.path";
    public static final String PROPERTY_FIRST_PAGE = "first.page";
    public static final String PROPERTY_DEFAULT_LANGUAGE = "default.language";
    public static final String PROPERTY_SUPPORTED_LANGUAGE = "supported.language";
    public static final String PROPERTY_PUBLIC_PERMISSIONS = "public.permissions";
    public static final String PROPERTY_USERS_PATH = "users.path";
    protected Properties properties;

    public WikiConfig(Properties properties) {
        this.properties = properties;
    }

    public String getSiteName() {
        return this.properties.getString(PROPERTY_SITE_NAME);
    }

    public String getFilePath() throws URISyntaxException {
        return this.getPath(PROPERTY_FILE_PATH);
    }

    public String getMediaPath() throws URISyntaxException {
        return this.getPath(PROPERTY_MEDIA_PATH);
    }

    public String getFirstPage() {
        return this.properties.getString(PROPERTY_FIRST_PAGE);
    }

    public String getDefaultLanguage() {
        return this.properties.getString(PROPERTY_DEFAULT_LANGUAGE);
    }

    public String[] getSupportedLanguage() {
        return this.properties.getStringArray(PROPERTY_SUPPORTED_LANGUAGE);
    }

    public String[] getPublicPermissions() {
        return this.properties.getStringArray(PROPERTY_PUBLIC_PERMISSIONS);
    }

    public String getUsersPath() throws URISyntaxException {
        return this.getPath(PROPERTY_USERS_PATH);
    }

    public String getPath(String key) throws URISyntaxException {
        String filePath = this.properties.getString(key);
        if (filePath.startsWith("classpath:")) {
            filePath = filePath.replaceFirst("classpath:", "");
            URL url = WikiConfig.class.getClassLoader().getResource(filePath);
            filePath = url.getFile();
        }
        return filePath;
    }
}

