/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.sitemesh;

import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.debux.webmotion.server.WebMotionServerListener;
import org.debux.webmotion.server.call.ServerContext;
import org.debux.webmotion.server.mapping.Mapping;
import org.debux.webmotion.sitemesh.SiteMesh;
import org.sitemesh.DecoratorSelector;
import org.sitemesh.SiteMeshContext;
import org.sitemesh.builder.SiteMeshFilterBuilder;
import org.sitemesh.config.ConfigurableSiteMeshFilter;
import org.sitemesh.config.PathBasedDecoratorSelector;
import org.sitemesh.content.Content;
import org.sitemesh.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteMeshListener
implements WebMotionServerListener {
    private static final Logger log = LoggerFactory.getLogger(SiteMeshListener.class);
    protected static Filter filter = new ConfigurableSiteMeshFilter(){

        protected void applyCustomConfiguration(SiteMeshFilterBuilder builder) {
            builder.setCustomDecoratorSelector((DecoratorSelector)new PathBasedDecoratorSelector<WebAppContext>(){

                public String[] selectDecoratorPaths(Content content, WebAppContext siteMeshContext) throws IOException {
                    HttpServletRequest request = siteMeshContext.getRequest();
                    String[] layouts = (String[])request.getAttribute("sitemesh_layouts");
                    if (layouts != null) {
                        return layouts;
                    }
                    String[] selectDecoratorPaths = super.selectDecoratorPaths(content, (SiteMeshContext)siteMeshContext);
                    return selectDecoratorPaths;
                }
            });
        }
    };

    public void onStart(Mapping mapping, ServerContext context) {
        ServletContext servletContext = context.getServletContext();
        FilterRegistration.Dynamic registration = servletContext.addFilter("sitemesh", filter);
        registration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.FORWARD, DispatcherType.INCLUDE), true, new String[]{"/*"});
        context.addGlobalController(SiteMesh.class);
    }

    public void onStop(ServerContext context) {
    }
}

