/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.util.List;
import org.chorem.pollen.persistence.entity.LoginProvider;
import org.chorem.pollen.persistence.entity.LoginProviderDao;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.UserCredential;
import org.chorem.pollen.services.bean.LoginProviderBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.service.PollenServiceSupport;

public class SocialAuthService
extends PollenServiceSupport {
    public LoginProviderBean toLoginProviderBean(LoginProvider entity) {
        LoginProviderBean bean = new LoginProviderBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setName(entity.getName());
        bean.setKey(entity.getKey());
        bean.setSecret(entity.getSecret());
        bean.setPermissions(entity.getPermissions());
        bean.setActive(entity.isActive());
        return bean;
    }

    public List<LoginProviderBean> getAllLoginProviders() {
        this.checkIsAdmin();
        LoginProviderDao dao = this.getLoginProviderDao();
        return dao.findAll().stream().map(this::toLoginProviderBean).toList();
    }

    public List<String> getActiveLoginProviders() {
        return List.of();
    }

    public List<String> getAvailableLoginProviders() {
        this.checkIsAdmin();
        return List.of("amazon", "facebook", "flickr", "foursquare", "github", "googleplus", "hotmail", "instagram", "linkedin", "linkedin2", "mendeley", "myspace", "nimble", "runkeeper", "salesforce", "stackexchange", "twitter", "yahoo", "yammer");
    }

    public LoginProviderBean saveLoginProvider(LoginProviderBean loginProvider, boolean loginProviderExists) {
        this.checkIsAdmin();
        this.checkNotNull(loginProvider);
        LoginProviderDao dao = this.getLoginProviderDao();
        LoginProvider toSave = loginProviderExists ? (LoginProvider)dao.forTopiaIdEquals(loginProvider.getEntityId()).findUnique() : (LoginProvider)dao.create();
        toSave.setName(loginProvider.getName());
        toSave.setKey(loginProvider.getKey());
        toSave.setSecret(loginProvider.getSecret());
        toSave.setPermissions(loginProvider.getPermissions());
        toSave.setActive(loginProvider.isActive());
        this.commit();
        return this.toLoginProviderBean(toSave);
    }

    public void deleteLoginProvider(String providerId) {
        this.checkIsAdmin();
        this.checkNotNull(providerId);
        LoginProviderDao dao = this.getLoginProviderDao();
        LoginProvider loginProviderToDelete = (LoginProvider)dao.forTopiaIdEquals(providerId).findUnique();
        dao.delete(loginProviderToDelete);
        this.commit();
    }

    public void deleteUserCredential(PollenEntityId<UserCredential> credentialId) {
        this.checkNotNull(credentialId);
        PollenUser pollenUser = this.checkAndGetConnectedUser();
        UserCredential credentialToDelete = pollenUser.getUserCredentialByTopiaId(credentialId.getEntityId());
        this.getUserCredentialDao().delete(credentialToDelete);
        this.commit();
    }
}

