/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.bean.FavoriteListMemberBean;
import org.chorem.pollen.services.service.FavoriteListImportReader;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ext.AbstractImportModel;

public class FavoriteListImportReaderFromFile
implements FavoriteListImportReader {
    private final File file;

    public FavoriteListImportReaderFromFile(File file) {
        this.file = file;
    }

    @Override
    public List<FavoriteListMemberBean> read(Function<String, String> emailCleaner) {
        LinkedList<FavoriteListMemberBean> result = new LinkedList<FavoriteListMemberBean>();
        FavoriteListMemberBeanCSVModel importModel = new FavoriteListMemberBeanCSVModel(emailCleaner);
        try (BufferedReader reader = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);
             Import members = Import.newImport((ImportModel)importModel, (Reader)reader);){
            for (FavoriteListMemberBean member : members) {
                result.add(member);
            }
        }
        catch (IOException ioe) {
            throw new PollenTechnicalException(ioe);
        }
        return result;
    }

    private static class FavoriteListMemberBeanCSVModel
    extends AbstractImportModel<FavoriteListMemberBean> {
        private final Function<String, String> emailCleaner;

        public FavoriteListMemberBeanCSVModel(Function<String, String> emailCleaner) {
            super(';');
            this.emailCleaner = emailCleaner;
        }

        public FavoriteListMemberBean newEmptyInstance() {
            return new FavoriteListMemberBean();
        }

        public void pushCsvHeaderNames(List<String> headerNames) {
            this.newMandatoryColumn("Name", FavoriteListMemberBean::setName);
            this.newMandatoryColumn("Email", this.emailCleaner::apply, FavoriteListMemberBean::setEmail);
            this.newOptionalColumn("Weight", rawWeight -> StringUtils.isNotBlank((CharSequence)rawWeight) ? Double.parseDouble(rawWeight) : 1.0, FavoriteListMemberBean::setWeight);
        }
    }
}

