/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.nio.win32;

import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.thread.ThreadRequest;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.nio.AsynchronousWritesHandler;
import org.alfresco.jlan.smb.server.nio.win32.AsyncWinsockCIFSRequestHandler;

public class AsyncWinsockCIFSWriteRequest
implements ThreadRequest {
    private SMBSrvSession m_sess;
    private int m_socketEvent;
    private AsyncWinsockCIFSRequestHandler m_reqHandler;

    public AsyncWinsockCIFSWriteRequest(SMBSrvSession sess, int sockEvent, AsyncWinsockCIFSRequestHandler reqHandler) {
        this.m_sess = sess;
        this.m_socketEvent = sockEvent;
        this.m_reqHandler = reqHandler;
    }

    @Override
    public void runRequest() {
        if (!this.m_sess.isShutdown() && this.m_sess.getPacketHandler() instanceof AsynchronousWritesHandler) {
            try {
                AsynchronousWritesHandler writeHandler = (AsynchronousWritesHandler)((Object)this.m_sess.getPacketHandler());
                if (writeHandler.getQueuedWriteCount() > 0) {
                    Debug.println("%%% Processing queued writes, queued=" + writeHandler.getQueuedWriteCount() + " %%%");
                    int wrCnt = writeHandler.processQueuedWrites();
                    Debug.println("%%% Processed " + wrCnt + " queued write requests, queued=" + writeHandler.getQueuedWriteCount() + " %%%");
                }
            }
            catch (Throwable ex) {
                Debug.println(ex);
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Async Winsock CIFS Sess=");
        str.append(this.m_sess.getUniqueId());
        str.append("-Write]");
        return str.toString();
    }
}

