/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.PacketHandler;

public abstract class ChannelPacketHandler
extends PacketHandler {
    private SocketChannel m_sockChannel;
    protected byte[] m_headerBuf = new byte[4];

    public ChannelPacketHandler(SocketChannel sockChannel, int typ, String name, String shortName, CIFSPacketPool packetPool) throws IOException {
        super(typ, name, shortName, packetPool);
        this.m_sockChannel = sockChannel;
        this.m_sockChannel.socket().setTcpNoDelay(true);
        this.setRemoteAddress(this.m_sockChannel.socket().getInetAddress());
    }

    public final SocketChannel getSocketChannel() {
        return this.m_sockChannel;
    }

    @Override
    public int availableBytes() throws IOException {
        return 0;
    }

    protected int readBytes(byte[] pkt, int offset, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(pkt, offset, len);
        return this.m_sockChannel.read(buf);
    }

    protected void writeBytes(byte[] pkt, int off, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(pkt, off, len);
        while (buf.hasRemaining()) {
            this.m_sockChannel.write(buf);
        }
    }

    @Override
    public void flushPacket() throws IOException {
    }

    @Override
    public void closeHandler() {
        if (this.m_sockChannel != null) {
            try {
                if (this.m_sockChannel.socket() != null) {
                    this.m_sockChannel.socket().close();
                }
                this.m_sockChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

