/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.util.DataPacker;

public class NTTransPacket
extends SMBSrvPacket {
    private static final int StandardParams = 19;
    private static final int ParameterBytes = 36;
    private static final int ReplyParams = 18;
    private static final int NTMaxSetupCount = 37;
    private static final int NTParams = 40;
    private static final int NTSetupCount = 72;
    private static final int NTFunction = 73;
    private static final int DefaultReturnParams = 4;
    private static final int DefaultReturnData = 1024;

    public NTTransPacket() {
    }

    public NTTransPacket(byte[] buf) {
        super(buf);
    }

    public NTTransPacket(NTTransPacket pkt) {
        super(pkt);
    }

    public final int getDataLength() {
        return this.getNTParameter(6);
    }

    public final int getDataOffset() {
        return this.getNTParameter(7) + 4;
    }

    public final int[] getParameterBlock() {
        int prmcnt = this.getParameterBlockCount() / 4;
        if (prmcnt <= 0) {
            return null;
        }
        int[] prmblk = new int[prmcnt];
        int pos = this.getParameterBlockOffset();
        this.setBytePointer(pos, this.getByteCount());
        for (int idx = 0; idx < prmcnt; ++idx) {
            prmblk[idx] = this.unpackInt();
        }
        return prmblk;
    }

    public final int getTotalParameterCount() {
        return this.getNTParameter(0);
    }

    public final int getTotalDataCount() {
        return this.getNTParameter(1);
    }

    public final int getMaximumParameterReturn() {
        return this.getNTParameter(2);
    }

    public final int getMaximumDataReturn() {
        return this.getNTParameter(3);
    }

    public final int getParameterBlockCount() {
        return this.getNTParameter(this.getCommand() == 160 ? 4 : 2);
    }

    public final int getParameterBlockOffset() {
        return this.getNTParameter(this.getCommand() == 160 ? 5 : 3) + 4;
    }

    public final int getParameterBlockDisplacement() {
        return this.getNTParameter(4);
    }

    public final int getDataBlockCount() {
        return this.getNTParameter(this.getCommand() == 160 ? 6 : 5);
    }

    public final int getDataBlockOffset() {
        return this.getNTParameter(this.getCommand() == 160 ? 7 : 6) + 4;
    }

    public final int getDataBlockDisplacement() {
        return this.getNTParameter(7);
    }

    protected final int getNTParameter(int idx) {
        int pos = 40 + 4 * idx;
        return DataPacker.getIntelInt(this.getBuffer(), pos);
    }

    public final int getSetupCount() {
        byte[] buf = this.getBuffer();
        return buf[72] & 0xFF;
    }

    public final int getSetupOffset() {
        return 75;
    }

    public final int getNTFunction() {
        byte[] buf = this.getBuffer();
        return DataPacker.getIntelShort(buf, 73);
    }

    public static final int calculateResponseLength(int plen, int dlen, int setupcnt) {
        return 33 + (18 + setupcnt) * 2 + plen + dlen;
    }

    public final void initTransact(int func, byte[] paramblk, int plen, byte[] datablk, int dlen, int setupcnt) {
        this.initTransact(func, paramblk, plen, datablk, dlen, setupcnt, 4, 1024);
    }

    public final void initTransact(int func, byte[] paramblk, int plen, byte[] datablk, int dlen, int setupcnt, int maxPrm, int maxData) {
        this.setCommand(160);
        this.setParameterCount(19 + setupcnt);
        this.setTotalParameterCount(plen);
        this.setTotalDataCount(dlen);
        this.setMaximumParameterReturn(maxPrm);
        this.setMaximumDataReturn(maxData);
        this.setParameterCount(plen);
        this.setParameterBlockOffset(0);
        this.setDataBlockCount(dlen);
        this.setDataBlockOffset(0);
        this.setSetupCount(setupcnt);
        this.setNTFunction(func);
        this.resetBytePointerAlign();
        if (paramblk != null) {
            this.setParameterBlockOffset(this.getPosition());
            this.packBytes(paramblk, plen);
        }
        if (datablk != null) {
            this.alignBytePointer();
            this.setDataBlockOffset(this.getPosition());
            this.packBytes(datablk, dlen);
        }
        this.setByteCount();
    }

    public final void initTransactReply(byte[] paramblk, int plen, byte[] datablk, int dlen) {
        this.setParameterCount(18);
        this.setSetupCount(0);
        this.setTotalParameterCount(plen);
        this.setTotalDataCount(dlen);
        this.setReplyParameterCount(plen);
        this.setReplyParameterOffset(0);
        this.setReplyParameterDisplacement(0);
        this.setReplyDataCount(dlen);
        this.setDataBlockOffset(0);
        this.setReplyDataDisplacement(0);
        this.setSetupCount(0);
        this.resetBytePointerAlign();
        if (paramblk != null) {
            this.setReplyParameterOffset(this.getPosition() - 4);
            this.packBytes(paramblk, plen);
        }
        if (datablk != null) {
            this.alignBytePointer();
            this.setReplyDataOffset(this.getPosition() - 4);
            this.packBytes(datablk, dlen);
        }
        this.setByteCount();
    }

    public final void initTransactReply(byte[] paramblk, int plen, byte[] datablk, int dlen, int setupCnt) {
        this.setParameterCount(18 + setupCnt);
        this.setSetupCount(setupCnt);
        this.setTotalParameterCount(plen);
        this.setTotalDataCount(dlen);
        this.setReplyParameterCount(plen);
        this.setReplyParameterOffset(0);
        this.setReplyParameterDisplacement(0);
        this.setReplyDataCount(dlen);
        this.setDataBlockOffset(0);
        this.setReplyDataDisplacement(0);
        this.setSetupCount(setupCnt);
        this.resetBytePointerAlign();
        if (paramblk != null) {
            this.setReplyParameterOffset(this.getPosition() - 4);
            this.packBytes(paramblk, plen);
        }
        if (datablk != null) {
            this.alignBytePointer();
            this.setReplyDataOffset(this.getPosition() - 4);
            this.packBytes(datablk, dlen);
        }
        this.setByteCount();
    }

    public final void setTotalParameterCount(int cnt) {
        this.setNTParameter(0, cnt);
    }

    public final void setTotalDataCount(int cnt) {
        this.setNTParameter(1, cnt);
    }

    public final void setMaximumParameterReturn(int cnt) {
        this.setNTParameter(2, cnt);
    }

    public final void setMaximumDataReturn(int cnt) {
        this.setNTParameter(3, cnt);
    }

    public final void setTransactParameterCount(int cnt) {
        this.setNTParameter(4, cnt);
    }

    public final void setReplyParameterCount(int cnt) {
        this.setNTParameter(2, cnt);
    }

    public final void setReplyParameterOffset(int off) {
        this.setNTParameter(3, off);
    }

    public final void setReplyParameterDisplacement(int disp) {
        this.setNTParameter(4, disp);
    }

    public final void setReplyDataCount(int cnt) {
        this.setNTParameter(5, cnt);
    }

    public final void setReplyDataOffset(int off) {
        this.setNTParameter(6, off);
    }

    public final void setReplyDataDisplacement(int disp) {
        this.setNTParameter(7, disp);
    }

    public final void setParameterBlockOffset(int off) {
        this.setNTParameter(5, off != 0 ? off - 4 : 0);
    }

    public final void setDataBlockCount(int cnt) {
        this.setNTParameter(6, cnt);
    }

    public final void setDataBlockOffset(int off) {
        this.setNTParameter(7, off != 0 ? off - 4 : 0);
    }

    public final void setNTParameter(int idx, int val) {
        int pos = 40 + 4 * idx;
        DataPacker.putIntelInt(val, this.getBuffer(), pos);
    }

    public final void setMaximumSetupCount(int cnt) {
        byte[] buf = this.getBuffer();
        buf[37] = (byte)cnt;
    }

    public final void setSetupCount(int cnt) {
        byte[] buf = this.getBuffer();
        buf[72] = (byte)cnt;
    }

    public final void setSetupParameter(int setupIdx, int setupVal) {
        int pos = 73 + setupIdx * 2;
        DataPacker.putIntelShort(setupVal, this.getBuffer(), pos);
    }

    public final void setNTFunction(int func) {
        byte[] buf = this.getBuffer();
        DataPacker.putIntelShort(func, buf, 73);
    }

    public final void resetSetupPointer() {
        this.m_endpos = this.m_pos = 75;
    }

    public final void resetDataBlockPointer() {
        this.m_endpos = this.m_pos = this.getDataBlockOffset();
    }

    public final void resetParameterBlockPointer() {
        this.m_endpos = this.m_pos = this.getParameterBlockOffset();
    }
}

